/*M!999999\- enable the sandbox mode */ 
-- MariaDB dump 10.19-11.8.2-MariaDB, for Win64 (AMD64)
--
-- Host: localhost    Database: refugiosc
-- ------------------------------------------------------
-- Server version	11.8.2-MariaDB

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*M!100616 SET @OLD_NOTE_VERBOSITY=@@NOTE_VERBOSITY, NOTE_VERBOSITY=0 */;

--
-- Table structure for table `allowlist_codes`
--

DROP TABLE IF EXISTS `allowlist_codes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `allowlist_codes` (
  `codigo` varchar(16) NOT NULL,
  `criador` varchar(64) DEFAULT NULL,
  `validade` bigint(20) DEFAULT NULL,
  `criado_em` bigint(20) DEFAULT NULL,
  `usado_por` varchar(64) DEFAULT NULL,
  `usado_em` bigint(20) DEFAULT NULL,
  `qtd` smallint(6) DEFAULT 1,
  PRIMARY KEY (`codigo`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `allowlist_codes`
--

LOCK TABLES `allowlist_codes` WRITE;
/*!40000 ALTER TABLE `allowlist_codes` DISABLE KEYS */;
set autocommit=0;
/*!40000 ALTER TABLE `allowlist_codes` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Table structure for table `allowlist_codes_uses`
--

DROP TABLE IF EXISTS `allowlist_codes_uses`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `allowlist_codes_uses` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `codigo` varchar(16) NOT NULL,
  `usado_por` varchar(64) NOT NULL,
  `usado_em` bigint(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `codigo` (`codigo`),
  CONSTRAINT `fk_codes_uses_code` FOREIGN KEY (`codigo`) REFERENCES `allowlist_codes` (`codigo`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=75 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `allowlist_codes_uses`
--

LOCK TABLES `allowlist_codes_uses` WRITE;
/*!40000 ALTER TABLE `allowlist_codes_uses` DISABLE KEYS */;
set autocommit=0;
/*!40000 ALTER TABLE `allowlist_codes_uses` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Table structure for table `allowlist_progress`
--

DROP TABLE IF EXISTS `allowlist_progress`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `allowlist_progress` (
  `user_id` varchar(64) NOT NULL,
  `channel_id` varchar(64) DEFAULT NULL,
  `current_question` int(11) DEFAULT NULL,
  `answers` text DEFAULT NULL,
  `started_at` bigint(20) DEFAULT NULL,
  `steamhex` text DEFAULT NULL,
  PRIMARY KEY (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `allowlist_progress`
--

LOCK TABLES `allowlist_progress` WRITE;
/*!40000 ALTER TABLE `allowlist_progress` DISABLE KEYS */;
set autocommit=0;
/*!40000 ALTER TABLE `allowlist_progress` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Table structure for table `approvals`
--

DROP TABLE IF EXISTS `approvals`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `approvals` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `sale_id` bigint(20) unsigned NOT NULL,
  `installment_index` smallint(5) unsigned DEFAULT NULL,
  `approver_id` varchar(32) NOT NULL,
  `decision` enum('APPROVED','REJECTED') NOT NULL,
  `reason` varchar(512) DEFAULT NULL,
  `created_at` datetime NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `idx_approvals_sale` (`sale_id`),
  CONSTRAINT `fk_approvals_sale` FOREIGN KEY (`sale_id`) REFERENCES `sales` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=33 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_uca1400_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `approvals`
--

LOCK TABLES `approvals` WRITE;
/*!40000 ALTER TABLE `approvals` DISABLE KEYS */;
set autocommit=0;
/*!40000 ALTER TABLE `approvals` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Table structure for table `audit_logs`
--

DROP TABLE IF EXISTS `audit_logs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `audit_logs` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `category` enum('SALE','APPROVAL','PAYMENT','NOTIFICATION','ERROR') NOT NULL,
  `sale_id` bigint(20) unsigned DEFAULT NULL,
  `actor_id` varchar(32) DEFAULT NULL,
  `summary` varchar(256) NOT NULL,
  `details_json` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`details_json`)),
  `created_at` datetime NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `idx_audit_category` (`category`),
  KEY `idx_audit_sale` (`sale_id`),
  KEY `idx_audit_created` (`created_at`),
  CONSTRAINT `fk_audit_sale` FOREIGN KEY (`sale_id`) REFERENCES `sales` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=374 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_uca1400_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `audit_logs`
--

LOCK TABLES `audit_logs` WRITE;
/*!40000 ALTER TABLE `audit_logs` DISABLE KEYS */;
set autocommit=0;
/*!40000 ALTER TABLE `audit_logs` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Table structure for table `customers`
--

DROP TABLE IF EXISTS `customers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `customers` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `discord_id` varchar(32) NOT NULL,
  `username` varchar(64) DEFAULT NULL,
  `created_at` datetime NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  UNIQUE KEY `discord_id` (`discord_id`)
) ENGINE=InnoDB AUTO_INCREMENT=25 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_uca1400_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `customers`
--

LOCK TABLES `customers` WRITE;
/*!40000 ALTER TABLE `customers` DISABLE KEYS */;
set autocommit=0;
INSERT INTO `customers` VALUES
(1,'659918884844994603','zsraphael','2025-09-15 15:02:20'),
(2,'400712876056117248','zsgabriel','2025-09-15 16:50:27'),
(3,'611975873830060046','brunoosband','2025-09-15 21:58:18'),
(4,'679098737867489284','bibs_tx','2025-09-15 22:02:14'),
(5,'407973534078337034','bezoleta','2025-09-15 22:08:34'),
(6,'1257016008032653312','lucasheidemann','2025-09-15 22:28:45'),
(7,'671885268852408360','williansdp3718','2025-09-16 00:15:51'),
(8,'328992511186173964','samuraizk1_','2025-09-17 01:13:51'),
(9,'1066400363080601693','244lukinha','2025-09-21 21:09:26'),
(10,'1212225325254053888','geovaniklens2','2025-09-22 22:33:34'),
(11,'457600723765690388','pirataa_00','2025-09-24 21:44:34'),
(12,'1030855412943167578','ohguerra','2025-09-24 21:45:36'),
(13,'1063941104954781726','cassiki8732','2025-09-25 19:23:52'),
(14,'694006924290555944','lu1zzz0880','2025-09-27 03:04:54'),
(15,'1338982801730572452','viniciussouza123','2025-09-28 21:27:35'),
(16,'713396633420955679','cassiorpz','2025-09-29 19:26:02'),
(17,'411946892570656781','juliocrei','2025-09-29 21:35:01'),
(18,'450826023098122241','krs69','2025-09-29 23:28:56'),
(19,'489941571731456020','matheuslira_','2025-10-01 21:58:08'),
(20,'1372678821324652616','pedrodybala0809','2025-10-03 13:12:46'),
(21,'1005650849109905429','zghost_97','2025-10-04 02:25:23'),
(22,'278238686859231232','ghostslx','2025-10-06 00:55:40'),
(23,'692180947990216725','ipguh.','2025-10-06 21:41:53'),
(24,'818636919981211658','cubaza1450','2025-10-08 21:13:01');
/*!40000 ALTER TABLE `customers` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Table structure for table `dm_schedules`
--

DROP TABLE IF EXISTS `dm_schedules`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `dm_schedules` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `sale_id` bigint(20) unsigned NOT NULL,
  `installment_index` smallint(5) unsigned DEFAULT NULL,
  `schedule_type` enum('DM_MINUS_72','DM_MINUS_48','DM_MINUS_24','DM_DAY','DM_PLUS_24','DM_PLUS_48','DM_PLUS_72') NOT NULL,
  `run_at` datetime NOT NULL,
  `executed_at` datetime DEFAULT NULL,
  `canceled_at` datetime DEFAULT NULL,
  `meta_json` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`meta_json`)),
  `created_at` datetime NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  UNIQUE KEY `uq_dm_schedule` (`sale_id`,`installment_index`,`schedule_type`),
  KEY `idx_dm_schedules_run` (`run_at`),
  KEY `idx_dm_schedules_state` (`executed_at`,`canceled_at`),
  CONSTRAINT `fk_dm_schedules_sale` FOREIGN KEY (`sale_id`) REFERENCES `sales` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=422 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_uca1400_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `dm_schedules`
--

LOCK TABLES `dm_schedules` WRITE;
/*!40000 ALTER TABLE `dm_schedules` DISABLE KEYS */;
set autocommit=0;
/*!40000 ALTER TABLE `dm_schedules` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Table structure for table `influencer_benefits`
--

DROP TABLE IF EXISTS `influencer_benefits`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `influencer_benefits` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` varchar(50) NOT NULL,
  `platform` varchar(50) NOT NULL,
  `benefit_type` varchar(50) NOT NULL,
  `character_id` int(11) NOT NULL,
  `applied_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  UNIQUE KEY `unique_benefit` (`user_id`,`platform`,`benefit_type`)
) ENGINE=InnoDB AUTO_INCREMENT=123 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `influencer_benefits`
--

LOCK TABLES `influencer_benefits` WRITE;
/*!40000 ALTER TABLE `influencer_benefits` DISABLE KEYS */;
set autocommit=0;
/*!40000 ALTER TABLE `influencer_benefits` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Table structure for table `influencer_benefits_requested`
--

DROP TABLE IF EXISTS `influencer_benefits_requested`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `influencer_benefits_requested` (
  `request_id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` varchar(255) NOT NULL,
  `platform` varchar(255) NOT NULL,
  `benefit_level` varchar(255) NOT NULL,
  `request_code` varchar(36) NOT NULL,
  `status` varchar(50) DEFAULT 'pending',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`request_id`)
) ENGINE=InnoDB AUTO_INCREMENT=287 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `influencer_benefits_requested`
--

LOCK TABLES `influencer_benefits_requested` WRITE;
/*!40000 ALTER TABLE `influencer_benefits_requested` DISABLE KEYS */;
set autocommit=0;
/*!40000 ALTER TABLE `influencer_benefits_requested` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Table structure for table `influencer_updates`
--

DROP TABLE IF EXISTS `influencer_updates`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `influencer_updates` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `influencer_id` int(11) NOT NULL,
  `character_id` varchar(50) NOT NULL,
  `platform` varchar(50) NOT NULL,
  `content_link` varchar(255) NOT NULL,
  `content_description` text DEFAULT NULL,
  `updated_at` datetime NOT NULL DEFAULT current_timestamp(),
  `photos` int(11) DEFAULT 0,
  `reels` int(11) DEFAULT 0,
  `lives` int(11) DEFAULT 0,
  `videos` int(11) DEFAULT 0,
  PRIMARY KEY (`id`),
  KEY `influencer_id` (`influencer_id`),
  CONSTRAINT `influencer_updates_ibfk_1` FOREIGN KEY (`influencer_id`) REFERENCES `influencers_approved` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=1261 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `influencer_updates`
--

LOCK TABLES `influencer_updates` WRITE;
/*!40000 ALTER TABLE `influencer_updates` DISABLE KEYS */;
set autocommit=0;
/*!40000 ALTER TABLE `influencer_updates` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Table structure for table `influencers_approved`
--

DROP TABLE IF EXISTS `influencers_approved`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `influencers_approved` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` varchar(50) NOT NULL,
  `name` varchar(100) NOT NULL,
  `character_id` varchar(50) NOT NULL,
  `platform` varchar(50) NOT NULL,
  `profile_link` text NOT NULL,
  `has_previous` tinyint(1) NOT NULL,
  `approved_by` varchar(50) NOT NULL,
  `approved_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `last_reminder_sent` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=229 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `influencers_approved`
--

LOCK TABLES `influencers_approved` WRITE;
/*!40000 ALTER TABLE `influencers_approved` DISABLE KEYS */;
set autocommit=0;
/*!40000 ALTER TABLE `influencers_approved` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Table structure for table `influencers_requested`
--

DROP TABLE IF EXISTS `influencers_requested`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `influencers_requested` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` varchar(50) NOT NULL,
  `name` varchar(100) NOT NULL,
  `character_id` varchar(50) NOT NULL,
  `platform` varchar(50) NOT NULL,
  `profile_link` text NOT NULL,
  `has_previous` tinyint(1) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=262 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `influencers_requested`
--

LOCK TABLES `influencers_requested` WRITE;
/*!40000 ALTER TABLE `influencers_requested` DISABLE KEYS */;
set autocommit=0;
/*!40000 ALTER TABLE `influencers_requested` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Table structure for table `installments`
--

DROP TABLE IF EXISTS `installments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `installments` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `sale_id` bigint(20) unsigned NOT NULL,
  `installment_index` smallint(5) unsigned NOT NULL,
  `due_date` datetime NOT NULL,
  `amount_cents` int(10) unsigned NOT NULL,
  `status` enum('PENDING','PAID','OVERDUE','CANCELED') NOT NULL DEFAULT 'PENDING',
  `paid_at` datetime DEFAULT NULL,
  `payment_id` bigint(20) unsigned DEFAULT NULL,
  `created_at` datetime NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  UNIQUE KEY `uq_sale_installment` (`sale_id`,`installment_index`),
  KEY `idx_installments_due` (`due_date`),
  KEY `idx_installments_status` (`status`),
  CONSTRAINT `fk_installments_sale` FOREIGN KEY (`sale_id`) REFERENCES `sales` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=99 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_uca1400_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `installments`
--

LOCK TABLES `installments` WRITE;
/*!40000 ALTER TABLE `installments` DISABLE KEYS */;
set autocommit=0;
/*!40000 ALTER TABLE `installments` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Table structure for table `keystore`
--

DROP TABLE IF EXISTS `keystore`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `keystore` (
  `key` varchar(255) NOT NULL,
  `value` text NOT NULL,
  PRIMARY KEY (`key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `keystore`
--

LOCK TABLES `keystore` WRITE;
/*!40000 ALTER TABLE `keystore` DISABLE KEYS */;
set autocommit=0;
/*!40000 ALTER TABLE `keystore` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Table structure for table `payments`
--

DROP TABLE IF EXISTS `payments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `payments` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `sale_id` bigint(20) unsigned NOT NULL,
  `installment_index` smallint(5) unsigned DEFAULT NULL,
  `amount_cents` int(10) unsigned NOT NULL,
  `method` varchar(16) NOT NULL DEFAULT 'PIX',
  `status` enum('PENDING','APPROVED','REJECTED') NOT NULL DEFAULT 'PENDING',
  `created_by` varchar(32) NOT NULL,
  `approved_by` varchar(32) DEFAULT NULL,
  `note` varchar(512) DEFAULT NULL,
  `created_at` datetime NOT NULL DEFAULT current_timestamp(),
  `approved_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_payments_sale` (`sale_id`),
  KEY `idx_payments_status` (`status`),
  CONSTRAINT `fk_payments_sale` FOREIGN KEY (`sale_id`) REFERENCES `sales` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=45 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_uca1400_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `payments`
--

LOCK TABLES `payments` WRITE;
/*!40000 ALTER TABLE `payments` DISABLE KEYS */;
set autocommit=0;
/*!40000 ALTER TABLE `payments` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Table structure for table `pix_wallets`
--

DROP TABLE IF EXISTS `pix_wallets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `pix_wallets` (
  `id` smallint(5) unsigned NOT NULL AUTO_INCREMENT,
  `label` varchar(64) NOT NULL,
  `pix_key` varchar(256) NOT NULL,
  `qr_payload` text NOT NULL,
  `qr_image_url` varchar(512) DEFAULT NULL,
  `is_active` tinyint(1) NOT NULL DEFAULT 1,
  `created_at` datetime NOT NULL DEFAULT current_timestamp(),
  `updated_at` datetime NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_uca1400_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `pix_wallets`
--

LOCK TABLES `pix_wallets` WRITE;
/*!40000 ALTER TABLE `pix_wallets` DISABLE KEYS */;
set autocommit=0;
INSERT INTO `pix_wallets` VALUES
(1,'Raphael','54.523.514/0001-50','00020126360014BR.GOV.BCB.PIX0114545235140001505204000053039865802BR5915Raphael Baganha6012Bandeirantes62200516RefugioSCRaphael63044B2B','https://media.discordapp.net/attachments/664615667126894597/1417198639113306232/qrcode-pix.png?ex=68c99c95&is=68c84b15&hm=e977ad624a83e1750fddf8237969d18627b6c2f56b71b3793d27f9d688ed158b&=&format=webp&quality=lossless&width=750&height=750',1,'2025-09-15 14:48:42','2025-09-15 14:57:49'),
(2,'Gabriel','gabrielbaganha2022@hotmail.com','00020126520014BR.GOV.BCB.PIX0130gabrielbaganha2022@hotmail.com5204000053039865802BR5915Gabriel Baganha6006Itapoa62190515DiamondCarsLTDA6304B553','https://r2.fivemanage.com/Yx9ixeM2xccPSnua1AYc3/ddd.png',1,'2025-09-15 14:57:49','2025-09-15 21:25:35'),
(3,'Kami','12345678901234567890123456789012345678','00020126580014BR.GOV.BCB.PIX013612345678901234567890123456789012345678520400005303986580BR5925NOME DO RECEBEDOR6009SAO PAULO62070503***6304XXXX','https://example.com/qr3.png',1,'2025-09-15 14:57:49','2025-09-15 14:57:49');
/*!40000 ALTER TABLE `pix_wallets` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Table structure for table `refugio_advertences`
--

DROP TABLE IF EXISTS `refugio_advertences`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `refugio_advertences` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `author_id` int(11) NOT NULL,
  `type` varchar(16) NOT NULL DEFAULT 'other',
  `reason` varchar(255) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`),
  KEY `author_id` (`author_id`),
  CONSTRAINT `refugio_advertences_test_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `refugio_user` (`id`),
  CONSTRAINT `refugio_advertences_test_ibfk_2` FOREIGN KEY (`author_id`) REFERENCES `refugio_user` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=517 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `refugio_advertences`
--

LOCK TABLES `refugio_advertences` WRITE;
/*!40000 ALTER TABLE `refugio_advertences` DISABLE KEYS */;
set autocommit=0;
/*!40000 ALTER TABLE `refugio_advertences` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Table structure for table `refugio_booster`
--

DROP TABLE IF EXISTS `refugio_booster`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `refugio_booster` (
  `discord` varchar(24) NOT NULL,
  `time` int(26) NOT NULL,
  PRIMARY KEY (`discord`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `refugio_booster`
--

LOCK TABLES `refugio_booster` WRITE;
/*!40000 ALTER TABLE `refugio_booster` DISABLE KEYS */;
set autocommit=0;
INSERT INTO `refugio_booster` VALUES
('1005650849109905429',1762290243),
('1054910575072772108',1753998072),
('1056656946360500285',1758819373),
('1075505685133008976',1752952341),
('1096886795704213544',1738569586),
('1111382730501005432',1738719864),
('1116511023491457064',1748230159),
('1137843085863288862',1758759533),
('1143291981318070333',1751909390),
('1257016008032653312',1760327572),
('1279098748009451542',1743798337),
('1282922392745672777',1746588183),
('1284934188553998461',1741667472),
('1364038005060407326',1752968384),
('201879288440553472',1744155144),
('257348423047446528',1746020292),
('262633008660480000',1753655495),
('292116633755844608',1753666541),
('305904967435419648',1753665986),
('320019761725571083',1748218273),
('328674058759700481',1743133408),
('333628097276542977',1753729922),
('366618363277082625',1742942148),
('403656347792441346',1739992750),
('404027396707057674',1751908409),
('405828149319041042',1743134322),
('411946892570656781',1762293009),
('447386497080098817',1742925015),
('462676185281986580',1742674736),
('467730404124786758',1743134522),
('504952800673792002',1754871824),
('537473040506683392',1746501203),
('577619471779233793',1744253499),
('602914208325173248',1753654038),
('616445821503930370',1754003980),
('623713189963759627',1743531927),
('634853711734374400',1738859159),
('639434730168909835',1741483582),
('646487749440045083',1744155345),
('664965816957140995',1755736146),
('683034641795645456',1746407367),
('697655917792985160',1740542293),
('762463121457414164',1754273582),
('775513128783183923',1741667841),
('791375632494886913',1753486285),
('798657333609103431',1742700441),
('807122706495569941',1754088063),
('816888872105541650',1760378293),
('836815909640994826',1748465202),
('917148189470109747',1741666736),
('934496829343678484',1751344814);
/*!40000 ALTER TABLE `refugio_booster` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Table structure for table `refugio_characters`
--

DROP TABLE IF EXISTS `refugio_characters`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `refugio_characters` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `last_time` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `name` varchar(16) NOT NULL,
  `last_login` int(11) NOT NULL DEFAULT unix_timestamp(current_timestamp()),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `refugio_characters`
--

LOCK TABLES `refugio_characters` WRITE;
/*!40000 ALTER TABLE `refugio_characters` DISABLE KEYS */;
set autocommit=0;
/*!40000 ALTER TABLE `refugio_characters` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Table structure for table `refugio_corporation_action`
--

DROP TABLE IF EXISTS `refugio_corporation_action`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `refugio_corporation_action` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `corporation_id` int(11) NOT NULL,
  `action_date` varchar(255) NOT NULL,
  `action_local` varchar(255) NOT NULL,
  `members` varchar(255) NOT NULL,
  `winner` int(11) DEFAULT NULL,
  `action_owner` varchar(255) NOT NULL,
  `action_message` varchar(255) DEFAULT NULL,
  `canceled` tinyint(1) DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=157 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `refugio_corporation_action`
--

LOCK TABLES `refugio_corporation_action` WRITE;
/*!40000 ALTER TABLE `refugio_corporation_action` DISABLE KEYS */;
set autocommit=0;
/*!40000 ALTER TABLE `refugio_corporation_action` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Table structure for table `refugio_envios_stats`
--

DROP TABLE IF EXISTS `refugio_envios_stats`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `refugio_envios_stats` (
  `Passport` int(11) NOT NULL,
  `DeliveriesToday` int(11) NOT NULL DEFAULT 0,
  `TotalEarningsToday` int(11) NOT NULL DEFAULT 0,
  `CompletedDeliveries` int(11) NOT NULL DEFAULT 0,
  `Rating` float NOT NULL DEFAULT 5,
  `RatingsCount` int(11) NOT NULL DEFAULT 0,
  `LastReset` date NOT NULL,
  PRIMARY KEY (`Passport`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `refugio_envios_stats`
--

LOCK TABLES `refugio_envios_stats` WRITE;
/*!40000 ALTER TABLE `refugio_envios_stats` DISABLE KEYS */;
set autocommit=0;
/*!40000 ALTER TABLE `refugio_envios_stats` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Table structure for table `refugio_evidence`
--

DROP TABLE IF EXISTS `refugio_evidence`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `refugio_evidence` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `agent` varchar(22) NOT NULL,
  `suspect` varchar(36) NOT NULL,
  `evidence` varchar(22) NOT NULL,
  `local` varchar(48) NOT NULL,
  `ocurred_on` varchar(32) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `refugio_evidence`
--

LOCK TABLES `refugio_evidence` WRITE;
/*!40000 ALTER TABLE `refugio_evidence` DISABLE KEYS */;
set autocommit=0;
/*!40000 ALTER TABLE `refugio_evidence` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Table structure for table `refugio_factions`
--

DROP TABLE IF EXISTS `refugio_factions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `refugio_factions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `production_type` varchar(30) NOT NULL,
  `owner` varchar(20) DEFAULT NULL,
  `name` varchar(25) NOT NULL,
  `total` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=97 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `refugio_factions`
--

LOCK TABLES `refugio_factions` WRITE;
/*!40000 ALTER TABLE `refugio_factions` DISABLE KEYS */;
set autocommit=0;
INSERT INTO `refugio_factions` VALUES
(73,'weapons','311181372557361162','Cartel',15),
(74,'weapons','901294558736969740','CosaNostra',15),
(75,'weapons','717168703514607669','Bratva',15),
(76,'ammo','945538381591494697','Yakuza',15),
(77,'ammo','1030593984793415831','Triade',15),
(78,'ammo',NULL,'Moto Clube',15),
(79,'washer',NULL,'Vanilla',12),
(80,'washer',NULL,'Galaxy',12),
(81,'washer',NULL,'Bahamas',12),
(82,'drugs',NULL,'Favela Frei damião',12),
(83,'drugs',NULL,'Favela Serrinha',12),
(84,'drugs','879488525777637417','Favela Playboy',12),
(85,'drugs',NULL,'Hospital ilegal',10),
(86,'drugs',NULL,'Favela Vila Fortaleza',12),
(87,'police',NULL,'12° BPM Policia Militar',15),
(88,'police',NULL,'CHOQUE',12),
(89,'police',NULL,'TÁTICO [PPT]',15),
(90,'police',NULL,'Policia Civil',15),
(91,'police','487617392516530178','Guarda Municipal [GMBC]',12),
(92,'Contrabando',NULL,'Morro do 25',12),
(93,'Contrabando',NULL,'Favela da Pedreira',12),
(94,'restaurant',NULL,'Restaurante 1',8),
(95,'restaurant',NULL,'Restaurante 2',8),
(96,'public','1037262819277672448','Bombeiros Militar [CBMSC]',8);
/*!40000 ALTER TABLE `refugio_factions` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Table structure for table `refugio_ia_conhecimento`
--

DROP TABLE IF EXISTS `refugio_ia_conhecimento`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `refugio_ia_conhecimento` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `pergunta` text NOT NULL,
  `resposta` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `refugio_ia_conhecimento`
--

LOCK TABLES `refugio_ia_conhecimento` WRITE;
/*!40000 ALTER TABLE `refugio_ia_conhecimento` DISABLE KEYS */;
set autocommit=0;
INSERT INTO `refugio_ia_conhecimento` VALUES
(1,'Como liga o carro?','Você pode ligar o carro apertando a tecla **Z** no teclado! Vruuum, pronto pra acelerar! 🚗✨');
/*!40000 ALTER TABLE `refugio_ia_conhecimento` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Table structure for table `refugio_invites`
--

DROP TABLE IF EXISTS `refugio_invites`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `refugio_invites` (
  `user_id` varchar(50) NOT NULL,
  `invite_url` varchar(255) DEFAULT NULL,
  `invites` int(11) DEFAULT 0,
  PRIMARY KEY (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `refugio_invites`
--

LOCK TABLES `refugio_invites` WRITE;
/*!40000 ALTER TABLE `refugio_invites` DISABLE KEYS */;
set autocommit=0;
/*!40000 ALTER TABLE `refugio_invites` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Table structure for table `refugio_suggestions`
--

DROP TABLE IF EXISTS `refugio_suggestions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `refugio_suggestions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` varchar(255) NOT NULL,
  `suggestion` text NOT NULL,
  `image_url` varchar(255) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `refugio_suggestions`
--

LOCK TABLES `refugio_suggestions` WRITE;
/*!40000 ALTER TABLE `refugio_suggestions` DISABLE KEYS */;
set autocommit=0;
/*!40000 ALTER TABLE `refugio_suggestions` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Table structure for table `refugio_tickets`
--

DROP TABLE IF EXISTS `refugio_tickets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `refugio_tickets` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `type` varchar(16) NOT NULL DEFAULT 'support',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `channel_id` varchar(24) DEFAULT NULL,
  `finished` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`),
  CONSTRAINT `refugio_tickets_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `refugio_user` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=8024 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `refugio_tickets`
--

LOCK TABLES `refugio_tickets` WRITE;
/*!40000 ALTER TABLE `refugio_tickets` DISABLE KEYS */;
set autocommit=0;
INSERT INTO `refugio_tickets` VALUES
(7988,13078,'takeover','2025-12-01 11:59:39','2025-12-01 11:59:57','1445021531288637608',1),
(7989,13078,'bug','2025-12-01 12:04:19','2025-12-01 12:05:01','1445022705748279397',1),
(7990,13081,'takeover','2025-12-01 12:24:18','2025-12-01 12:24:19','1445027736300032021',0),
(7991,13082,'takeover','2025-12-01 12:39:24','2025-12-01 19:29:26','1445031532329963550',1),
(7992,13083,'support','2025-12-01 13:05:41','2025-12-01 13:54:13','1445038147946942474',1),
(7993,13084,'takeover','2025-12-01 13:08:34','2025-12-01 13:08:35','1445038874563973284',0),
(7994,13085,'takeover','2025-12-01 14:46:18','2025-12-01 14:46:19','1445063471053148352',0),
(7995,13086,'takeover','2025-12-01 14:59:39','2025-12-01 14:59:40','1445066829813907626',0),
(7996,13087,'takeover','2025-12-01 15:00:28','2025-12-01 15:00:28','1445067032285675550',0),
(7997,13088,'takeover','2025-12-01 15:29:47','2025-12-01 15:29:48','1445074414059131122',0),
(7998,13089,'takeover','2025-12-01 15:37:35','2025-12-01 15:37:36','1445076376041296135',0),
(7999,13090,'support','2025-12-01 17:34:21','2025-12-01 17:34:22','1445105759775100970',0),
(8000,13091,'takeover','2025-12-01 21:54:06','2025-12-01 21:54:10','1445171137549045903',0),
(8001,13092,'takeover','2025-12-01 22:19:52','2025-12-04 02:56:30','1445177612216569936',1),
(8002,13094,'support','2025-12-02 02:10:30','2025-12-03 02:36:57','1445235652886003845',1),
(8003,13095,'takeover','2025-12-02 02:31:08','2025-12-02 02:31:09','1445240845312987166',0),
(8004,13098,'takeover','2025-12-02 06:23:32','2025-12-02 06:23:33','1445299330708672513',0),
(8005,13100,'support','2025-12-02 13:24:52','2025-12-02 20:46:34','1445405363066110124',1),
(8006,13101,'support','2025-12-02 20:38:41','2025-12-02 20:52:57','1445514537393590474',1),
(8007,13106,'takeover','2025-12-03 22:41:32','2025-12-03 22:41:33','1445907843604545556',0),
(8008,13108,'takeover','2025-12-04 00:40:53','2025-12-04 00:40:54','1445937877543292982',0),
(8009,13109,'support','2025-12-04 01:02:21','2025-12-04 02:41:52','1445943280301903892',1),
(8010,13110,'support','2025-12-04 01:27:05','2025-12-04 01:28:46','1445949502174531799',1),
(8011,13110,'bug','2025-12-04 01:29:00','2025-12-04 01:29:01','1445949985286783177',1),
(8012,13110,'bug','2025-12-04 01:29:00','2025-12-04 01:45:59','1445949985085456506',1),
(8013,13112,'donation','2025-12-04 01:30:24','2025-12-04 01:32:34','1445950337453396028',1),
(8014,13112,'support','2025-12-04 01:38:49','2025-12-04 01:41:57','1445952457636188254',1),
(8015,13110,'bug','2025-12-04 01:45:59','2025-12-04 02:19:32','1445954262403387534',1),
(8016,13112,'bug','2025-12-04 01:57:09','2025-12-04 02:03:18','1445957071072792596',1),
(8017,13112,'support','2025-12-04 02:03:41','2025-12-04 02:03:42','1445958716347252913',0),
(8018,13113,'takeover','2025-12-04 02:22:15','2025-12-04 02:34:30','1445963387610595561',1),
(8019,13114,'support','2025-12-04 02:25:27','2025-12-04 02:26:35','1445964193827389481',1),
(8020,13114,'bug','2025-12-04 02:28:43','2025-12-04 13:22:15','1445965014438641665',1),
(8021,13115,'takeover','2025-12-04 13:17:10','2025-12-04 13:17:12','1446128207949598720',0),
(8022,13116,'support','2025-12-04 13:23:16','2025-12-04 13:23:17','1446129736068759665',0),
(8023,13113,'takeover','2025-12-04 18:59:45','2025-12-04 19:03:36','1446214414964363367',1);
/*!40000 ALTER TABLE `refugio_tickets` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Table structure for table `refugio_tickets_claim`
--

DROP TABLE IF EXISTS `refugio_tickets_claim`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `refugio_tickets_claim` (
  `ticket_id` int(11) NOT NULL,
  `discord_id` varchar(32) NOT NULL,
  PRIMARY KEY (`ticket_id`),
  CONSTRAINT `refugio_tickets_claim_ibfk_1` FOREIGN KEY (`ticket_id`) REFERENCES `refugio_tickets` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `refugio_tickets_claim`
--

LOCK TABLES `refugio_tickets_claim` WRITE;
/*!40000 ALTER TABLE `refugio_tickets_claim` DISABLE KEYS */;
set autocommit=0;
INSERT INTO `refugio_tickets_claim` VALUES
(7990,'735724009056108566'),
(7991,'735724009056108566'),
(7992,'735724009056108566'),
(7993,'735724009056108566'),
(7994,'400712876056117248'),
(7995,'945538381591494697'),
(7996,'925036586645721129'),
(7998,'945538381591494697'),
(7999,'945538381591494697'),
(8000,'925036586645721129'),
(8001,'966537383866679377'),
(8002,'497842919835697162'),
(8003,'400712876056117248'),
(8004,'735724009056108566'),
(8005,'966537383866679377'),
(8006,'680810186545561636'),
(8007,'966537383866679377'),
(8008,'400712876056117248'),
(8009,'735724009056108566'),
(8010,'798657333609103431'),
(8011,'400712876056117248'),
(8013,'659918884844994603'),
(8014,'659918884844994603'),
(8015,'400712876056117248'),
(8016,'659918884844994603'),
(8017,'659918884844994603'),
(8018,'735724009056108566'),
(8020,'659918884844994603'),
(8021,'966537383866679377'),
(8022,'659918884844994603'),
(8023,'400712876056117248');
/*!40000 ALTER TABLE `refugio_tickets_claim` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Table structure for table `refugio_tickets_history`
--

DROP TABLE IF EXISTS `refugio_tickets_history`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `refugio_tickets_history` (
  `ticket_id` int(11) NOT NULL,
  `content` mediumblob DEFAULT NULL,
  PRIMARY KEY (`ticket_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `refugio_tickets_history`
--

LOCK TABLES `refugio_tickets_history` WRITE;
/*!40000 ALTER TABLE `refugio_tickets_history` DISABLE KEYS */;
set autocommit=0;
INSERT INTO `refugio_tickets_history` VALUES
(7988,'<html><head><meta charSet=\"utf-8\"/><meta name=\"viewport\" content=\"width=device-width, initial-scale=1\"/><link rel=\"icon\" type=\"image/png\" href=\"https://cdn.discordapp.com/icons/491309213553917952/a_34648f7a1342a2a7343585d52d846f0b.gif?size=16\"/><title>⚡┃ticket-7988</title><script>document.addEventListener(\"click\",t=>{let e=t.target;if(!e)return;let o=e?.getAttribute(\"data-goto\");if(o){let r=document.getElementById(`m-${o}`);r?(r.scrollIntoView({behavior:\"smooth\",block:\"center\"}),r.style.backgroundColor=\"rgba(148, 156, 247, 0.1)\",r.style.transition=\"background-color 0.5s ease\",setTimeout(()=>{r.style.backgroundColor=\"transparent\"},1e3)):console.warn(\"Message ${goto} not found.\")}});</script><script>window.$discordMessage={profiles:{\"1003801622247383180\":{\"author\":\"Refúgio\",\"avatar\":\"https://cdn.discordapp.com/avatars/1003801622247383180/a_24e84ba106cec0b4a5ed5cd3ac391f2c.gif?size=64\",\"roleColor\":\"#ffffff\",\"roleIcon\":\"https://cdn.discordapp.com/role-icons/927207618638925854/d6353d6117aff284e0a3816bc59d2336.webp\",\"roleName\":\"Turista\",\"bot\":true,\"verified\":false},\"400712876056117248\":{\"author\":\"[🦝] Flashh\",\"avatar\":\"https://cdn.discordapp.com/avatars/400712876056117248/3765f35466140a0ca1cceff6e28c338a.webp?size=64\",\"roleColor\":\"#a10b7b\",\"roleIcon\":\"https://cdn.discordapp.com/role-icons/927207621100969985/0bd4ba363baf51ba0164a27447535dcc.webp\",\"roleName\":\"SERVIDOR・CEO\",\"bot\":false,\"verified\":false}}}</script><script type=\"module\" src=\"https://cdn.jsdelivr.net/npm/@derockdev/discord-components-core@^3.6.1/dist/derockdev-discord-components-core/derockdev-discord-components-core.esm.js\"></script></head><body style=\"margin:0;min-height:100vh\"><discord-messages style=\"min-height:100vh\"><discord-header guild=\"Refúgio Roleplay 💚\" channel=\"⚡┃ticket-7988\" icon=\"https://cdn.discordapp.com/icons/491309213553917952/a_34648f7a1342a2a7343585d52d846f0b.gif?size=128\">This is the start of #⚡┃ticket-7988 channel.</discord-header><discord-message id=\"m-1445021534509989949\" timestamp=\"2025-12-01T11:59:41.029Z\" edited=\"false\" highlight=\"false\" profile=\"1003801622247383180\"><discord-mention type=\"user\">zsGabriel</discord-mention>, <discord-mention type=\"role\" color=\"#c27c0e\">SERVIDOR・EQUIPE</discord-mention>, <discord-mention type=\"role\" color=\"#83c5fa\">SERVIDOR・RESP.  POLICIAS</discord-mention>, <discord-mention type=\"role\" color=\"#e74c3c\">SERVIDOR・RESP.  ILEGAL</discord-mention><discord-embed embed-title=\"⚡ Assumir fac/org/corp\" slot=\"embeds\" color=\"#2f3136\" thumbnail=\"https://images-ext-1.discordapp.net/external/JsnOhgKvQwoycF-x2PMKjtXASQqqFsvcE8QmcVa8zgo/https/cdn.discordapp.com/avatars/400712876056117248/3765f35466140a0ca1cceff6e28c338a.webp\"><discord-embed-description slot=\"description\">Olá, por favor nos informe qual a facção, organização ou corporação que deseja assumir.<br/>Mas primeiro, leia as regras para poder assumir e verifique se a sua escolhe está livre. Você pode verificar em <discord-mention type=\"channel\">📂・para-assumir</discord-mention>.<br/><br/><discord-custom-emoji name=\"⚙️\" url=\"https://cdnjs.cloudflare.com/ajax/libs/twemoji/14.0.2/svg/2699.svg\" embed-emoji=\"true\"></discord-custom-emoji> <discord-underlined><discord-bold>Adicionar ou remover membros:</discord-bold></discord-underlined><br/>Use um dos botões de acordo com a ação que você deseja fazer.</discord-embed-description><discord-embed-footer slot=\"footer\" footer-image=\"https://images-ext-1.discordapp.net/external/yLihPFx_FJKzd-UOjQ2RQepRLMFFzhNqekN8YKwk7N8/https/cdn.discordapp.com/avatars/1003801622247383180/a_24e84ba106cec0b4a5ed5cd3ac391f2c.gif\" timestamp=\"2025-12-01T11:59:40.788000+00:00\">REFÚGIO SC © Todos os direitos reservados.</discord-embed-footer></discord-embed><discord-attachments slot=\"components\"><discord-action-row><discord-button type=\"primary\" emoji=\"https://cdnjs.cloudflare.com/ajax/libs/twemoji/14.0.2/svg/1f464.svg\">Adicionar</discord-button><discord-button type=\"destructive\" emoji=\"https://cdnjs.cloudflare.com/ajax/libs/twemoji/14.0.2/svg/1f6b7.svg\">Remover</discord-button><discord-button type=\"success\" emoji=\"https://cdnjs.cloudflare.com/ajax/libs/twemoji/14.0.2/svg/2705.svg\">Finalizar Ticket</discord-button></discord-action-row><discord-action-row><discord-button type=\"secondary\" emoji=\"https://cdnjs.cloudflare.com/ajax/libs/twemoji/14.0.2/svg/270f.svg\">Trocar nome do Canal</discord-button><discord-button type=\"secondary\" emoji=\"https://cdnjs.cloudflare.com/ajax/libs/twemoji/14.0.2/svg/2699.svg\">Trocar Categoria</discord-button><discord-button type=\"secondary\" emoji=\"https://cdnjs.cloudflare.com/ajax/libs/twemoji/14.0.2/svg/1f514.svg\">POKE</discord-button></discord-action-row></discord-attachments></discord-message><discord-system-message id=\"m-1445021535655166035\" type=\"pin\"><i style=\"color:#ffffff\">Refúgio</i> pinned <i data-goto=\"1445021534509989949\">a message</i> to this channel.</discord-system-message><discord-message id=\"m-1445021556001738752\" timestamp=\"2025-12-01T11:59:46.153Z\" edited=\"false\" highlight=\"false\" profile=\"400712876056117248\">eaaaaaaa</discord-message><discord-message id=\"m-1445021579359551488\" timestamp=\"2025-12-01T11:59:51.722Z\" edited=\"true\" server=\"false\" highlight=\"false\" profile=\"1003801622247383180\"><discord-reply slot=\"reply\">Message could not be loaded.</discord-reply><discord-embed embed-title=\"⚙️ Ticket fechado\" slot=\"embeds\" color=\"#2f3136\"><discord-embed-description slot=\"description\">Ticket fechado em 01/12/2025, 08:59:57 por <discord-mention type=\"user\">zsGabriel</discord-mention>!<br/>Este canal será deletado em 5 segundos.</discord-embed-description><discord-embed-fields slot=\"fields\"><discord-embed-field field-title=\"📦 **__Motivo do fechamento:__**\" inline=\"false\" inline-index=\"1\"><discord-code-block language=\"\" code=\"test\"></discord-code-block></discord-embed-field></discord-embed-fields><discord-embed-footer slot=\"footer\" footer-image=\"https://images-ext-1.discordapp.net/external/yLihPFx_FJKzd-UOjQ2RQepRLMFFzhNqekN8YKwk7N8/https/cdn.discordapp.com/avatars/1003801622247383180/a_24e84ba106cec0b4a5ed5cd3ac391f2c.gif\" timestamp=\"2025-12-01T11:59:57.675000+00:00\">REFÚGIO SC © Todos os direitos reservados.</discord-embed-footer></discord-embed></discord-message><div style=\"text-align:center;width:100%\">Refúgio SC - Ticket Transcript </div></discord-messages></body></html>'),
(7989,'<html><head><meta charSet=\"utf-8\"/><meta name=\"viewport\" content=\"width=device-width, initial-scale=1\"/><link rel=\"icon\" type=\"image/png\" href=\"https://cdn.discordapp.com/icons/491309213553917952/a_34648f7a1342a2a7343585d52d846f0b.gif?size=16\"/><title>🐛┃ticket-7989</title><script>document.addEventListener(\"click\",t=>{let e=t.target;if(!e)return;let o=e?.getAttribute(\"data-goto\");if(o){let r=document.getElementById(`m-${o}`);r?(r.scrollIntoView({behavior:\"smooth\",block:\"center\"}),r.style.backgroundColor=\"rgba(148, 156, 247, 0.1)\",r.style.transition=\"background-color 0.5s ease\",setTimeout(()=>{r.style.backgroundColor=\"transparent\"},1e3)):console.warn(\"Message ${goto} not found.\")}});</script><script>window.$discordMessage={profiles:{\"1003801622247383180\":{\"author\":\"Refúgio\",\"avatar\":\"https://cdn.discordapp.com/avatars/1003801622247383180/a_24e84ba106cec0b4a5ed5cd3ac391f2c.gif?size=64\",\"roleColor\":\"#ffffff\",\"roleIcon\":\"https://cdn.discordapp.com/role-icons/927207618638925854/d6353d6117aff284e0a3816bc59d2336.webp\",\"roleName\":\"Turista\",\"bot\":true,\"verified\":false}}}</script><script type=\"module\" src=\"https://cdn.jsdelivr.net/npm/@derockdev/discord-components-core@^3.6.1/dist/derockdev-discord-components-core/derockdev-discord-components-core.esm.js\"></script></head><body style=\"margin:0;min-height:100vh\"><discord-messages style=\"min-height:100vh\"><discord-header guild=\"Refúgio Roleplay 💚\" channel=\"🐛┃ticket-7989\" icon=\"https://cdn.discordapp.com/icons/491309213553917952/a_34648f7a1342a2a7343585d52d846f0b.gif?size=128\">This is the start of #🐛┃ticket-7989 channel.</discord-header><discord-message id=\"m-1445022710332653752\" timestamp=\"2025-12-01T12:04:21.367Z\" edited=\"false\" highlight=\"false\" profile=\"1003801622247383180\"><discord-mention type=\"user\">zsGabriel</discord-mention>, <discord-mention type=\"role\" color=\"#c27c0e\">SERVIDOR・EQUIPE</discord-mention><discord-embed embed-title=\"🐛 Bug\" slot=\"embeds\" color=\"#2f3136\" thumbnail=\"https://images-ext-1.discordapp.net/external/JsnOhgKvQwoycF-x2PMKjtXASQqqFsvcE8QmcVa8zgo/https/cdn.discordapp.com/avatars/400712876056117248/3765f35466140a0ca1cceff6e28c338a.webp\"><discord-embed-description slot=\"description\">Detalhe o bug/glitch encontrado e o local e/ou momentos em que tal problema ocorre para que possamos analisar e entender com facilidade.<br/><br/><discord-custom-emoji name=\"⚙️\" url=\"https://cdnjs.cloudflare.com/ajax/libs/twemoji/14.0.2/svg/2699.svg\" embed-emoji=\"true\"></discord-custom-emoji> <discord-underlined><discord-bold>Adicionar ou remover membros:</discord-bold></discord-underlined><br/>Use um dos botões de acordo com a ação que você deseja fazer.</discord-embed-description><discord-embed-footer slot=\"footer\" footer-image=\"https://images-ext-1.discordapp.net/external/yLihPFx_FJKzd-UOjQ2RQepRLMFFzhNqekN8YKwk7N8/https/cdn.discordapp.com/avatars/1003801622247383180/a_24e84ba106cec0b4a5ed5cd3ac391f2c.gif\" timestamp=\"2025-12-01T12:04:21.082000+00:00\">REFÚGIO SC © Todos os direitos reservados.</discord-embed-footer></discord-embed><discord-attachments slot=\"components\"><discord-action-row><discord-button type=\"primary\" emoji=\"https://cdnjs.cloudflare.com/ajax/libs/twemoji/14.0.2/svg/1f464.svg\">Adicionar</discord-button><discord-button type=\"destructive\" emoji=\"https://cdnjs.cloudflare.com/ajax/libs/twemoji/14.0.2/svg/1f6b7.svg\">Remover</discord-button><discord-button type=\"success\" emoji=\"https://cdnjs.cloudflare.com/ajax/libs/twemoji/14.0.2/svg/2705.svg\">Finalizar Ticket</discord-button></discord-action-row><discord-action-row><discord-button type=\"secondary\" emoji=\"https://cdnjs.cloudflare.com/ajax/libs/twemoji/14.0.2/svg/270f.svg\">Trocar nome do Canal</discord-button><discord-button type=\"secondary\" emoji=\"https://cdnjs.cloudflare.com/ajax/libs/twemoji/14.0.2/svg/2699.svg\">Trocar Categoria</discord-button><discord-button type=\"secondary\" emoji=\"https://cdnjs.cloudflare.com/ajax/libs/twemoji/14.0.2/svg/1f514.svg\">POKE</discord-button></discord-action-row></discord-attachments></discord-message><discord-system-message id=\"m-1445022711767105722\" type=\"pin\"><i style=\"color:#ffffff\">Refúgio</i> pinned <i data-goto=\"1445022710332653752\">a message</i> to this channel.</discord-system-message><discord-message id=\"m-1445022753597161554\" timestamp=\"2025-12-01T12:04:31.682Z\" edited=\"true\" server=\"false\" highlight=\"false\" profile=\"1003801622247383180\"><discord-reply slot=\"reply\">Message could not be loaded.</discord-reply><discord-embed embed-title=\"⚙️ Ticket fechado\" slot=\"embeds\" color=\"#2f3136\"><discord-embed-description slot=\"description\">Ticket fechado em 01/12/2025, 09:05:01 por <discord-mention type=\"user\">zsGabriel</discord-mention>!<br/>Este canal será deletado em 5 segundos.</discord-embed-description><discord-embed-fields slot=\"fields\"><discord-embed-field field-title=\"📦 **__Motivo do fechamento:__**\" inline=\"false\" inline-index=\"1\"><discord-code-block language=\"\" code=\"eaaa\"></discord-code-block></discord-embed-field></discord-embed-fields><discord-embed-footer slot=\"footer\" footer-image=\"https://images-ext-1.discordapp.net/external/yLihPFx_FJKzd-UOjQ2RQepRLMFFzhNqekN8YKwk7N8/https/cdn.discordapp.com/avatars/1003801622247383180/a_24e84ba106cec0b4a5ed5cd3ac391f2c.gif\" timestamp=\"2025-12-01T12:05:01.731000+00:00\">REFÚGIO SC © Todos os direitos reservados.</discord-embed-footer></discord-embed></discord-message><div style=\"text-align:center;width:100%\">Refúgio SC - Ticket Transcript </div></discord-messages></body></html>'),
(7991,'<html><head><meta charSet=\"utf-8\"/><meta name=\"viewport\" content=\"width=device-width, initial-scale=1\"/><link rel=\"icon\" type=\"image/png\" href=\"https://cdn.discordapp.com/icons/491309213553917952/a_34648f7a1342a2a7343585d52d846f0b.gif?size=16\"/><title>📦┃assumir-ppt-1</title><script>document.addEventListener(\"click\",t=>{let e=t.target;if(!e)return;let o=e?.getAttribute(\"data-goto\");if(o){let r=document.getElementById(`m-${o}`);r?(r.scrollIntoView({behavior:\"smooth\",block:\"center\"}),r.style.backgroundColor=\"rgba(148, 156, 247, 0.1)\",r.style.transition=\"background-color 0.5s ease\",setTimeout(()=>{r.style.backgroundColor=\"transparent\"},1e3)):console.warn(\"Message ${goto} not found.\")}});</script><script>window.$discordMessage={profiles:{\"1003801622247383180\":{\"author\":\"Refúgio\",\"avatar\":\"https://cdn.discordapp.com/avatars/1003801622247383180/a_24e84ba106cec0b4a5ed5cd3ac391f2c.gif?size=64\",\"roleColor\":\"#ffffff\",\"roleIcon\":\"https://cdn.discordapp.com/role-icons/927207618638925854/d6353d6117aff284e0a3816bc59d2336.webp\",\"roleName\":\"Turista\",\"bot\":true,\"verified\":false},\"735724009056108566\":{\"author\":\"Ez\",\"avatar\":\"https://cdn.discordapp.com/guilds/491309213553917952/users/735724009056108566/avatars/3ae6a952ee87fc3d91d36af9d2460d26.webp?size=64\",\"roleColor\":\"#1f8b4c\",\"roleIcon\":\"https://cdn.discordapp.com/role-icons/927207587248758784/5963ab2d95704b8360e984fcced59083.webp\",\"roleName\":\"SERVIDOR・MODERADOR\",\"bot\":false,\"verified\":false},\"508804164827217921\":{\"author\":\"nandø\",\"avatar\":\"https://cdn.discordapp.com/avatars/508804164827217921/4925f829c2b7b0ab46ee1b892225b663.webp?size=64\",\"roleColor\":\"#fa0000\",\"roleIcon\":\"https://cdn.discordapp.com/role-icons/927207618638925854/d6353d6117aff284e0a3816bc59d2336.webp\",\"roleName\":\"Turista\",\"bot\":false,\"verified\":false},\"400712876056117248\":{\"author\":\"[🦝] Flashh\",\"avatar\":\"https://cdn.discordapp.com/avatars/400712876056117248/3765f35466140a0ca1cceff6e28c338a.webp?size=64\",\"roleColor\":\"#a10b7b\",\"roleIcon\":\"https://cdn.discordapp.com/role-icons/927207621100969985/0bd4ba363baf51ba0164a27447535dcc.webp\",\"roleName\":\"SERVIDOR・CEO\",\"bot\":false,\"verified\":false},\"925036586645721129\":{\"author\":\"Giovannizin\",\"avatar\":\"https://cdn.discordapp.com/avatars/925036586645721129/19f9a7f35745c82fd6fb7a8b67b2a588.webp?size=64\",\"roleColor\":\"#c27c0e\",\"roleIcon\":\"https://cdn.discordapp.com/role-icons/927207586397294622/70b3e88cbe1b2e7b1b05dfed2ac6871e.webp\",\"roleName\":\"SERVIDOR・ADMINISTRADOR\",\"bot\":false,\"verified\":false}}}</script><script type=\"module\" src=\"https://cdn.jsdelivr.net/npm/@derockdev/discord-components-core@^3.6.1/dist/derockdev-discord-components-core/derockdev-discord-components-core.esm.js\"></script></head><body style=\"margin:0;min-height:100vh\"><discord-messages style=\"min-height:100vh\"><discord-header guild=\"Refúgio Roleplay 💚\" channel=\"📦┃assumir-ppt-1\" icon=\"https://cdn.discordapp.com/icons/491309213553917952/a_34648f7a1342a2a7343585d52d846f0b.gif?size=128\">This is the start of #📦┃assumir-ppt-1 channel.</discord-header><discord-message id=\"m-1445031535584743466\" timestamp=\"2025-12-01T12:39:25.471Z\" edited=\"false\" highlight=\"false\" profile=\"1003801622247383180\"><discord-mention type=\"user\">nandø</discord-mention>, <discord-mention type=\"role\" color=\"#c27c0e\">SERVIDOR・EQUIPE</discord-mention>, <discord-mention type=\"role\" color=\"#83c5fa\">SERVIDOR・RESP.  POLICIAS</discord-mention>, <discord-mention type=\"role\" color=\"#e74c3c\">SERVIDOR・RESP.  ILEGAL</discord-mention><discord-embed embed-title=\"⚡ Assumir fac/org/corp\" slot=\"embeds\" color=\"#2f3136\" thumbnail=\"https://images-ext-1.discordapp.net/external/2j3lzoLLyTq3TUh5DhArcGuqrNIQ5bgbsBbRYhwtyT0/https/cdn.discordapp.com/avatars/508804164827217921/4925f829c2b7b0ab46ee1b892225b663.webp\"><discord-embed-description slot=\"description\">Olá, por favor nos informe qual a facção, organização ou corporação que deseja assumir.<br/>Mas primeiro, leia as regras para poder assumir e verifique se a sua escolhe está livre. Você pode verificar em <discord-mention type=\"channel\">📂・para-assumir</discord-mention>.<br/><br/><discord-custom-emoji name=\"⚙️\" url=\"https://cdnjs.cloudflare.com/ajax/libs/twemoji/14.0.2/svg/2699.svg\" embed-emoji=\"true\"></discord-custom-emoji> <discord-underlined><discord-bold>Adicionar ou remover membros:</discord-bold></discord-underlined><br/>Use um dos botões de acordo com a ação que você deseja fazer.</discord-embed-description><discord-embed-footer slot=\"footer\" footer-image=\"https://images-ext-1.discordapp.net/external/yLihPFx_FJKzd-UOjQ2RQepRLMFFzhNqekN8YKwk7N8/https/cdn.discordapp.com/avatars/1003801622247383180/a_24e84ba106cec0b4a5ed5cd3ac391f2c.gif\" timestamp=\"2025-12-01T12:39:25.160000+00:00\">REFÚGIO SC © Todos os direitos reservados.</discord-embed-footer></discord-embed><discord-attachments slot=\"components\"><discord-action-row><discord-button type=\"primary\" emoji=\"https://cdnjs.cloudflare.com/ajax/libs/twemoji/14.0.2/svg/1f464.svg\">Adicionar</discord-button><discord-button type=\"destructive\" emoji=\"https://cdnjs.cloudflare.com/ajax/libs/twemoji/14.0.2/svg/1f6b7.svg\">Remover</discord-button><discord-button type=\"success\" emoji=\"https://cdnjs.cloudflare.com/ajax/libs/twemoji/14.0.2/svg/2705.svg\">Finalizar Ticket</discord-button></discord-action-row><discord-action-row><discord-button type=\"secondary\" emoji=\"https://cdnjs.cloudflare.com/ajax/libs/twemoji/14.0.2/svg/270f.svg\">Trocar nome do Canal</discord-button><discord-button type=\"secondary\" emoji=\"https://cdnjs.cloudflare.com/ajax/libs/twemoji/14.0.2/svg/2699.svg\">Trocar Categoria</discord-button><discord-button type=\"secondary\" emoji=\"https://cdnjs.cloudflare.com/ajax/libs/twemoji/14.0.2/svg/1f514.svg\">POKE</discord-button></discord-action-row></discord-attachments></discord-message><discord-system-message id=\"m-1445031537287364638\" type=\"pin\"><i style=\"color:#ffffff\">Refúgio</i> pinned <i data-goto=\"1445031535584743466\">a message</i> to this channel.</discord-system-message><discord-message id=\"m-1445032065534918818\" timestamp=\"2025-12-01T12:41:31.821Z\" edited=\"false\" highlight=\"false\" profile=\"735724009056108566\">Bom dia</discord-message><discord-message id=\"m-1445032066923368449\" timestamp=\"2025-12-01T12:41:32.152Z\" edited=\"false\" highlight=\"false\" profile=\"1003801622247383180\"><discord-embed embed-title=\"Ticket assumido\" slot=\"embeds\" color=\"#2f3136\"><discord-embed-description slot=\"description\">O ticket foi assumido pelo staff <discord-mention type=\"user\">Ez</discord-mention></discord-embed-description><discord-embed-footer slot=\"footer\" footer-image=\"https://images-ext-1.discordapp.net/external/yLihPFx_FJKzd-UOjQ2RQepRLMFFzhNqekN8YKwk7N8/https/cdn.discordapp.com/avatars/1003801622247383180/a_24e84ba106cec0b4a5ed5cd3ac391f2c.gif\" timestamp=\"2025-12-01T12:41:31.907000+00:00\">REFÚGIO SC © Todos os direitos reservados.</discord-embed-footer></discord-embed></discord-message><discord-message id=\"m-1445032083238948965\" timestamp=\"2025-12-01T12:41:36.042Z\" edited=\"true\" highlight=\"false\" profile=\"735724009056108566\">como posso ajudar?</discord-message><discord-message id=\"m-1445032189581590528\" timestamp=\"2025-12-01T12:42:01.396Z\" edited=\"false\" highlight=\"false\" profile=\"508804164827217921\">PPT</discord-message><discord-message id=\"m-1445032400043376741\" timestamp=\"2025-12-01T12:42:51.574Z\" edited=\"false\" highlight=\"false\" profile=\"735724009056108566\">Primeiramente bom dia<discord-custom-emoji name=\"😁\" url=\"https://cdnjs.cloudflare.com/ajax/libs/twemoji/14.0.2/svg/1f601.svg\" embed-emoji=\"false\"></discord-custom-emoji></discord-message><discord-message id=\"m-1445032619560534059\" timestamp=\"2025-12-01T12:43:43.911Z\" edited=\"false\" highlight=\"false\" profile=\"508804164827217921\">Tava dirigindo kkk</discord-message><discord-message id=\"m-1445032633959579760\" timestamp=\"2025-12-01T12:43:47.344Z\" edited=\"false\" highlight=\"false\" profile=\"508804164827217921\">Bom dia</discord-message><discord-message id=\"m-1445032660308201568\" timestamp=\"2025-12-01T12:43:53.626Z\" edited=\"false\" highlight=\"false\" profile=\"735724009056108566\">Opa vamos la</discord-message><discord-message id=\"m-1445032696370696233\" timestamp=\"2025-12-01T12:44:02.224Z\" edited=\"false\" highlight=\"false\" profile=\"735724009056108566\">deseja assumir o PPT certo</discord-message><discord-message id=\"m-1445032731187871747\" timestamp=\"2025-12-01T12:44:10.525Z\" edited=\"true\" highlight=\"false\" profile=\"735724009056108566\">teria quantos atualmente para assumir?</discord-message><discord-message id=\"m-1445032791493316638\" timestamp=\"2025-12-01T12:44:24.903Z\" edited=\"false\" highlight=\"false\" profile=\"508804164827217921\">Sim, eu acabei de falar com Rapha</discord-message><discord-message id=\"m-1445032815619080242\" timestamp=\"2025-12-01T12:44:30.655Z\" edited=\"false\" server=\"false\" highlight=\"false\" profile=\"508804164827217921\"><discord-reply slot=\"reply\" edited=\"true\" attachment=\"false\" author=\"Ez\" avatar=\"https://cdn.discordapp.com/avatars/735724009056108566/8d3e4781c5ccf56924a5fd0667451873.webp?size=32\" role-color=\"#1f8b4c\" bot=\"false\" verified=\"false\" op=\"false\" command=\"false\"><span data-goto=\"1445032731187871747\">teria quantos atualmente para assumir?</span></discord-reply>10 pessoas</discord-message><discord-message id=\"m-1445032871386550293\" timestamp=\"2025-12-01T12:44:43.951Z\" edited=\"false\" highlight=\"false\" profile=\"508804164827217921\">Por enquanto</discord-message><discord-message id=\"m-1445036837939712100\" timestamp=\"2025-12-01T13:00:29.651Z\" edited=\"false\" server=\"false\" highlight=\"false\" profile=\"735724009056108566\"><discord-reply slot=\"reply\" edited=\"false\" attachment=\"false\" author=\"nandø\" avatar=\"https://cdn.discordapp.com/avatars/508804164827217921/4925f829c2b7b0ab46ee1b892225b663.webp?size=32\" role-color=\"#fa0000\" bot=\"false\" verified=\"false\" op=\"false\" server=\"false\" command=\"false\"><span data-goto=\"1445032815619080242\">10 pessoas</span></discord-reply>Certo</discord-message><discord-message id=\"m-1445037122959446207\" timestamp=\"2025-12-01T13:01:37.605Z\" edited=\"false\" server=\"false\" highlight=\"false\" profile=\"508804164827217921\"><discord-reply slot=\"reply\" edited=\"false\" attachment=\"false\" author=\"Ez\" avatar=\"https://cdn.discordapp.com/avatars/735724009056108566/8d3e4781c5ccf56924a5fd0667451873.webp?size=32\" role-color=\"#1f8b4c\" bot=\"false\" verified=\"false\" op=\"false\" server=\"false\" command=\"false\"><span data-goto=\"1445036837939712100\">Certo</span></discord-reply>Volta essa semana a city ?</discord-message><discord-message id=\"m-1445037212751106180\" timestamp=\"2025-12-01T13:01:59.013Z\" edited=\"false\" highlight=\"false\" profile=\"735724009056108566\">Em breve será lançado a data</discord-message><discord-message id=\"m-1445037326865666119\" timestamp=\"2025-12-01T13:02:26.220Z\" edited=\"false\" highlight=\"false\" profile=\"508804164827217921\">Blz</discord-message><discord-message id=\"m-1445037421258473684\" timestamp=\"2025-12-01T13:02:48.725Z\" edited=\"false\" highlight=\"false\" profile=\"508804164827217921\">Como quês fazer? Os nomes com as patentes ?</discord-message><discord-message id=\"m-1445037556818247791\" timestamp=\"2025-12-01T13:03:21.045Z\" edited=\"false\" highlight=\"false\" profile=\"735724009056108566\">Bom sobre o ppt você precisaria de 12 mas como já tem 10 você pode assumir e teria 48 horas para completar o restante<discord-reactions slot=\"reactions\"><discord-reaction name=\"✅\" emoji=\"https://cdnjs.cloudflare.com/ajax/libs/twemoji/14.0.2/svg/2705.svg\" count=\"1\"></discord-reaction></discord-reactions></discord-message><discord-message id=\"m-1445037762196668559\" timestamp=\"2025-12-01T13:04:10.011Z\" edited=\"false\" highlight=\"false\" profile=\"735724009056108566\">Recomendo que procure esses 2 para completar para não ter o risco de alguém com mais contigente assumir</discord-message><discord-message id=\"m-1445037858124730458\" timestamp=\"2025-12-01T13:04:32.882Z\" edited=\"false\" highlight=\"false\" profile=\"508804164827217921\">Tranquilo</discord-message><discord-message id=\"m-1445037891280437269\" timestamp=\"2025-12-01T13:04:40.787Z\" edited=\"false\" highlight=\"false\" profile=\"508804164827217921\">Já arrumo</discord-message><discord-message id=\"m-1445038093983027274\" timestamp=\"2025-12-01T13:05:29.115Z\" edited=\"false\" highlight=\"false\" profile=\"735724009056108566\">Ok</discord-message><discord-message id=\"m-1445038223725297875\" timestamp=\"2025-12-01T13:06:00.048Z\" edited=\"false\" highlight=\"false\" profile=\"735724009056108566\">Assim que for liberado e todos os seus entrarem pode mandar por aqui os id</discord-message><discord-message id=\"m-1445042002885611570\" timestamp=\"2025-12-01T13:21:01.070Z\" edited=\"false\" highlight=\"false\" profile=\"508804164827217921\">Blz</discord-message><discord-message id=\"m-1445057012240089169\" timestamp=\"2025-12-01T14:20:39.579Z\" edited=\"false\" server=\"false\" highlight=\"false\" profile=\"508804164827217921\"><discord-reply slot=\"reply\" edited=\"false\" attachment=\"false\" author=\"Ez\" avatar=\"https://cdn.discordapp.com/avatars/735724009056108566/8d3e4781c5ccf56924a5fd0667451873.webp?size=32\" role-color=\"#1f8b4c\" bot=\"false\" verified=\"false\" op=\"false\" command=\"false\"><span data-goto=\"1445038223725297875\">Assim que for liberado e todos os seus entrarem pode mandar por aqui os id</span></discord-reply>Já tenho os 12</discord-message><discord-message id=\"m-1445080381542895616\" timestamp=\"2025-12-01T15:53:31.255Z\" edited=\"false\" highlight=\"false\" profile=\"508804164827217921\">Tem que esperar a city abrir? Ou passo os nomes já ?</discord-message><discord-message id=\"m-1445080435750211584\" timestamp=\"2025-12-01T15:53:44.179Z\" edited=\"false\" highlight=\"false\" profile=\"400712876056117248\"><discord-mention type=\"user\">Giovannizin</discord-mention></discord-message><discord-message id=\"m-1445080462442893423\" timestamp=\"2025-12-01T15:53:50.543Z\" edited=\"false\" server=\"false\" highlight=\"false\" profile=\"400712876056117248\"><discord-reply slot=\"reply\" edited=\"false\" attachment=\"false\" author=\"nandø\" avatar=\"https://cdn.discordapp.com/avatars/508804164827217921/4925f829c2b7b0ab46ee1b892225b663.webp?size=32\" role-color=\"#fa0000\" bot=\"false\" verified=\"false\" op=\"false\" server=\"false\" command=\"false\"><span data-goto=\"1445057012240089169\">Já tenho os 12</span></discord-reply>são 15 o ppt</discord-message><discord-message id=\"m-1445080983211872448\" timestamp=\"2025-12-01T15:55:54.704Z\" edited=\"false\" server=\"false\" highlight=\"false\" profile=\"508804164827217921\"><discord-reply slot=\"reply\" edited=\"false\" attachment=\"false\" author=\"[🦝] Flashh\" avatar=\"https://cdn.discordapp.com/avatars/400712876056117248/3765f35466140a0ca1cceff6e28c338a.webp?size=32\" role-color=\"#a10b7b\" bot=\"false\" verified=\"false\" op=\"false\" server=\"false\" command=\"false\"><span data-goto=\"1445080462442893423\">são 15 o ppt</span></discord-reply>Que me fude né flash<discord-reactions slot=\"reactions\"><discord-reaction name=\"refugiomonkey2\" emoji=\"https://cdn.discordapp.com/emojis/1251973715588026468.png\" count=\"1\"></discord-reaction></discord-reactions></discord-message><discord-message id=\"m-1445085289570766950\" timestamp=\"2025-12-01T16:13:01.420Z\" edited=\"false\" highlight=\"false\" profile=\"925036586645721129\">Boa tarde, <discord-mention type=\"user\">nandø</discord-mention> ! <br/><br/>Meu nome é Giovanni e estarei lhe auxiliando hoje!<br/><br/>Para começar, como já foi dito, preciso de 15 pessoas com você para assumir! <br/><br/>Segundamente vou precisar de um projeto contendo as cidades que você e seu grupo já passaram, quanto tempo ficaram em cada uma, saíram por causa de que, o que significa PPT e o que fazem, qual a diferencia do PPT para a rádio patrulha, enfim, me apresentar o projeto como se eu não soubesse o que fosse.<br/><br/>Preciso também de uma planilha com a hierarquia de seu contigente! Lembrando que o comando entra como <discord-bold>TENENTE CORONEL</discord-bold> por se tratar de uma unidade.<br/><br/>Obs: Os tickets são atendidos em ordem de abertura, porém, o melhor projeto em 48h leva o PPT. Então, aconselho que você faça um impecável projeto.<br/><br/>(Obs: Os documentos de molde já estão elaborados, irei lhe enviar em breve para você preencher, sendo assim, peço que aguarde e que consiga seu contigente necessário) <br/><br/>Qualquer dúvida, estou a disposição! <br/><br/>Atenciosamente, <br/>Giovanni Ricci<br/>-# Equipe Refúgio Roleplay<discord-reactions slot=\"reactions\"><discord-reaction name=\"✅\" emoji=\"https://cdnjs.cloudflare.com/ajax/libs/twemoji/14.0.2/svg/2705.svg\" count=\"1\"></discord-reaction></discord-reactions></discord-message><discord-message id=\"m-1445086185302261860\" timestamp=\"2025-12-01T16:16:34.979Z\" edited=\"false\" highlight=\"false\" profile=\"508804164827217921\">Opa, blz os 15 consigo tranquilamente</discord-message><discord-message id=\"m-1445086256961687673\" timestamp=\"2025-12-01T16:16:52.064Z\" edited=\"false\" highlight=\"false\" profile=\"508804164827217921\">A propósito já fui comandante do ppt na refúgio</discord-message><discord-message id=\"m-1445087930996752435\" timestamp=\"2025-12-01T16:23:31.185Z\" edited=\"false\" highlight=\"false\" profile=\"925036586645721129\">Certo, em breve lhe envio os modelos para preencher</discord-message><discord-message id=\"m-1445099411050070117\" timestamp=\"2025-12-01T17:09:08.243Z\" edited=\"false\" highlight=\"false\" profile=\"508804164827217921\">Ok</discord-message><discord-message id=\"m-1445110284812419194\" timestamp=\"2025-12-01T17:52:20.750Z\" edited=\"false\" highlight=\"false\" profile=\"925036586645721129\">um minuto.</discord-message><discord-message id=\"m-1445111685563158710\" timestamp=\"2025-12-01T17:57:54.715Z\" edited=\"false\" highlight=\"false\" profile=\"925036586645721129\">Segue o modelo para preencher a hierarquia:<br/><br/> <a href=\"https://docs.google.com/spreadsheets/d/1aZqjsgw26Iu03sHMBjE0ysndipR5tIOC1fCQZrAlGow/edit?usp=sharing\" target=\"_blank\" rel=\"noreferrer\">https://docs.google.com/spreadsheets/d/1aZqjsgw26Iu03sHMBjE0ysndipR5tIOC1fCQZrAlGow/edit?usp=sharing</a><br/><br/>Para o Projeto, um documeno em word, no minimo 5 paginas, contendo: cidades que passaram, quanto tempo ficaram, , saíram por causa de que, o que significa PPT e o que fazem, qual a diferencia do PPT para a rádio patrulha<br/><br/><discord-mention type=\"user\">nandø</discord-mention></discord-message><discord-message id=\"m-1445123496803045466\" timestamp=\"2025-12-01T18:44:50.734Z\" edited=\"false\" server=\"false\" highlight=\"false\" profile=\"508804164827217921\"><discord-reply slot=\"reply\" edited=\"false\" attachment=\"false\" author=\"Giovannizin\" avatar=\"https://cdn.discordapp.com/avatars/925036586645721129/19f9a7f35745c82fd6fb7a8b67b2a588.webp?size=32\" role-color=\"#c27c0e\" bot=\"false\" verified=\"false\" op=\"false\" command=\"false\"><span data-goto=\"1445111685563158710\">Segue o modelo para preencher a hierarquia:   <a href=\"https://docs.google.com/spreadsheets/d/1aZqjsgw26Iu03sHMBjE0ysndipR5tIOC1fCQZrAlGow/edit?usp=sharing\" target=\"_blank\" rel=\"noreferrer\">https://docs.google.com/spreadsheets/d/1aZqjsgw26Iu03sHMBjE0ysndipR5tIOC1fCQZrAlGow/edit?usp=sharing</a>  Para o Projeto, um documeno em w...</span></discord-reply>Jovem não vou fazer projeto, não tenho tempo para isso…  Posso te mandar a hierarquia! Já fui comando do ppt aqui, Rapha sabe, flash e vg tbm… É até uma ofensa me perguntar oq significa ppt</discord-message><discord-message id=\"m-1445123583746768916\" timestamp=\"2025-12-01T18:45:11.463Z\" edited=\"false\" highlight=\"false\" profile=\"508804164827217921\">Se você não concordar pode fechar o ticket <discord-custom-emoji name=\"👍\" url=\"https://cdnjs.cloudflare.com/ajax/libs/twemoji/14.0.2/svg/1f44d.svg\" embed-emoji=\"false\"></discord-custom-emoji></discord-message><discord-message id=\"m-1445134701659689030\" timestamp=\"2025-12-01T19:29:22.180Z\" edited=\"true\" server=\"false\" highlight=\"false\" profile=\"1003801622247383180\"><discord-reply slot=\"reply\">Message could not be loaded.</discord-reply><discord-embed embed-title=\"⚙️ Ticket fechado\" slot=\"embeds\" color=\"#2f3136\"><discord-embed-description slot=\"description\">Ticket fechado em 01/12/2025, 16:29:26 por <discord-mention type=\"user\">zsGabriel</discord-mention>!<br/>Este canal será deletado em 5 segundos.</discord-embed-description><discord-embed-fields slot=\"fields\"><discord-embed-field field-title=\"📦 **__Motivo do fechamento:__**\" inline=\"false\" inline-index=\"1\"><discord-code-block language=\"\" code=\"encerrado\"></discord-code-block></discord-embed-field></discord-embed-fields><discord-embed-footer slot=\"footer\" footer-image=\"https://images-ext-1.discordapp.net/external/yLihPFx_FJKzd-UOjQ2RQepRLMFFzhNqekN8YKwk7N8/https/cdn.discordapp.com/avatars/1003801622247383180/a_24e84ba106cec0b4a5ed5cd3ac391f2c.gif\" timestamp=\"2025-12-01T19:29:26.355000+00:00\">REFÚGIO SC © Todos os direitos reservados.</discord-embed-footer></discord-embed></discord-message><div style=\"text-align:center;width:100%\">Refúgio SC - Ticket Transcript </div></discord-messages></body></html>'),
(7992,'<html><head><meta charSet=\"utf-8\"/><meta name=\"viewport\" content=\"width=device-width, initial-scale=1\"/><link rel=\"icon\" type=\"image/png\" href=\"https://cdn.discordapp.com/icons/491309213553917952/a_34648f7a1342a2a7343585d52d846f0b.gif?size=16\"/><title>💡┃ticket-7992</title><script>document.addEventListener(\"click\",t=>{let e=t.target;if(!e)return;let o=e?.getAttribute(\"data-goto\");if(o){let r=document.getElementById(`m-${o}`);r?(r.scrollIntoView({behavior:\"smooth\",block:\"center\"}),r.style.backgroundColor=\"rgba(148, 156, 247, 0.1)\",r.style.transition=\"background-color 0.5s ease\",setTimeout(()=>{r.style.backgroundColor=\"transparent\"},1e3)):console.warn(\"Message ${goto} not found.\")}});</script><script>window.$discordMessage={profiles:{\"1003801622247383180\":{\"author\":\"Refúgio\",\"avatar\":\"https://cdn.discordapp.com/avatars/1003801622247383180/a_24e84ba106cec0b4a5ed5cd3ac391f2c.gif?size=64\",\"roleColor\":\"#ffffff\",\"roleIcon\":\"https://cdn.discordapp.com/role-icons/927207618638925854/d6353d6117aff284e0a3816bc59d2336.webp\",\"roleName\":\"Turista\",\"bot\":true,\"verified\":false},\"964947028520079402\":{\"author\":\"gian araujo998\",\"avatar\":\"https://cdn.discordapp.com/embed/avatars/0.png\",\"roleColor\":\"#11806a\",\"roleIcon\":\"https://cdn.discordapp.com/role-icons/927207618638925854/d6353d6117aff284e0a3816bc59d2336.webp\",\"roleName\":\"Turista\",\"bot\":false,\"verified\":false},\"735724009056108566\":{\"author\":\"Ez\",\"avatar\":\"https://cdn.discordapp.com/guilds/491309213553917952/users/735724009056108566/avatars/3ae6a952ee87fc3d91d36af9d2460d26.webp?size=64\",\"roleColor\":\"#1f8b4c\",\"roleIcon\":\"https://cdn.discordapp.com/role-icons/927207587248758784/5963ab2d95704b8360e984fcced59083.webp\",\"roleName\":\"SERVIDOR・MODERADOR\",\"bot\":false,\"verified\":false}}}</script><script type=\"module\" src=\"https://cdn.jsdelivr.net/npm/@derockdev/discord-components-core@^3.6.1/dist/derockdev-discord-components-core/derockdev-discord-components-core.esm.js\"></script></head><body style=\"margin:0;min-height:100vh\"><discord-messages style=\"min-height:100vh\"><discord-header guild=\"Refúgio Roleplay 💚\" channel=\"💡┃ticket-7992\" icon=\"https://cdn.discordapp.com/icons/491309213553917952/a_34648f7a1342a2a7343585d52d846f0b.gif?size=128\">This is the start of #💡┃ticket-7992 channel.</discord-header><discord-message id=\"m-1445038151050727484\" timestamp=\"2025-12-01T13:05:42.721Z\" edited=\"false\" highlight=\"false\" profile=\"1003801622247383180\"><discord-mention type=\"user\">gian araujo998</discord-mention>, <discord-mention type=\"role\" color=\"#c27c0e\">SERVIDOR・EQUIPE</discord-mention><discord-embed embed-title=\"💡 Suporte\" slot=\"embeds\" color=\"#2f3136\"><discord-embed-description slot=\"description\">Olá, por favor especifique como podemos te ajudar para um atendimento assertivo.<br/><br/><discord-custom-emoji name=\"⚙️\" url=\"https://cdnjs.cloudflare.com/ajax/libs/twemoji/14.0.2/svg/2699.svg\" embed-emoji=\"true\"></discord-custom-emoji> <discord-underlined><discord-bold>Adicionar ou remover membros:</discord-bold></discord-underlined><br/>Use um dos botões de acordo com a ação que você deseja fazer.</discord-embed-description><discord-embed-footer slot=\"footer\" footer-image=\"https://images-ext-1.discordapp.net/external/yLihPFx_FJKzd-UOjQ2RQepRLMFFzhNqekN8YKwk7N8/https/cdn.discordapp.com/avatars/1003801622247383180/a_24e84ba106cec0b4a5ed5cd3ac391f2c.gif\" timestamp=\"2025-12-01T13:05:42.455000+00:00\">REFÚGIO SC © Todos os direitos reservados.</discord-embed-footer></discord-embed><discord-attachments slot=\"components\"><discord-action-row><discord-button type=\"primary\" emoji=\"https://cdnjs.cloudflare.com/ajax/libs/twemoji/14.0.2/svg/1f464.svg\">Adicionar</discord-button><discord-button type=\"destructive\" emoji=\"https://cdnjs.cloudflare.com/ajax/libs/twemoji/14.0.2/svg/1f6b7.svg\">Remover</discord-button><discord-button type=\"success\" emoji=\"https://cdnjs.cloudflare.com/ajax/libs/twemoji/14.0.2/svg/2705.svg\">Finalizar Ticket</discord-button></discord-action-row><discord-action-row><discord-button type=\"secondary\" emoji=\"https://cdnjs.cloudflare.com/ajax/libs/twemoji/14.0.2/svg/270f.svg\">Trocar nome do Canal</discord-button><discord-button type=\"secondary\" emoji=\"https://cdnjs.cloudflare.com/ajax/libs/twemoji/14.0.2/svg/2699.svg\">Trocar Categoria</discord-button><discord-button type=\"secondary\" emoji=\"https://cdnjs.cloudflare.com/ajax/libs/twemoji/14.0.2/svg/1f514.svg\">POKE</discord-button></discord-action-row></discord-attachments></discord-message><discord-system-message id=\"m-1445038151973339378\" type=\"pin\"><i style=\"color:#ffffff\">Refúgio</i> pinned <i data-goto=\"1445038151050727484\">a message</i> to this channel.</discord-system-message><discord-message id=\"m-1445038183359451338\" timestamp=\"2025-12-01T13:05:50.424Z\" edited=\"false\" highlight=\"false\" profile=\"964947028520079402\">Quando lançaaaaaaaaa</discord-message><discord-message id=\"m-1445038262224818260\" timestamp=\"2025-12-01T13:06:09.227Z\" edited=\"false\" highlight=\"false\" profile=\"735724009056108566\">Primeiramente bom dia</discord-message><discord-message id=\"m-1445038263529246791\" timestamp=\"2025-12-01T13:06:09.538Z\" edited=\"false\" highlight=\"false\" profile=\"1003801622247383180\"><discord-embed embed-title=\"Ticket assumido\" slot=\"embeds\" color=\"#2f3136\"><discord-embed-description slot=\"description\">O ticket foi assumido pelo staff <discord-mention type=\"user\">Ez</discord-mention></discord-embed-description><discord-embed-footer slot=\"footer\" footer-image=\"https://images-ext-1.discordapp.net/external/yLihPFx_FJKzd-UOjQ2RQepRLMFFzhNqekN8YKwk7N8/https/cdn.discordapp.com/avatars/1003801622247383180/a_24e84ba106cec0b4a5ed5cd3ac391f2c.gif\" timestamp=\"2025-12-01T13:06:09.335000+00:00\">REFÚGIO SC © Todos os direitos reservados.</discord-embed-footer></discord-embed></discord-message><discord-message id=\"m-1445038283414438053\" timestamp=\"2025-12-01T13:06:14.279Z\" edited=\"false\" highlight=\"false\" profile=\"964947028520079402\">Bom dia kkk</discord-message><discord-message id=\"m-1445038430424924244\" timestamp=\"2025-12-01T13:06:49.329Z\" edited=\"false\" highlight=\"false\" profile=\"964947028520079402\">To só na ansiedade <discord-custom-emoji name=\"sc\" url=\"https://cdn.discordapp.com/emojis/970838322819760208.png\" embed-emoji=\"false\"></discord-custom-emoji><discord-reactions slot=\"reactions\"><discord-reaction name=\"refugioguaxinim\" emoji=\"https://cdn.discordapp.com/emojis/1251973747951271957.png\" count=\"1\"></discord-reaction></discord-reactions></discord-message><discord-message id=\"m-1445038435415887892\" timestamp=\"2025-12-01T13:06:50.519Z\" edited=\"false\" highlight=\"false\" profile=\"735724009056108566\">A data oficial será divulgada em breve peço aguarde e cuide a aba de aviso e spoiler</discord-message><discord-message id=\"m-1445038497046986884\" timestamp=\"2025-12-01T13:07:05.213Z\" edited=\"false\" highlight=\"false\" profile=\"964947028520079402\">Só da uma dica, essa ano ainda?</discord-message><discord-message id=\"m-1445038537215967475\" timestamp=\"2025-12-01T13:07:14.790Z\" edited=\"false\" server=\"false\" highlight=\"false\" profile=\"735724009056108566\"><discord-reply slot=\"reply\" edited=\"false\" attachment=\"false\" author=\"gian araujo998\" role-color=\"#11806a\" bot=\"false\" verified=\"false\" op=\"false\" command=\"false\"><span data-goto=\"1445038430424924244\">To só na ansiedade <discord-custom-emoji name=\"sc\" url=\"https://cdn.discordapp.com/emojis/970838322819760208.png\" embed-emoji=\"false\"></discord-custom-emoji></span></discord-reply>todos estamos<discord-custom-emoji name=\"🥳\" url=\"https://cdnjs.cloudflare.com/ajax/libs/twemoji/14.0.2/svg/1f973.svg\" embed-emoji=\"false\"></discord-custom-emoji></discord-message><discord-message id=\"m-1445038627632451605\" timestamp=\"2025-12-01T13:07:36.347Z\" edited=\"false\" highlight=\"false\" profile=\"735724009056108566\">como disse acima peço que aguarde o lançamento do aviso oficial</discord-message><discord-message id=\"m-1445038698508062853\" timestamp=\"2025-12-01T13:07:53.245Z\" edited=\"false\" highlight=\"false\" profile=\"735724009056108566\">não vamos quebrar a expectativa.<discord-custom-emoji name=\"😁\" url=\"https://cdnjs.cloudflare.com/ajax/libs/twemoji/14.0.2/svg/1f601.svg\" embed-emoji=\"false\"></discord-custom-emoji></discord-message><discord-message id=\"m-1445038800723247214\" timestamp=\"2025-12-01T13:08:17.615Z\" edited=\"false\" highlight=\"false\" profile=\"964947028520079402\">Kkkkkkkk fechou, todas as contas foram desbanidas ne?</discord-message><discord-message id=\"m-1445038812018376745\" timestamp=\"2025-12-01T13:08:20.308Z\" edited=\"false\" highlight=\"false\" profile=\"735724009056108566\">mas pode ter certeza que quando abrir vamos voltar com tudo!!</discord-message><discord-message id=\"m-1445038864925200415\" timestamp=\"2025-12-01T13:08:32.922Z\" edited=\"false\" server=\"false\" highlight=\"false\" profile=\"964947028520079402\"><discord-reply slot=\"reply\" edited=\"false\" attachment=\"false\" author=\"Ez\" avatar=\"https://cdn.discordapp.com/avatars/735724009056108566/8d3e4781c5ccf56924a5fd0667451873.webp?size=32\" role-color=\"#1f8b4c\" bot=\"false\" verified=\"false\" op=\"false\" command=\"false\"><span data-goto=\"1445038812018376745\">mas pode ter certeza que quando abrir vamos voltar com tudo!!</span></discord-reply>Voces sao os melhores<discord-reactions slot=\"reactions\"><discord-reaction name=\"LogoS5\" emoji=\"https://cdn.discordapp.com/emojis/1439428414590292008.png\" count=\"1\"></discord-reaction></discord-reactions></discord-message><discord-message id=\"m-1445038960609857536\" timestamp=\"2025-12-01T13:08:55.735Z\" edited=\"false\" highlight=\"false\" profile=\"735724009056108566\">Ajudo em algo mais?</discord-message><discord-message id=\"m-1445039003979092019\" timestamp=\"2025-12-01T13:09:06.075Z\" edited=\"false\" highlight=\"false\" profile=\"964947028520079402\">As contar foram desbanidas?</discord-message><discord-message id=\"m-1445039543479701664\" timestamp=\"2025-12-01T13:11:14.702Z\" edited=\"false\" highlight=\"false\" profile=\"735724009056108566\">Sim</discord-message><discord-message id=\"m-1445040097174093834\" timestamp=\"2025-12-01T13:13:26.713Z\" edited=\"false\" highlight=\"false\" profile=\"735724009056108566\">Ajudo em algo mais? <discord-mention type=\"user\">gian araujo998</discord-mention></discord-message><discord-message id=\"m-1445043015784730638\" timestamp=\"2025-12-01T13:25:02.564Z\" edited=\"false\" highlight=\"false\" profile=\"964947028520079402\">Não</discord-message><discord-message id=\"m-1445043025012199518\" timestamp=\"2025-12-01T13:25:04.764Z\" edited=\"false\" highlight=\"false\" profile=\"964947028520079402\">Obrigado</discord-message><discord-message id=\"m-1445050330604896440\" timestamp=\"2025-12-01T13:54:06.553Z\" edited=\"true\" server=\"false\" highlight=\"false\" profile=\"1003801622247383180\"><discord-reply slot=\"reply\">Message could not be loaded.</discord-reply><discord-embed embed-title=\"⚙️ Ticket fechado\" slot=\"embeds\" color=\"#2f3136\"><discord-embed-description slot=\"description\">Ticket fechado em 01/12/2025, 10:54:13 por <discord-mention type=\"user\">Ez</discord-mention>!<br/>Este canal será deletado em 5 segundos.</discord-embed-description><discord-embed-fields slot=\"fields\"><discord-embed-field field-title=\"📦 **__Motivo do fechamento:__**\" inline=\"false\" inline-index=\"1\"><discord-code-block language=\"\" code=\"Concluído\"></discord-code-block></discord-embed-field></discord-embed-fields><discord-embed-footer slot=\"footer\" footer-image=\"https://images-ext-1.discordapp.net/external/yLihPFx_FJKzd-UOjQ2RQepRLMFFzhNqekN8YKwk7N8/https/cdn.discordapp.com/avatars/1003801622247383180/a_24e84ba106cec0b4a5ed5cd3ac391f2c.gif\" timestamp=\"2025-12-01T13:54:13.162000+00:00\">REFÚGIO SC © Todos os direitos reservados.</discord-embed-footer></discord-embed></discord-message><div style=\"text-align:center;width:100%\">Refúgio SC - Ticket Transcript </div></discord-messages></body></html>'),
(8001,'<html><head><meta charSet=\"utf-8\"/><meta name=\"viewport\" content=\"width=device-width, initial-scale=1\"/><link rel=\"icon\" type=\"image/png\" href=\"https://cdn.discordapp.com/icons/491309213553917952/a_34648f7a1342a2a7343585d52d846f0b.gif?size=16\"/><title>⚡┃assumir-pcsc-1</title><script>document.addEventListener(\"click\",t=>{let e=t.target;if(!e)return;let o=e?.getAttribute(\"data-goto\");if(o){let r=document.getElementById(`m-${o}`);r?(r.scrollIntoView({behavior:\"smooth\",block:\"center\"}),r.style.backgroundColor=\"rgba(148, 156, 247, 0.1)\",r.style.transition=\"background-color 0.5s ease\",setTimeout(()=>{r.style.backgroundColor=\"transparent\"},1e3)):console.warn(\"Message ${goto} not found.\")}});</script><script>window.$discordMessage={profiles:{\"1003801622247383180\":{\"author\":\"Refúgio\",\"avatar\":\"https://cdn.discordapp.com/avatars/1003801622247383180/a_24e84ba106cec0b4a5ed5cd3ac391f2c.gif?size=64\",\"roleColor\":\"#ffffff\",\"roleIcon\":\"https://cdn.discordapp.com/role-icons/927207618638925854/d6353d6117aff284e0a3816bc59d2336.webp\",\"roleName\":\"Turixta\",\"bot\":true,\"verified\":false},\"966537383866679377\":{\"author\":\"Moraes.03\",\"avatar\":\"https://cdn.discordapp.com/avatars/966537383866679377/734adcca3a40a262685abc594683fb5b.webp?size=64\",\"bot\":false,\"verified\":false},\"1129474865582325820\":{\"author\":\"thiaguera\",\"avatar\":\"https://cdn.discordapp.com/avatars/1129474865582325820/c89f21cbc8c69b691cdfb7419bf10d8b.webp?size=64\",\"roleColor\":\"#11806a\",\"roleIcon\":\"https://cdn.discordapp.com/role-icons/927207618638925854/d6353d6117aff284e0a3816bc59d2336.webp\",\"roleName\":\"Turixta\",\"bot\":false,\"verified\":false},\"925036586645721129\":{\"author\":\"[🦇] Giovanni\",\"avatar\":\"https://cdn.discordapp.com/avatars/925036586645721129/19f9a7f35745c82fd6fb7a8b67b2a588.webp?size=64\",\"roleColor\":\"#e0b395\",\"roleIcon\":\"https://cdn.discordapp.com/role-icons/1287127015366852781/def74d8faac1ba9189af0e049ebfbfad.webp\",\"roleName\":\"SERVIDOR・AUXILIAR\",\"bot\":false,\"verified\":false}}}</script><script type=\"module\" src=\"https://cdn.jsdelivr.net/npm/@derockdev/discord-components-core@^3.6.1/dist/derockdev-discord-components-core/derockdev-discord-components-core.esm.js\"></script></head><body style=\"margin:0;min-height:100vh\"><discord-messages style=\"min-height:100vh\"><discord-header guild=\"Refúgio Roleplay 💚\" channel=\"⚡┃assumir-pcsc-1\" icon=\"https://cdn.discordapp.com/icons/491309213553917952/a_34648f7a1342a2a7343585d52d846f0b.gif?size=128\">This is the start of #⚡┃assumir-pcsc-1 channel.</discord-header><discord-message id=\"m-1445177616318468160\" timestamp=\"2025-12-01T22:19:53.832Z\" edited=\"false\" highlight=\"false\" profile=\"1003801622247383180\"><discord-mention type=\"user\">thiaguera</discord-mention>, <discord-mention type=\"role\" color=\"#c27c0e\">SERVIDOR・EQUIPE</discord-mention>, <discord-mention type=\"role\" color=\"#83c5fa\">SERVIDOR・RESP.  POLICIAS</discord-mention>, <discord-mention type=\"role\" color=\"#e74c3c\">SERVIDOR・RESP.  ILEGAL</discord-mention><discord-embed embed-title=\"⚡ Assumir fac/org/corp\" slot=\"embeds\" color=\"#2f3136\" thumbnail=\"https://images-ext-1.discordapp.net/external/rnVIHkM9dfHdLUYlwILcx7NBoLphh5CK1uaRUM1A_9I/https/cdn.discordapp.com/avatars/1129474865582325820/c89f21cbc8c69b691cdfb7419bf10d8b.webp\"><discord-embed-description slot=\"description\">Olá, por favor nos informe qual a facção, organização ou corporação que deseja assumir.<br/>Mas primeiro, leia as regras para poder assumir e verifique se a sua escolhe está livre. Você pode verificar em <discord-mention type=\"channel\">📂・para-assumir</discord-mention>.<br/><br/><discord-custom-emoji name=\"⚙️\" url=\"https://cdnjs.cloudflare.com/ajax/libs/twemoji/14.0.2/svg/2699.svg\" embed-emoji=\"true\"></discord-custom-emoji> <discord-underlined><discord-bold>Adicionar ou remover membros:</discord-bold></discord-underlined><br/>Use um dos botões de acordo com a ação que você deseja fazer.</discord-embed-description><discord-embed-footer slot=\"footer\" footer-image=\"https://images-ext-1.discordapp.net/external/yLihPFx_FJKzd-UOjQ2RQepRLMFFzhNqekN8YKwk7N8/https/cdn.discordapp.com/avatars/1003801622247383180/a_24e84ba106cec0b4a5ed5cd3ac391f2c.gif\" timestamp=\"2025-12-01T22:19:53.583000+00:00\">REFÚGIO SC © Todos os direitos reservados.</discord-embed-footer></discord-embed><discord-attachments slot=\"components\"><discord-action-row><discord-button type=\"primary\" emoji=\"https://cdnjs.cloudflare.com/ajax/libs/twemoji/14.0.2/svg/1f464.svg\">Adicionar</discord-button><discord-button type=\"destructive\" emoji=\"https://cdnjs.cloudflare.com/ajax/libs/twemoji/14.0.2/svg/1f6b7.svg\">Remover</discord-button><discord-button type=\"success\" emoji=\"https://cdnjs.cloudflare.com/ajax/libs/twemoji/14.0.2/svg/2705.svg\">Finalizar Ticket</discord-button></discord-action-row><discord-action-row><discord-button type=\"secondary\" emoji=\"https://cdnjs.cloudflare.com/ajax/libs/twemoji/14.0.2/svg/270f.svg\">Trocar nome do Canal</discord-button><discord-button type=\"secondary\" emoji=\"https://cdnjs.cloudflare.com/ajax/libs/twemoji/14.0.2/svg/2699.svg\">Trocar Categoria</discord-button><discord-button type=\"secondary\" emoji=\"https://cdnjs.cloudflare.com/ajax/libs/twemoji/14.0.2/svg/1f514.svg\">POKE</discord-button></discord-action-row></discord-attachments></discord-message><discord-system-message id=\"m-1445177617283022881\" type=\"pin\"><i style=\"color:#ffffff\">Refúgio</i> pinned <i data-goto=\"1445177616318468160\">a message</i> to this channel.</discord-system-message><discord-message id=\"m-1445185673479847947\" timestamp=\"2025-12-01T22:51:54.809Z\" edited=\"false\" highlight=\"false\" profile=\"966537383866679377\">Boa tarde</discord-message><discord-message id=\"m-1445185676327784580\" timestamp=\"2025-12-01T22:51:55.488Z\" edited=\"false\" highlight=\"false\" profile=\"1003801622247383180\"><discord-embed embed-title=\"Ticket assumido\" slot=\"embeds\" color=\"#2f3136\"><discord-embed-description slot=\"description\">O ticket foi assumido pelo staff <discord-mention type=\"user\">Moraes.03</discord-mention></discord-embed-description><discord-embed-footer slot=\"footer\" footer-image=\"https://images-ext-1.discordapp.net/external/yLihPFx_FJKzd-UOjQ2RQepRLMFFzhNqekN8YKwk7N8/https/cdn.discordapp.com/avatars/1003801622247383180/a_24e84ba106cec0b4a5ed5cd3ac391f2c.gif\" timestamp=\"2025-12-01T22:51:54.993000+00:00\">REFÚGIO SC © Todos os direitos reservados.</discord-embed-footer></discord-embed></discord-message><discord-message id=\"m-1445185714592546988\" timestamp=\"2025-12-01T22:52:04.611Z\" edited=\"false\" highlight=\"false\" profile=\"966537383866679377\">Como posso ajudar <discord-mention type=\"user\">thiaguera</discord-mention>?</discord-message><discord-message id=\"m-1445186064754151626\" timestamp=\"2025-12-01T22:53:28.096Z\" edited=\"false\" highlight=\"false\" profile=\"1129474865582325820\">Oopa</discord-message><discord-message id=\"m-1445186071448260680\" timestamp=\"2025-12-01T22:53:29.692Z\" edited=\"false\" highlight=\"false\" profile=\"1129474865582325820\">boa noite</discord-message><discord-message id=\"m-1445186139794313237\" timestamp=\"2025-12-01T22:53:45.987Z\" edited=\"false\" highlight=\"false\" profile=\"1129474865582325820\">estou querendo assumir a policia civil, na ultima season assumi o HP</discord-message><discord-message id=\"m-1445186222724219054\" timestamp=\"2025-12-01T22:54:05.759Z\" edited=\"false\" highlight=\"false\" profile=\"1129474865582325820\">e estamos com a equipe para assumir a policia</discord-message><discord-message id=\"m-1445186803358367815\" timestamp=\"2025-12-01T22:56:24.193Z\" edited=\"false\" highlight=\"false\" profile=\"925036586645721129\">Boa noite, <discord-mention type=\"user\">thiaguera</discord-mention> ! tudo bem?<br/><br/>me chamo <discord-bold>Giovanni Ricci</discord-bold> e estou aqui para lhe auxiliar!<br/><br/>Com quantas pessoas você esta no efetivo?</discord-message><discord-message id=\"m-1445187819688431636\" timestamp=\"2025-12-01T23:00:26.505Z\" edited=\"false\" highlight=\"false\" profile=\"1129474865582325820\">no momento 8</discord-message><discord-message id=\"m-1445187850822877325\" timestamp=\"2025-12-01T23:00:33.928Z\" edited=\"false\" highlight=\"false\" profile=\"1129474865582325820\">alguns vão para o ilegal</discord-message><discord-message id=\"m-1445187952870428723\" timestamp=\"2025-12-01T23:00:58.258Z\" edited=\"false\" highlight=\"false\" profile=\"1129474865582325820\">mas vai ser tranquilo conseguir o restante</discord-message><discord-message id=\"m-1445188519902449765\" timestamp=\"2025-12-01T23:03:13.449Z\" edited=\"false\" highlight=\"false\" profile=\"925036586645721129\">ja com esses que vao para o ilegal sao 8 ou sem eles?</discord-message><discord-message id=\"m-1445189437033021563\" timestamp=\"2025-12-01T23:06:52.110Z\" edited=\"false\" highlight=\"false\" profile=\"1129474865582325820\">são 8 sem</discord-message><discord-message id=\"m-1445189457711202398\" timestamp=\"2025-12-01T23:06:57.040Z\" edited=\"false\" highlight=\"false\" profile=\"1129474865582325820\">8 ja estão comigo</discord-message><discord-message id=\"m-1445189534903046155\" timestamp=\"2025-12-01T23:07:15.444Z\" edited=\"false\" highlight=\"false\" profile=\"1129474865582325820\">tem data para abrir a cidade?</discord-message><discord-message id=\"m-1445189802604363776\" timestamp=\"2025-12-01T23:08:19.269Z\" edited=\"false\" highlight=\"false\" profile=\"1129474865582325820\">na 3 ou 2 season já tinha assumido a civil, era a época do matarazzo</discord-message><discord-message id=\"m-1445191211576066069\" timestamp=\"2025-12-01T23:13:55.194Z\" edited=\"false\" server=\"false\" highlight=\"false\" profile=\"925036586645721129\"><discord-reply slot=\"reply\" edited=\"false\" attachment=\"false\" author=\"thiaguera\" avatar=\"https://cdn.discordapp.com/avatars/1129474865582325820/c89f21cbc8c69b691cdfb7419bf10d8b.webp?size=32\" role-color=\"#11806a\" bot=\"false\" verified=\"false\" op=\"false\" command=\"false\"><span data-goto=\"1445189457711202398\">8 ja estão comigo</span></discord-reply>certo</discord-message><discord-message id=\"m-1445191242815246387\" timestamp=\"2025-12-01T23:14:02.642Z\" edited=\"false\" server=\"false\" highlight=\"false\" profile=\"925036586645721129\"><discord-reply slot=\"reply\" edited=\"false\" attachment=\"false\" author=\"thiaguera\" avatar=\"https://cdn.discordapp.com/avatars/1129474865582325820/c89f21cbc8c69b691cdfb7419bf10d8b.webp?size=32\" role-color=\"#11806a\" bot=\"false\" verified=\"false\" op=\"false\" command=\"false\"><span data-goto=\"1445189534903046155\">tem data para abrir a cidade?</span></discord-reply>em breve sera divulgado</discord-message><discord-message id=\"m-1445191261404266558\" timestamp=\"2025-12-01T23:14:07.074Z\" edited=\"false\" server=\"false\" highlight=\"false\" profile=\"925036586645721129\"><discord-reply slot=\"reply\" edited=\"false\" attachment=\"false\" author=\"thiaguera\" avatar=\"https://cdn.discordapp.com/avatars/1129474865582325820/c89f21cbc8c69b691cdfb7419bf10d8b.webp?size=32\" role-color=\"#11806a\" bot=\"false\" verified=\"false\" op=\"false\" command=\"false\"><span data-goto=\"1445189802604363776\">na 3 ou 2 season já tinha assumido a civil, era a época do matarazzo</span></discord-reply>entendi</discord-message><discord-message id=\"m-1445192194200965210\" timestamp=\"2025-12-01T23:17:49.470Z\" edited=\"false\" highlight=\"false\" profile=\"925036586645721129\">bom, o minimo seria de 15 pessoas, posso liberar com 12 e voce tem 48h para por as 15 no painel!<br/><br/>para assumir, precisamos de algumas coisas<br/><br/>1. Preciso de um projeto em documento de word contendo as cidades que voce e seu contigente ja passaram, se ja atuaram como policia civil, o que e a policia civil de sc, e etc<br/><br/>2. preciso da hierarquia de voces no nosso modelo de hierquia<br/><br/><a href=\"https://docs.google.com/spreadsheets/d/1aZqjsgw26Iu03sHMBjE0ysndipR5tIOC1fCQZrAlGow/edit?gid=0#gid=0\" target=\"_blank\" rel=\"noreferrer\">https://docs.google.com/spreadsheets/d/1aZqjsgw26Iu03sHMBjE0ysndipR5tIOC1fCQZrAlGow/edit?gid=0#gid=0</a><br/><br/>obs: caso outra pessoa abre o ticket, com 15 pessoas e um projeto impecavel e melhor que o seu, a pessoa assume, varia de projeto para projeto, entao, aconselho que faça um impecavel projeto.<discord-embed embed-title=\"hierarquia\" slot=\"embeds\" thumbnail=\"https://images-ext-1.discordapp.net/external/vrbnJTHd4G_NGycvu41Zx3qXh_PQsINLVISskDUi8mw/https/lh7-us.googleusercontent.com/docs/AHkbwyKVxKG2nZD2UrkIZ3SNXU72B9I3njghQ4TStaYGk2Tb-kQeyT0p3Kz7W-3AEYxIkSh-JpmOwp1z4iXrq8iarbyYXF6ucrCeLMenP_kAPQaMOz37lFI%3Dw1200-h630-p\" url=\"https://docs.google.com/spreadsheets/d/1aZqjsgw26Iu03sHMBjE0ysndipR5tIOC1fCQZrAlGow/edit?gid=0\"></discord-embed></discord-message><discord-message id=\"m-1445194298994982973\" timestamp=\"2025-12-01T23:26:11.292Z\" edited=\"false\" highlight=\"false\" profile=\"1129474865582325820\">temos um projeto mas iria usar todas as policias e o juridico</discord-message><discord-message id=\"m-1445194340875112539\" timestamp=\"2025-12-01T23:26:21.277Z\" edited=\"false\" highlight=\"false\" profile=\"1129474865582325820\">das prisoes no caso</discord-message><discord-message id=\"m-1445194546756714688\" timestamp=\"2025-12-01T23:27:10.363Z\" edited=\"false\" highlight=\"false\" profile=\"1129474865582325820\">as prisões seria feitas, levadas a delegacia sendo feito o BO, o elemento encaminhado para o forum para julgameno</discord-message><discord-message id=\"m-1445194636833587320\" timestamp=\"2025-12-01T23:27:31.839Z\" edited=\"false\" highlight=\"false\" profile=\"1129474865582325820\">isso resultaria em um RP muito mais imersivo principalmente para policias</discord-message><discord-message id=\"m-1445194646719299805\" timestamp=\"2025-12-01T23:27:34.196Z\" edited=\"false\" highlight=\"false\" profile=\"1129474865582325820\">juridico</discord-message><discord-message id=\"m-1445194659834892389\" timestamp=\"2025-12-01T23:27:37.323Z\" edited=\"false\" highlight=\"false\" profile=\"1129474865582325820\">e advocacia</discord-message><discord-message id=\"m-1445194950063951953\" timestamp=\"2025-12-01T23:28:46.519Z\" edited=\"false\" highlight=\"false\" profile=\"1129474865582325820\">Com base nisto, as prisoes teriam sido levadas a dp, lá seriam feito as interrogações e desas interrogações as futuras ocupaçoes de favelas</discord-message><discord-message id=\"m-1445245594087194786\" timestamp=\"2025-12-02T02:50:00.995Z\" edited=\"false\" highlight=\"false\" profile=\"925036586645721129\">certo, peço que voce faça esse projeto por escrito, nos envie, iremos avaliar e damos a resposta</discord-message><discord-message id=\"m-1445245681299357776\" timestamp=\"2025-12-02T02:50:21.788Z\" edited=\"false\" highlight=\"false\" profile=\"925036586645721129\">fica em aberto, 24h para envio do projeto<br/><br/>fico em aguardo</discord-message><discord-message id=\"m-1445591268167127040\" timestamp=\"2025-12-03T01:43:36.118Z\" edited=\"false\" highlight=\"false\" profile=\"925036586645721129\">Boa noite, <discord-mention type=\"user\">thiaguera</discord-mention> ! <br/><br/>Restam uma hora para envio do projeto, caso não seja enviado, será considerado como falta de interação da parte solicitante. Sendo necessário refazer todo o atendimento.</discord-message><discord-message id=\"m-1445971923635802203\" timestamp=\"2025-12-04T02:56:11.454Z\" edited=\"false\" highlight=\"false\" profile=\"925036586645721129\">Boa noite, <discord-mention type=\"user\">thiaguera</discord-mention> !<br/><br/>Por falta de interaçao (48h apos a abertura) o ticket sera finalizado.</discord-message><discord-message id=\"m-1445971925997322391\" timestamp=\"2025-12-04T02:56:12.017Z\" edited=\"false\" highlight=\"false\" profile=\"1003801622247383180\">Vejo que nosso staffer <discord-mention type=\"user\">Giovannizin</discord-mention> veio te ajudar agora. Vou deixar vocês à vontade, e desejo um ótimo atendimento! <discord-custom-emoji name=\"😊\" url=\"https://cdnjs.cloudflare.com/ajax/libs/twemoji/14.0.2/svg/1f60a.svg\" embed-emoji=\"false\"></discord-custom-emoji></discord-message><discord-message id=\"m-1445971956988903479\" timestamp=\"2025-12-04T02:56:19.406Z\" edited=\"true\" server=\"false\" highlight=\"false\" profile=\"1003801622247383180\"><discord-reply slot=\"reply\">Message could not be loaded.</discord-reply><discord-embed embed-title=\"⚙️ Ticket fechado\" slot=\"embeds\" color=\"#2f3136\"><discord-embed-description slot=\"description\">Ticket fechado em 03/12/2025, 23:56:30 por <discord-mention type=\"user\">Giovannizin</discord-mention>!<br/>Este canal será deletado em 5 segundos.</discord-embed-description><discord-embed-fields slot=\"fields\"><discord-embed-field field-title=\"📦 **__Motivo do fechamento:__**\" inline=\"false\" inline-index=\"1\"><discord-code-block language=\"\" code=\"Inatividade\"></discord-code-block></discord-embed-field></discord-embed-fields><discord-embed-footer slot=\"footer\" footer-image=\"https://images-ext-1.discordapp.net/external/yLihPFx_FJKzd-UOjQ2RQepRLMFFzhNqekN8YKwk7N8/https/cdn.discordapp.com/avatars/1003801622247383180/a_24e84ba106cec0b4a5ed5cd3ac391f2c.gif\" timestamp=\"2025-12-04T02:56:30.623000+00:00\">REFÚGIO SC © Todos os direitos reservados.</discord-embed-footer></discord-embed></discord-message><div style=\"text-align:center;width:100%\">Refúgio SC - Ticket Transcript </div></discord-messages></body></html>'),
(8002,'<html><head><meta charSet=\"utf-8\"/><meta name=\"viewport\" content=\"width=device-width, initial-scale=1\"/><link rel=\"icon\" type=\"image/png\" href=\"https://cdn.discordapp.com/icons/491309213553917952/a_34648f7a1342a2a7343585d52d846f0b.gif?size=16\"/><title>💡┃resolvido-camih</title><script>document.addEventListener(\"click\",t=>{let e=t.target;if(!e)return;let o=e?.getAttribute(\"data-goto\");if(o){let r=document.getElementById(`m-${o}`);r?(r.scrollIntoView({behavior:\"smooth\",block:\"center\"}),r.style.backgroundColor=\"rgba(148, 156, 247, 0.1)\",r.style.transition=\"background-color 0.5s ease\",setTimeout(()=>{r.style.backgroundColor=\"transparent\"},1e3)):console.warn(\"Message ${goto} not found.\")}});</script><script>window.$discordMessage={profiles:{\"1003801622247383180\":{\"author\":\"Refúgio\",\"avatar\":\"https://cdn.discordapp.com/avatars/1003801622247383180/a_24e84ba106cec0b4a5ed5cd3ac391f2c.gif?size=64\",\"roleColor\":\"#ffffff\",\"roleIcon\":\"https://cdn.discordapp.com/role-icons/927207618638925854/d6353d6117aff284e0a3816bc59d2336.webp\",\"roleName\":\"Turixta\",\"bot\":true,\"verified\":false},\"934235845219745842\":{\"author\":\"Love Shop • bella\",\"avatar\":\"https://cdn.discordapp.com/avatars/934235845219745842/469393f05ea5cd150dede55c721a366e.webp?size=64\",\"roleColor\":\"#11806a\",\"roleIcon\":\"https://cdn.discordapp.com/role-icons/927207618638925854/d6353d6117aff284e0a3816bc59d2336.webp\",\"roleName\":\"Turixta\",\"bot\":false,\"verified\":false},\"497842919835697162\":{\"author\":\"! ⌊🦄⌉ 𝓒𝓪𝓶𝓲𝓱\",\"avatar\":\"https://cdn.discordapp.com/guilds/491309213553917952/users/497842919835697162/avatars/1e782b51f7af9b9176f2af91a2552d5b.webp?size=64\",\"roleColor\":\"#a10b7b\",\"roleIcon\":\"https://cdn.discordapp.com/role-icons/927290367391440987/ecbf2e4ace6a2c155403eb391ac6b64c.webp\",\"roleName\":\"SERVIDOR・CFO\",\"bot\":false,\"verified\":false}}}</script><script type=\"module\" src=\"https://cdn.jsdelivr.net/npm/@derockdev/discord-components-core@^3.6.1/dist/derockdev-discord-components-core/derockdev-discord-components-core.esm.js\"></script></head><body style=\"margin:0;min-height:100vh\"><discord-messages style=\"min-height:100vh\"><discord-header guild=\"Refúgio Roleplay 💚\" channel=\"💡┃resolvido-camih\" icon=\"https://cdn.discordapp.com/icons/491309213553917952/a_34648f7a1342a2a7343585d52d846f0b.gif?size=128\">This is the start of #💡┃resolvido-camih channel.</discord-header><discord-message id=\"m-1445235657042690058\" timestamp=\"2025-12-02T02:10:31.819Z\" edited=\"false\" highlight=\"false\" profile=\"1003801622247383180\"><discord-mention type=\"user\">bella</discord-mention>, <discord-mention type=\"role\" color=\"#c27c0e\">SERVIDOR・EQUIPE</discord-mention><discord-embed embed-title=\"💡 Suporte\" slot=\"embeds\" color=\"#2f3136\" thumbnail=\"https://images-ext-1.discordapp.net/external/r6kQykfWFYu7bk4z_CPO5oTkYDkRuOUbMldjUyA5rlo/https/cdn.discordapp.com/avatars/934235845219745842/469393f05ea5cd150dede55c721a366e.webp\"><discord-embed-description slot=\"description\">Olá, por favor especifique como podemos te ajudar para um atendimento assertivo.<br/><br/><discord-custom-emoji name=\"⚙️\" url=\"https://cdnjs.cloudflare.com/ajax/libs/twemoji/14.0.2/svg/2699.svg\" embed-emoji=\"true\"></discord-custom-emoji> <discord-underlined><discord-bold>Adicionar ou remover membros:</discord-bold></discord-underlined><br/>Use um dos botões de acordo com a ação que você deseja fazer.</discord-embed-description><discord-embed-footer slot=\"footer\" footer-image=\"https://images-ext-1.discordapp.net/external/yLihPFx_FJKzd-UOjQ2RQepRLMFFzhNqekN8YKwk7N8/https/cdn.discordapp.com/avatars/1003801622247383180/a_24e84ba106cec0b4a5ed5cd3ac391f2c.gif\" timestamp=\"2025-12-02T02:10:31.550000+00:00\">REFÚGIO SC © Todos os direitos reservados.</discord-embed-footer></discord-embed><discord-attachments slot=\"components\"><discord-action-row><discord-button type=\"primary\" emoji=\"https://cdnjs.cloudflare.com/ajax/libs/twemoji/14.0.2/svg/1f464.svg\">Adicionar</discord-button><discord-button type=\"destructive\" emoji=\"https://cdnjs.cloudflare.com/ajax/libs/twemoji/14.0.2/svg/1f6b7.svg\">Remover</discord-button><discord-button type=\"success\" emoji=\"https://cdnjs.cloudflare.com/ajax/libs/twemoji/14.0.2/svg/2705.svg\">Finalizar Ticket</discord-button></discord-action-row><discord-action-row><discord-button type=\"secondary\" emoji=\"https://cdnjs.cloudflare.com/ajax/libs/twemoji/14.0.2/svg/270f.svg\">Trocar nome do Canal</discord-button><discord-button type=\"secondary\" emoji=\"https://cdnjs.cloudflare.com/ajax/libs/twemoji/14.0.2/svg/2699.svg\">Trocar Categoria</discord-button><discord-button type=\"secondary\" emoji=\"https://cdnjs.cloudflare.com/ajax/libs/twemoji/14.0.2/svg/1f514.svg\">POKE</discord-button></discord-action-row></discord-attachments></discord-message><discord-system-message id=\"m-1445235658254843987\" type=\"pin\"><i style=\"color:#ffffff\">Refúgio</i> pinned <i data-goto=\"1445235657042690058\">a message</i> to this channel.</discord-system-message><discord-message id=\"m-1445235784344141905\" timestamp=\"2025-12-02T02:11:02.170Z\" edited=\"false\" highlight=\"false\" profile=\"934235845219745842\">oioi, boa noite! eu tinha parceria com a city antes do wipe</discord-message><discord-message id=\"m-1445235837561339954\" timestamp=\"2025-12-02T02:11:14.858Z\" edited=\"false\" highlight=\"false\" profile=\"934235845219745842\">como podemos resolver para voltar a parceria?</discord-message><discord-message id=\"m-1445239853032931509\" timestamp=\"2025-12-02T02:27:12.221Z\" edited=\"false\" highlight=\"false\" profile=\"497842919835697162\">Oláá!</discord-message><discord-message id=\"m-1445239855318695938\" timestamp=\"2025-12-02T02:27:12.766Z\" edited=\"false\" highlight=\"false\" profile=\"1003801622247383180\"><discord-embed embed-title=\"Ticket assumido\" slot=\"embeds\" color=\"#2f3136\"><discord-embed-description slot=\"description\">O ticket foi assumido pelo staff <discord-mention type=\"user\">akami</discord-mention></discord-embed-description><discord-embed-footer slot=\"footer\" footer-image=\"https://images-ext-1.discordapp.net/external/yLihPFx_FJKzd-UOjQ2RQepRLMFFzhNqekN8YKwk7N8/https/cdn.discordapp.com/avatars/1003801622247383180/a_24e84ba106cec0b4a5ed5cd3ac391f2c.gif\" timestamp=\"2025-12-02T02:27:12.321000+00:00\">REFÚGIO SC © Todos os direitos reservados.</discord-embed-footer></discord-embed></discord-message><discord-message id=\"m-1445239863829070077\" timestamp=\"2025-12-02T02:27:14.795Z\" edited=\"false\" highlight=\"false\" profile=\"497842919835697162\">Booa noitee!</discord-message><discord-message id=\"m-1445240182461698098\" timestamp=\"2025-12-02T02:28:30.763Z\" edited=\"false\" highlight=\"false\" profile=\"497842919835697162\">Para fecharmos parceria sua loja deve cumprir os requisitos marcados no canal <discord-mention type=\"channel\">✉️・seja-parceiro</discord-mention> !</discord-message><discord-message id=\"m-1445240225243861024\" timestamp=\"2025-12-02T02:28:40.963Z\" edited=\"false\" highlight=\"false\" profile=\"497842919835697162\">Todos os requisitos estão de acordo?</discord-message><discord-message id=\"m-1445240444752629771\" timestamp=\"2025-12-02T02:29:33.298Z\" edited=\"false\" highlight=\"false\" profile=\"934235845219745842\">sim sim</discord-message><discord-message id=\"m-1445241420033036380\" timestamp=\"2025-12-02T02:33:25.823Z\" edited=\"false\" highlight=\"false\" profile=\"497842919835697162\">Consegue enviar o convite da loja?</discord-message><discord-message id=\"m-1445241450534141973\" timestamp=\"2025-12-02T02:33:33.095Z\" edited=\"false\" highlight=\"false\" profile=\"497842919835697162\">E a logo por gentileza</discord-message><discord-message id=\"m-1445241458692198406\" timestamp=\"2025-12-02T02:33:35.040Z\" edited=\"true\" highlight=\"false\" profile=\"934235845219745842\"><a href=\"https://discord.gg/ccYeu667Qf\" target=\"_blank\" rel=\"noreferrer\">https://discord.gg/ccYeu667Qf</a></discord-message><discord-message id=\"m-1445242183203684385\" timestamp=\"2025-12-02T02:36:27.777Z\" edited=\"false\" highlight=\"false\" profile=\"934235845219745842\"><discord-attachments slot=\"attachments\"><discord-attachment type=\"image\" size=\"4.6 MB\" slot=\"attachment\" url=\"https://cdn.discordapp.com/attachments/1445235652886003845/1445242182804967488/icon_loja.png?ex=6930f3ab&amp;is=692fa22b&amp;hm=a71d3bf47fb34ce1bb9198bc2538e530fe086ec4db9b05b8f781bc3c9c532c01&amp;\" alt=\"icon_loja.png\" width=\"3072\" height=\"3072\"></discord-attachment></discord-attachments></discord-message><discord-message id=\"m-1445245403632111717\" timestamp=\"2025-12-02T02:49:15.587Z\" edited=\"false\" highlight=\"false\" profile=\"497842919835697162\">Perfeito</discord-message><discord-message id=\"m-1445245438474191032\" timestamp=\"2025-12-02T02:49:23.894Z\" edited=\"false\" highlight=\"false\" profile=\"497842919835697162\">Mandei um ponto no chat</discord-message><discord-message id=\"m-1445246881361035437\" timestamp=\"2025-12-02T02:55:07.905Z\" edited=\"false\" highlight=\"false\" profile=\"497842919835697162\">Prontinho!</discord-message><discord-message id=\"m-1445246910616305785\" timestamp=\"2025-12-02T02:55:14.880Z\" edited=\"false\" highlight=\"false\" profile=\"497842919835697162\"><a href=\"https://discord.com/channels/491309213553917952/1445245619324194969\" target=\"_blank\" rel=\"noreferrer\">https://discord.com/channels/491309213553917952/1445245619324194969</a></discord-message><discord-message id=\"m-1445250777806540830\" timestamp=\"2025-12-02T03:10:36.890Z\" edited=\"false\" highlight=\"false\" profile=\"934235845219745842\">obgg</discord-message><discord-message id=\"m-1445250814774874265\" timestamp=\"2025-12-02T03:10:45.704Z\" edited=\"false\" highlight=\"false\" profile=\"934235845219745842\">apaguei a antiga postagem</discord-message><discord-message id=\"m-1445250835683610664\" timestamp=\"2025-12-02T03:10:50.689Z\" edited=\"false\" highlight=\"false\" profile=\"934235845219745842\">pode criar uma nova</discord-message><discord-message id=\"m-1445250853941411932\" timestamp=\"2025-12-02T03:10:55.042Z\" edited=\"false\" highlight=\"false\" profile=\"934235845219745842\"></discord-message><discord-message id=\"m-1445294150730780784\" timestamp=\"2025-12-02T06:02:57.801Z\" edited=\"false\" highlight=\"false\" profile=\"497842919835697162\">Ook, obrigada meu bemm!</discord-message><discord-message id=\"m-1445294184025034763\" timestamp=\"2025-12-02T06:03:05.739Z\" edited=\"false\" highlight=\"false\" profile=\"497842919835697162\">Te ajudo com algo maiss?</discord-message><discord-message id=\"m-1445357072312045608\" timestamp=\"2025-12-02T10:12:59.475Z\" edited=\"false\" highlight=\"false\" profile=\"934235845219745842\">nao nao</discord-message><discord-message id=\"m-1445357082264997979\" timestamp=\"2025-12-02T10:13:01.848Z\" edited=\"false\" highlight=\"false\" profile=\"934235845219745842\">obrigada</discord-message><discord-message id=\"m-1445604596469989466\" timestamp=\"2025-12-03T02:36:33.833Z\" edited=\"true\" server=\"false\" highlight=\"false\" profile=\"1003801622247383180\"><discord-reply slot=\"reply\">Message could not be loaded.</discord-reply><discord-embed embed-title=\"⚙️ Ticket fechado\" slot=\"embeds\" color=\"#2f3136\"><discord-embed-description slot=\"description\">Ticket fechado em 02/12/2025, 23:36:57 por <discord-mention type=\"user\">akami</discord-mention>!<br/>Este canal será deletado em 5 segundos.</discord-embed-description><discord-embed-fields slot=\"fields\"><discord-embed-field field-title=\"📦 **__Motivo do fechamento:__**\" inline=\"false\" inline-index=\"1\"><discord-code-block language=\"\" code=\"Parceria fechada! 🩷\"></discord-code-block></discord-embed-field></discord-embed-fields><discord-embed-footer slot=\"footer\" footer-image=\"https://images-ext-1.discordapp.net/external/yLihPFx_FJKzd-UOjQ2RQepRLMFFzhNqekN8YKwk7N8/https/cdn.discordapp.com/avatars/1003801622247383180/a_24e84ba106cec0b4a5ed5cd3ac391f2c.gif\" timestamp=\"2025-12-03T02:36:57.934000+00:00\">REFÚGIO SC © Todos os direitos reservados.</discord-embed-footer></discord-embed></discord-message><div style=\"text-align:center;width:100%\">Refúgio SC - Ticket Transcript </div></discord-messages></body></html>'),
(8005,'<html><head><meta charSet=\"utf-8\"/><meta name=\"viewport\" content=\"width=device-width, initial-scale=1\"/><link rel=\"icon\" type=\"image/png\" href=\"https://cdn.discordapp.com/icons/491309213553917952/a_34648f7a1342a2a7343585d52d846f0b.gif?size=16\"/><title>💡┃ticket-8005</title><script>document.addEventListener(\"click\",t=>{let e=t.target;if(!e)return;let o=e?.getAttribute(\"data-goto\");if(o){let r=document.getElementById(`m-${o}`);r?(r.scrollIntoView({behavior:\"smooth\",block:\"center\"}),r.style.backgroundColor=\"rgba(148, 156, 247, 0.1)\",r.style.transition=\"background-color 0.5s ease\",setTimeout(()=>{r.style.backgroundColor=\"transparent\"},1e3)):console.warn(\"Message ${goto} not found.\")}});</script><script>window.$discordMessage={profiles:{\"1003801622247383180\":{\"author\":\"Refúgio\",\"avatar\":\"https://cdn.discordapp.com/avatars/1003801622247383180/a_24e84ba106cec0b4a5ed5cd3ac391f2c.gif?size=64\",\"roleColor\":\"#ffffff\",\"roleIcon\":\"https://cdn.discordapp.com/role-icons/927207618638925854/d6353d6117aff284e0a3816bc59d2336.webp\",\"roleName\":\"Turixta\",\"bot\":true,\"verified\":false},\"611975873830060046\":{\"author\":\"GAÚCHO\",\"avatar\":\"https://cdn.discordapp.com/avatars/611975873830060046/e859956dfc5dd6c1318ea0274062b331.webp?size=64\",\"roleColor\":\"#11806a\",\"roleIcon\":\"https://cdn.discordapp.com/role-icons/927207618638925854/d6353d6117aff284e0a3816bc59d2336.webp\",\"roleName\":\"Turixta\",\"bot\":false,\"verified\":false},\"966537383866679377\":{\"author\":\"Moraes.03\",\"avatar\":\"https://cdn.discordapp.com/avatars/966537383866679377/734adcca3a40a262685abc594683fb5b.webp?size=64\",\"roleColor\":\"#e0b395\",\"roleIcon\":\"https://cdn.discordapp.com/role-icons/1287127015366852781/def74d8faac1ba9189af0e049ebfbfad.webp\",\"roleName\":\"SERVIDOR・AUXILIAR\",\"bot\":false,\"verified\":false}}}</script><script type=\"module\" src=\"https://cdn.jsdelivr.net/npm/@derockdev/discord-components-core@^3.6.1/dist/derockdev-discord-components-core/derockdev-discord-components-core.esm.js\"></script></head><body style=\"margin:0;min-height:100vh\"><discord-messages style=\"min-height:100vh\"><discord-header guild=\"Refúgio Roleplay 💚\" channel=\"💡┃ticket-8005\" icon=\"https://cdn.discordapp.com/icons/491309213553917952/a_34648f7a1342a2a7343585d52d846f0b.gif?size=128\">This is the start of #💡┃ticket-8005 channel.</discord-header><discord-message id=\"m-1445405366069497867\" timestamp=\"2025-12-02T13:24:53.604Z\" edited=\"false\" highlight=\"false\" profile=\"1003801622247383180\"><discord-mention type=\"user\">GAÚCHO</discord-mention>, <discord-mention type=\"role\" color=\"#c27c0e\">SERVIDOR・EQUIPE</discord-mention><discord-embed embed-title=\"💡 Suporte\" slot=\"embeds\" color=\"#2f3136\" thumbnail=\"https://images-ext-1.discordapp.net/external/Esz1lcx__YvlgYpjj2eB1F8X5194HEG6yAlx3rui8H8/https/cdn.discordapp.com/avatars/611975873830060046/e859956dfc5dd6c1318ea0274062b331.webp\"><discord-embed-description slot=\"description\">Olá, por favor especifique como podemos te ajudar para um atendimento assertivo.<br/><br/><discord-custom-emoji name=\"⚙️\" url=\"https://cdnjs.cloudflare.com/ajax/libs/twemoji/14.0.2/svg/2699.svg\" embed-emoji=\"true\"></discord-custom-emoji> <discord-underlined><discord-bold>Adicionar ou remover membros:</discord-bold></discord-underlined><br/>Use um dos botões de acordo com a ação que você deseja fazer.</discord-embed-description><discord-embed-footer slot=\"footer\" footer-image=\"https://images-ext-1.discordapp.net/external/yLihPFx_FJKzd-UOjQ2RQepRLMFFzhNqekN8YKwk7N8/https/cdn.discordapp.com/avatars/1003801622247383180/a_24e84ba106cec0b4a5ed5cd3ac391f2c.gif\" timestamp=\"2025-12-02T13:24:53.390000+00:00\">REFÚGIO SC © Todos os direitos reservados.</discord-embed-footer></discord-embed><discord-attachments slot=\"components\"><discord-action-row><discord-button type=\"primary\" emoji=\"https://cdnjs.cloudflare.com/ajax/libs/twemoji/14.0.2/svg/1f464.svg\">Adicionar</discord-button><discord-button type=\"destructive\" emoji=\"https://cdnjs.cloudflare.com/ajax/libs/twemoji/14.0.2/svg/1f6b7.svg\">Remover</discord-button><discord-button type=\"success\" emoji=\"https://cdnjs.cloudflare.com/ajax/libs/twemoji/14.0.2/svg/2705.svg\">Finalizar Ticket</discord-button></discord-action-row><discord-action-row><discord-button type=\"secondary\" emoji=\"https://cdnjs.cloudflare.com/ajax/libs/twemoji/14.0.2/svg/270f.svg\">Trocar nome do Canal</discord-button><discord-button type=\"secondary\" emoji=\"https://cdnjs.cloudflare.com/ajax/libs/twemoji/14.0.2/svg/2699.svg\">Trocar Categoria</discord-button><discord-button type=\"secondary\" emoji=\"https://cdnjs.cloudflare.com/ajax/libs/twemoji/14.0.2/svg/1f514.svg\">POKE</discord-button></discord-action-row></discord-attachments></discord-message><discord-system-message id=\"m-1445405367864660010\" type=\"pin\"><i style=\"color:#ffffff\">Refúgio</i> pinned <i data-goto=\"1445405366069497867\">a message</i> to this channel.</discord-system-message><discord-message id=\"m-1445405426546905210\" timestamp=\"2025-12-02T13:25:08.023Z\" edited=\"false\" highlight=\"false\" profile=\"611975873830060046\">liberar id</discord-message><discord-message id=\"m-1445428377811943458\" timestamp=\"2025-12-02T14:56:20.031Z\" edited=\"false\" highlight=\"false\" profile=\"966537383866679377\">Bom dia</discord-message><discord-message id=\"m-1445428381066723388\" timestamp=\"2025-12-02T14:56:20.807Z\" edited=\"false\" highlight=\"false\" profile=\"1003801622247383180\"><discord-embed embed-title=\"Ticket assumido\" slot=\"embeds\" color=\"#2f3136\"><discord-embed-description slot=\"description\">O ticket foi assumido pelo staff <discord-mention type=\"user\">Moraes.03</discord-mention></discord-embed-description><discord-embed-footer slot=\"footer\" footer-image=\"https://images-ext-1.discordapp.net/external/yLihPFx_FJKzd-UOjQ2RQepRLMFFzhNqekN8YKwk7N8/https/cdn.discordapp.com/avatars/1003801622247383180/a_24e84ba106cec0b4a5ed5cd3ac391f2c.gif\" timestamp=\"2025-12-02T14:56:20.226000+00:00\">REFÚGIO SC © Todos os direitos reservados.</discord-embed-footer></discord-embed></discord-message><discord-message id=\"m-1445428430920356032\" timestamp=\"2025-12-02T14:56:32.693Z\" edited=\"false\" highlight=\"false\" profile=\"966537383866679377\">Me chamo Moraes, eu vou lhe atender</discord-message><discord-message id=\"m-1445428878796521615\" timestamp=\"2025-12-02T14:58:19.475Z\" edited=\"false\" highlight=\"false\" profile=\"966537383866679377\"><discord-mention type=\"user\">GAÚCHO</discord-mention>, A cidade ainda não inaugurou a nova season, portanto não é possivel liberar o ID, para a cidade.</discord-message><discord-message id=\"m-1445428901361750056\" timestamp=\"2025-12-02T14:58:24.855Z\" edited=\"false\" highlight=\"false\" profile=\"966537383866679377\">Ajudo em algo mais?</discord-message><discord-message id=\"m-1445514836925485076\" timestamp=\"2025-12-02T20:39:53.490Z\" edited=\"false\" highlight=\"false\" profile=\"611975873830060046\">so isso</discord-message><discord-message id=\"m-1445514965774504059\" timestamp=\"2025-12-02T20:40:24.210Z\" edited=\"false\" server=\"false\" highlight=\"false\" profile=\"1003801622247383180\"><discord-reply slot=\"reply\" edited=\"false\" attachment=\"false\" author=\"Refúgio\" avatar=\"https://cdn.discordapp.com/avatars/1003801622247383180/a_24e84ba106cec0b4a5ed5cd3ac391f2c.gif?size=32\" role-color=\"#ffffff\" bot=\"true\" verified=\"false\" op=\"false\" command=\"false\"><span data-goto=\"1445405366069497867\"><discord-mention type=\"user\">GAÚCHO</discord-mention>, <discord-mention type=\"role\">SERVIDOR・EQUIPE</discord-mention></span></discord-reply><discord-embed embed-title=\"🎫 Fechar ticket\" slot=\"embeds\" color=\"#2f3136\"><discord-embed-description slot=\"description\">Você tem certeza que deseja fechar o ticket?</discord-embed-description><discord-embed-footer slot=\"footer\" footer-image=\"https://images-ext-1.discordapp.net/external/yLihPFx_FJKzd-UOjQ2RQepRLMFFzhNqekN8YKwk7N8/https/cdn.discordapp.com/avatars/1003801622247383180/a_24e84ba106cec0b4a5ed5cd3ac391f2c.gif\" timestamp=\"2025-12-02T20:40:24.023000+00:00\">REFÚGIO SC © Todos os direitos reservados.</discord-embed-footer></discord-embed><discord-attachments slot=\"components\"><discord-action-row><discord-button type=\"secondary\" emoji=\"https://cdnjs.cloudflare.com/ajax/libs/twemoji/14.0.2/svg/1f7e9.svg\">Sim</discord-button><discord-button type=\"secondary\" emoji=\"https://cdnjs.cloudflare.com/ajax/libs/twemoji/14.0.2/svg/1f7e5.svg\">Não</discord-button></discord-action-row></discord-attachments></discord-message><discord-message id=\"m-1445516508275933204\" timestamp=\"2025-12-02T20:46:31.971Z\" edited=\"true\" server=\"false\" highlight=\"false\" profile=\"1003801622247383180\"><discord-reply slot=\"reply\">Message could not be loaded.</discord-reply><discord-embed embed-title=\"⚙️ Ticket fechado\" slot=\"embeds\" color=\"#2f3136\"><discord-embed-description slot=\"description\">Ticket fechado em 02/12/2025, 17:46:34 por <discord-mention type=\"user\">Gui</discord-mention>!<br/>Este canal será deletado em 5 segundos.</discord-embed-description><discord-embed-fields slot=\"fields\"><discord-embed-field field-title=\"📦 **__Motivo do fechamento:__**\" inline=\"false\" inline-index=\"1\"><discord-code-block language=\"\" code=\"Resolvido\"></discord-code-block></discord-embed-field></discord-embed-fields><discord-embed-footer slot=\"footer\" footer-image=\"https://images-ext-1.discordapp.net/external/yLihPFx_FJKzd-UOjQ2RQepRLMFFzhNqekN8YKwk7N8/https/cdn.discordapp.com/avatars/1003801622247383180/a_24e84ba106cec0b4a5ed5cd3ac391f2c.gif\" timestamp=\"2025-12-02T20:46:34.353000+00:00\">REFÚGIO SC © Todos os direitos reservados.</discord-embed-footer></discord-embed></discord-message><div style=\"text-align:center;width:100%\">Refúgio SC - Ticket Transcript </div></discord-messages></body></html>'),
(8006,'<html><head><meta charSet=\"utf-8\"/><meta name=\"viewport\" content=\"width=device-width, initial-scale=1\"/><link rel=\"icon\" type=\"image/png\" href=\"https://cdn.discordapp.com/icons/491309213553917952/a_34648f7a1342a2a7343585d52d846f0b.gif?size=16\"/><title>💡┃ticket-8006</title><script>document.addEventListener(\"click\",t=>{let e=t.target;if(!e)return;let o=e?.getAttribute(\"data-goto\");if(o){let r=document.getElementById(`m-${o}`);r?(r.scrollIntoView({behavior:\"smooth\",block:\"center\"}),r.style.backgroundColor=\"rgba(148, 156, 247, 0.1)\",r.style.transition=\"background-color 0.5s ease\",setTimeout(()=>{r.style.backgroundColor=\"transparent\"},1e3)):console.warn(\"Message ${goto} not found.\")}});</script><script>window.$discordMessage={profiles:{\"1003801622247383180\":{\"author\":\"Refúgio\",\"avatar\":\"https://cdn.discordapp.com/avatars/1003801622247383180/a_24e84ba106cec0b4a5ed5cd3ac391f2c.gif?size=64\",\"roleColor\":\"#ffffff\",\"roleIcon\":\"https://cdn.discordapp.com/role-icons/927207618638925854/d6353d6117aff284e0a3816bc59d2336.webp\",\"roleName\":\"Turixta\",\"bot\":true,\"verified\":false},\"1409823748936437760\":{\"author\":\"021kauan\",\"avatar\":\"https://cdn.discordapp.com/embed/avatars/5.png\",\"roleColor\":\"#11806a\",\"roleIcon\":\"https://cdn.discordapp.com/role-icons/927207618638925854/d6353d6117aff284e0a3816bc59d2336.webp\",\"roleName\":\"Turixta\",\"bot\":false,\"verified\":false},\"680810186545561636\":{\"author\":\"Matue\",\"avatar\":\"https://cdn.discordapp.com/guilds/491309213553917952/users/680810186545561636/avatars/a11860b2ff3c540ffc2838a3c31ad314.webp?size=64\",\"roleColor\":\"#1f8b4c\",\"roleIcon\":\"https://cdn.discordapp.com/role-icons/927207587248758784/5963ab2d95704b8360e984fcced59083.webp\",\"roleName\":\"SERVIDOR・MODERADOR\",\"bot\":false,\"verified\":false}}}</script><script type=\"module\" src=\"https://cdn.jsdelivr.net/npm/@derockdev/discord-components-core@^3.6.1/dist/derockdev-discord-components-core/derockdev-discord-components-core.esm.js\"></script></head><body style=\"margin:0;min-height:100vh\"><discord-messages style=\"min-height:100vh\"><discord-header guild=\"Refúgio Roleplay 💚\" channel=\"💡┃ticket-8006\" icon=\"https://cdn.discordapp.com/icons/491309213553917952/a_34648f7a1342a2a7343585d52d846f0b.gif?size=128\">This is the start of #💡┃ticket-8006 channel.</discord-header><discord-message id=\"m-1445514541890011176\" timestamp=\"2025-12-02T20:38:43.148Z\" edited=\"false\" highlight=\"false\" profile=\"1003801622247383180\"><discord-mention type=\"user\">021kauan</discord-mention>, <discord-mention type=\"role\" color=\"#c27c0e\">SERVIDOR・EQUIPE</discord-mention><discord-embed embed-title=\"💡 Suporte\" slot=\"embeds\" color=\"#2f3136\"><discord-embed-description slot=\"description\">Olá, por favor especifique como podemos te ajudar para um atendimento assertivo.<br/><br/><discord-custom-emoji name=\"⚙️\" url=\"https://cdnjs.cloudflare.com/ajax/libs/twemoji/14.0.2/svg/2699.svg\" embed-emoji=\"true\"></discord-custom-emoji> <discord-underlined><discord-bold>Adicionar ou remover membros:</discord-bold></discord-underlined><br/>Use um dos botões de acordo com a ação que você deseja fazer.</discord-embed-description><discord-embed-footer slot=\"footer\" footer-image=\"https://images-ext-1.discordapp.net/external/yLihPFx_FJKzd-UOjQ2RQepRLMFFzhNqekN8YKwk7N8/https/cdn.discordapp.com/avatars/1003801622247383180/a_24e84ba106cec0b4a5ed5cd3ac391f2c.gif\" timestamp=\"2025-12-02T20:38:42.860000+00:00\">REFÚGIO SC © Todos os direitos reservados.</discord-embed-footer></discord-embed><discord-attachments slot=\"components\"><discord-action-row><discord-button type=\"primary\" emoji=\"https://cdnjs.cloudflare.com/ajax/libs/twemoji/14.0.2/svg/1f464.svg\">Adicionar</discord-button><discord-button type=\"destructive\" emoji=\"https://cdnjs.cloudflare.com/ajax/libs/twemoji/14.0.2/svg/1f6b7.svg\">Remover</discord-button><discord-button type=\"success\" emoji=\"https://cdnjs.cloudflare.com/ajax/libs/twemoji/14.0.2/svg/2705.svg\">Finalizar Ticket</discord-button></discord-action-row><discord-action-row><discord-button type=\"secondary\" emoji=\"https://cdnjs.cloudflare.com/ajax/libs/twemoji/14.0.2/svg/270f.svg\">Trocar nome do Canal</discord-button><discord-button type=\"secondary\" emoji=\"https://cdnjs.cloudflare.com/ajax/libs/twemoji/14.0.2/svg/2699.svg\">Trocar Categoria</discord-button><discord-button type=\"secondary\" emoji=\"https://cdnjs.cloudflare.com/ajax/libs/twemoji/14.0.2/svg/1f514.svg\">POKE</discord-button></discord-action-row></discord-attachments></discord-message><discord-system-message id=\"m-1445514543274004583\" type=\"pin\"><i style=\"color:#ffffff\">Refúgio</i> pinned <i data-goto=\"1445514541890011176\">a message</i> to this channel.</discord-system-message><discord-message id=\"m-1445514634634465421\" timestamp=\"2025-12-02T20:39:05.260Z\" edited=\"false\" highlight=\"false\" profile=\"1409823748936437760\">oi as outras abas tao fechadas aqui pra min</discord-message><discord-message id=\"m-1445514649696207049\" timestamp=\"2025-12-02T20:39:08.851Z\" edited=\"false\" highlight=\"false\" profile=\"1409823748936437760\">do refugio</discord-message><discord-message id=\"m-1445514739395330098\" timestamp=\"2025-12-02T20:39:30.237Z\" edited=\"false\" highlight=\"false\" profile=\"680810186545561636\">Boa tarde</discord-message><discord-message id=\"m-1445514741115256953\" timestamp=\"2025-12-02T20:39:30.647Z\" edited=\"false\" highlight=\"false\" profile=\"1003801622247383180\"><discord-embed embed-title=\"Ticket assumido\" slot=\"embeds\" color=\"#2f3136\"><discord-embed-description slot=\"description\">O ticket foi assumido pelo staff <discord-mention type=\"user\">Gui</discord-mention></discord-embed-description><discord-embed-footer slot=\"footer\" footer-image=\"https://images-ext-1.discordapp.net/external/yLihPFx_FJKzd-UOjQ2RQepRLMFFzhNqekN8YKwk7N8/https/cdn.discordapp.com/avatars/1003801622247383180/a_24e84ba106cec0b4a5ed5cd3ac391f2c.gif\" timestamp=\"2025-12-02T20:39:30.337000+00:00\">REFÚGIO SC © Todos os direitos reservados.</discord-embed-footer></discord-embed></discord-message><discord-message id=\"m-1445514766436143124\" timestamp=\"2025-12-02T20:39:36.684Z\" edited=\"false\" highlight=\"false\" profile=\"680810186545561636\">Quais abas?</discord-message><discord-message id=\"m-1445515058984779807\" timestamp=\"2025-12-02T20:40:46.433Z\" edited=\"false\" server=\"false\" highlight=\"false\" profile=\"680810186545561636\"><discord-reply slot=\"reply\" edited=\"false\" attachment=\"false\" author=\"021kauan\" role-color=\"#11806a\" bot=\"false\" verified=\"false\" op=\"false\" command=\"false\"><span data-goto=\"1445514634634465421\">oi as outras abas tao fechadas aqui pra min</span></discord-reply>A nova season ainda não foi anunciada, com isso as salas estão fechadas temporariamente para todos</discord-message><discord-message id=\"m-1445515184126038076\" timestamp=\"2025-12-02T20:41:16.269Z\" edited=\"false\" highlight=\"false\" profile=\"1409823748936437760\">ah pensei que era so pra min kkkk</discord-message><discord-message id=\"m-1445515342146441266\" timestamp=\"2025-12-02T20:41:53.944Z\" edited=\"false\" highlight=\"false\" profile=\"1409823748936437760\">e quando volts vcs tem uma data</discord-message><discord-message id=\"m-1445515922868670605\" timestamp=\"2025-12-02T20:44:12.399Z\" edited=\"false\" highlight=\"false\" profile=\"680810186545561636\">Você pode ir acompanhando aqui <discord-mention type=\"channel\">💫・anúncios</discord-mention> no tiktok</discord-message><discord-message id=\"m-1445516913378725900\" timestamp=\"2025-12-02T20:48:08.555Z\" edited=\"false\" highlight=\"false\" profile=\"1409823748936437760\">ta bom</discord-message><discord-message id=\"m-1445518117685166304\" timestamp=\"2025-12-02T20:52:55.684Z\" edited=\"true\" server=\"false\" highlight=\"false\" profile=\"1003801622247383180\"><discord-reply slot=\"reply\">Message could not be loaded.</discord-reply><discord-embed embed-title=\"⚙️ Ticket fechado\" slot=\"embeds\" color=\"#2f3136\"><discord-embed-description slot=\"description\">Ticket fechado em 02/12/2025, 17:52:57 por <discord-mention type=\"user\">Gui</discord-mention>!<br/>Este canal será deletado em 5 segundos.</discord-embed-description><discord-embed-fields slot=\"fields\"><discord-embed-field field-title=\"📦 **__Motivo do fechamento:__**\" inline=\"false\" inline-index=\"1\"><discord-code-block language=\"\" code=\"Resolvido\"></discord-code-block></discord-embed-field></discord-embed-fields><discord-embed-footer slot=\"footer\" footer-image=\"https://images-ext-1.discordapp.net/external/yLihPFx_FJKzd-UOjQ2RQepRLMFFzhNqekN8YKwk7N8/https/cdn.discordapp.com/avatars/1003801622247383180/a_24e84ba106cec0b4a5ed5cd3ac391f2c.gif\" timestamp=\"2025-12-02T20:52:57.942000+00:00\">REFÚGIO SC © Todos os direitos reservados.</discord-embed-footer></discord-embed></discord-message><div style=\"text-align:center;width:100%\">Refúgio SC - Ticket Transcript </div></discord-messages></body></html>'),
(8009,'<html><head><meta charSet=\"utf-8\"/><meta name=\"viewport\" content=\"width=device-width, initial-scale=1\"/><link rel=\"icon\" type=\"image/png\" href=\"https://cdn.discordapp.com/icons/491309213553917952/a_34648f7a1342a2a7343585d52d846f0b.gif?size=16\"/><title>💡┃ticket-8009</title><script>document.addEventListener(\"click\",t=>{let e=t.target;if(!e)return;let o=e?.getAttribute(\"data-goto\");if(o){let r=document.getElementById(`m-${o}`);r?(r.scrollIntoView({behavior:\"smooth\",block:\"center\"}),r.style.backgroundColor=\"rgba(148, 156, 247, 0.1)\",r.style.transition=\"background-color 0.5s ease\",setTimeout(()=>{r.style.backgroundColor=\"transparent\"},1e3)):console.warn(\"Message ${goto} not found.\")}});</script><script>window.$discordMessage={profiles:{\"1003801622247383180\":{\"author\":\"Refúgio\",\"avatar\":\"https://cdn.discordapp.com/avatars/1003801622247383180/a_24e84ba106cec0b4a5ed5cd3ac391f2c.gif?size=64\",\"roleColor\":\"#ffffff\",\"roleIcon\":\"https://cdn.discordapp.com/role-icons/927207618638925854/d6353d6117aff284e0a3816bc59d2336.webp\",\"roleName\":\"Turixta\",\"bot\":true,\"verified\":false},\"735724009056108566\":{\"author\":\"[🐻] Ezaki\",\"avatar\":\"https://cdn.discordapp.com/guilds/491309213553917952/users/735724009056108566/avatars/3ae6a952ee87fc3d91d36af9d2460d26.webp?size=64\",\"roleColor\":\"#1f8b4c\",\"roleIcon\":\"https://cdn.discordapp.com/role-icons/927207587248758784/5963ab2d95704b8360e984fcced59083.webp\",\"roleName\":\"SERVIDOR・MODERADOR\",\"bot\":false,\"verified\":false},\"1442213571416293406\":{\"author\":\"💀𝑵𝑨𝑺𝑪𝑰𝑴𝑬𝑵𝑻𝑶🥷🏻\",\"avatar\":\"https://cdn.discordapp.com/avatars/1442213571416293406/d51919eebd7b458b1092aa4c6f432b65.webp?size=64\",\"bot\":false,\"verified\":false}}}</script><script type=\"module\" src=\"https://cdn.jsdelivr.net/npm/@derockdev/discord-components-core@^3.6.1/dist/derockdev-discord-components-core/derockdev-discord-components-core.esm.js\"></script></head><body style=\"margin:0;min-height:100vh\"><discord-messages style=\"min-height:100vh\"><discord-header guild=\"Refúgio Roleplay 💚\" channel=\"💡┃ticket-8009\" icon=\"https://cdn.discordapp.com/icons/491309213553917952/a_34648f7a1342a2a7343585d52d846f0b.gif?size=128\">This is the start of #💡┃ticket-8009 channel.</discord-header><discord-message id=\"m-1445943283724451932\" timestamp=\"2025-12-04T01:02:23.167Z\" edited=\"false\" highlight=\"false\" profile=\"1003801622247383180\"><discord-mention type=\"user\">💀𝑵𝑨𝑺𝑪𝑰𝑴𝑬𝑵𝑻𝑶🥷🏻</discord-mention>, <discord-mention type=\"role\" color=\"#c27c0e\">SERVIDOR・EQUIPE</discord-mention><discord-embed embed-title=\"💡 Suporte\" slot=\"embeds\" color=\"#2f3136\" thumbnail=\"https://images-ext-1.discordapp.net/external/8JAz9tK7KFnyWZ5OU5irMJC4b2dBqijRGBwy51x27No/https/cdn.discordapp.com/avatars/1442213571416293406/d51919eebd7b458b1092aa4c6f432b65.webp\"><discord-embed-description slot=\"description\">Olá, por favor especifique como podemos te ajudar para um atendimento assertivo.<br/><br/><discord-custom-emoji name=\"⚙️\" url=\"https://cdnjs.cloudflare.com/ajax/libs/twemoji/14.0.2/svg/2699.svg\" embed-emoji=\"true\"></discord-custom-emoji> <discord-underlined><discord-bold>Adicionar ou remover membros:</discord-bold></discord-underlined><br/>Use um dos botões de acordo com a ação que você deseja fazer.</discord-embed-description><discord-embed-footer slot=\"footer\" footer-image=\"https://images-ext-1.discordapp.net/external/yLihPFx_FJKzd-UOjQ2RQepRLMFFzhNqekN8YKwk7N8/https/cdn.discordapp.com/avatars/1003801622247383180/a_24e84ba106cec0b4a5ed5cd3ac391f2c.gif\" timestamp=\"2025-12-04T01:02:22.820000+00:00\">REFÚGIO SC © Todos os direitos reservados.</discord-embed-footer></discord-embed><discord-attachments slot=\"components\"><discord-action-row><discord-button type=\"primary\" emoji=\"https://cdnjs.cloudflare.com/ajax/libs/twemoji/14.0.2/svg/1f464.svg\">Adicionar</discord-button><discord-button type=\"destructive\" emoji=\"https://cdnjs.cloudflare.com/ajax/libs/twemoji/14.0.2/svg/1f6b7.svg\">Remover</discord-button><discord-button type=\"success\" emoji=\"https://cdnjs.cloudflare.com/ajax/libs/twemoji/14.0.2/svg/2705.svg\">Finalizar Ticket</discord-button></discord-action-row><discord-action-row><discord-button type=\"secondary\" emoji=\"https://cdnjs.cloudflare.com/ajax/libs/twemoji/14.0.2/svg/270f.svg\">Trocar nome do Canal</discord-button><discord-button type=\"secondary\" emoji=\"https://cdnjs.cloudflare.com/ajax/libs/twemoji/14.0.2/svg/2699.svg\">Trocar Categoria</discord-button><discord-button type=\"secondary\" emoji=\"https://cdnjs.cloudflare.com/ajax/libs/twemoji/14.0.2/svg/1f514.svg\">POKE</discord-button></discord-action-row></discord-attachments></discord-message><discord-system-message id=\"m-1445943285570080862\" type=\"pin\"><i style=\"color:#ffffff\">Refúgio</i> pinned <i data-goto=\"1445943283724451932\">a message</i> to this channel.</discord-system-message><discord-message id=\"m-1445943657734864988\" timestamp=\"2025-12-04T01:03:52.338Z\" edited=\"false\" highlight=\"false\" profile=\"735724009056108566\">Boa noite</discord-message><discord-message id=\"m-1445943671781462078\" timestamp=\"2025-12-04T01:03:55.687Z\" edited=\"false\" highlight=\"false\" profile=\"1003801622247383180\"><discord-embed embed-title=\"Ticket assumido\" slot=\"embeds\" color=\"#2f3136\"><discord-embed-description slot=\"description\">O ticket foi assumido pelo staff <discord-mention type=\"user\">Ez</discord-mention></discord-embed-description><discord-embed-footer slot=\"footer\" footer-image=\"https://images-ext-1.discordapp.net/external/yLihPFx_FJKzd-UOjQ2RQepRLMFFzhNqekN8YKwk7N8/https/cdn.discordapp.com/avatars/1003801622247383180/a_24e84ba106cec0b4a5ed5cd3ac391f2c.gif\" timestamp=\"2025-12-04T01:03:52.438000+00:00\">REFÚGIO SC © Todos os direitos reservados.</discord-embed-footer></discord-embed></discord-message><discord-message id=\"m-1445943696448032838\" timestamp=\"2025-12-04T01:04:01.568Z\" edited=\"false\" highlight=\"false\" profile=\"735724009056108566\">Como podemos ajudar?</discord-message><discord-message id=\"m-1445943706250248293\" timestamp=\"2025-12-04T01:04:03.905Z\" edited=\"false\" highlight=\"false\" profile=\"1442213571416293406\">Boa noite meu querido certin?</discord-message><discord-message id=\"m-1445943806024224930\" timestamp=\"2025-12-04T01:04:27.693Z\" edited=\"false\" highlight=\"false\" profile=\"1442213571416293406\">Então, queria saber se RP Está aberto irei iniciar meu GTA.</discord-message><discord-message id=\"m-1445943847954940045\" timestamp=\"2025-12-04T01:04:37.690Z\" edited=\"false\" highlight=\"false\" profile=\"1442213571416293406\">Cidade.</discord-message><discord-message id=\"m-1445943905181892789\" timestamp=\"2025-12-04T01:04:51.334Z\" edited=\"false\" highlight=\"false\" profile=\"735724009056108566\">No momento a cidade ainda não abriu</discord-message><discord-message id=\"m-1445943928992829585\" timestamp=\"2025-12-04T01:04:57.011Z\" edited=\"false\" highlight=\"false\" profile=\"1442213571416293406\">Hmm sim</discord-message><discord-message id=\"m-1445944011977261149\" timestamp=\"2025-12-04T01:05:16.796Z\" edited=\"false\" highlight=\"false\" profile=\"735724009056108566\">logo vamos avisar a data de lançamento</discord-message><discord-message id=\"m-1445944063311351941\" timestamp=\"2025-12-04T01:05:29.035Z\" edited=\"false\" highlight=\"false\" profile=\"1442213571416293406\">Ok, muito obrigado !</discord-message><discord-message id=\"m-1445944429256118363\" timestamp=\"2025-12-04T01:06:56.283Z\" edited=\"false\" highlight=\"false\" profile=\"735724009056108566\">Ajudo em algo mais?</discord-message><discord-message id=\"m-1445944547371647057\" timestamp=\"2025-12-04T01:07:24.444Z\" edited=\"false\" highlight=\"false\" profile=\"1442213571416293406\">Doutor, senhor sabe se tem mas alguma cidade de SC?</discord-message><discord-message id=\"m-1445945804006228119\" timestamp=\"2025-12-04T01:12:24.049Z\" edited=\"false\" highlight=\"false\" profile=\"1442213571416293406\"><discord-mention type=\"user\">Ez</discord-mention></discord-message><discord-message id=\"m-1445945934897877042\" timestamp=\"2025-12-04T01:12:55.256Z\" edited=\"false\" highlight=\"false\" profile=\"735724009056108566\">Só aguardar</discord-message><discord-message id=\"m-1445946001985900716\" timestamp=\"2025-12-04T01:13:11.251Z\" edited=\"false\" highlight=\"false\" profile=\"735724009056108566\">Em breve vamos estar abrindo para todos aproveitar</discord-message><discord-message id=\"m-1445946181296459897\" timestamp=\"2025-12-04T01:13:54.002Z\" edited=\"false\" highlight=\"false\" profile=\"1442213571416293406\">Ok obrigado só isso msm</discord-message><discord-message id=\"m-1445946815144005743\" timestamp=\"2025-12-04T01:16:25.123Z\" edited=\"false\" highlight=\"false\" profile=\"735724009056108566\">Disponha</discord-message><discord-message id=\"m-1445968304207302757\" timestamp=\"2025-12-04T02:41:48.515Z\" edited=\"true\" server=\"false\" highlight=\"false\" profile=\"1003801622247383180\"><discord-reply slot=\"reply\">Message could not be loaded.</discord-reply><discord-embed embed-title=\"⚙️ Ticket fechado\" slot=\"embeds\" color=\"#2f3136\"><discord-embed-description slot=\"description\">Ticket fechado em 03/12/2025, 23:41:52 por <discord-mention type=\"user\">Jade</discord-mention>!<br/>Este canal será deletado em 5 segundos.</discord-embed-description><discord-embed-fields slot=\"fields\"><discord-embed-field field-title=\"📦 **__Motivo do fechamento:__**\" inline=\"false\" inline-index=\"1\"><discord-code-block language=\"\" code=\"resolvido\"></discord-code-block></discord-embed-field></discord-embed-fields><discord-embed-footer slot=\"footer\" footer-image=\"https://images-ext-1.discordapp.net/external/yLihPFx_FJKzd-UOjQ2RQepRLMFFzhNqekN8YKwk7N8/https/cdn.discordapp.com/avatars/1003801622247383180/a_24e84ba106cec0b4a5ed5cd3ac391f2c.gif\" timestamp=\"2025-12-04T02:41:52.484000+00:00\">REFÚGIO SC © Todos os direitos reservados.</discord-embed-footer></discord-embed></discord-message><discord-message id=\"m-1445968321873707088\" timestamp=\"2025-12-04T02:41:52.727Z\" edited=\"false\" highlight=\"false\" profile=\"1003801622247383180\">Vejo que nosso staffer <discord-mention type=\"user\">Jade</discord-mention> veio te ajudar agora. Vou deixar vocês à vontade, e desejo um ótimo atendimento! <discord-custom-emoji name=\"😊\" url=\"https://cdnjs.cloudflare.com/ajax/libs/twemoji/14.0.2/svg/1f60a.svg\" embed-emoji=\"false\"></discord-custom-emoji></discord-message><div style=\"text-align:center;width:100%\">Refúgio SC - Ticket Transcript </div></discord-messages></body></html>'),
(8010,'<html><head><meta charSet=\"utf-8\"/><meta name=\"viewport\" content=\"width=device-width, initial-scale=1\"/><link rel=\"icon\" type=\"image/png\" href=\"https://cdn.discordapp.com/icons/491309213553917952/a_34648f7a1342a2a7343585d52d846f0b.gif?size=16\"/><title>💡┃ticket-8010</title><script>document.addEventListener(\"click\",t=>{let e=t.target;if(!e)return;let o=e?.getAttribute(\"data-goto\");if(o){let r=document.getElementById(`m-${o}`);r?(r.scrollIntoView({behavior:\"smooth\",block:\"center\"}),r.style.backgroundColor=\"rgba(148, 156, 247, 0.1)\",r.style.transition=\"background-color 0.5s ease\",setTimeout(()=>{r.style.backgroundColor=\"transparent\"},1e3)):console.warn(\"Message ${goto} not found.\")}});</script><script>window.$discordMessage={profiles:{\"1003801622247383180\":{\"author\":\"Refúgio\",\"avatar\":\"https://cdn.discordapp.com/avatars/1003801622247383180/a_24e84ba106cec0b4a5ed5cd3ac391f2c.gif?size=64\",\"roleColor\":\"#ffffff\",\"roleIcon\":\"https://cdn.discordapp.com/role-icons/927207618638925854/d6353d6117aff284e0a3816bc59d2336.webp\",\"roleName\":\"Turixta\",\"bot\":true,\"verified\":false},\"659918884844994603\":{\"author\":\"! [🐴] Raphael\",\"avatar\":\"https://cdn.discordapp.com/avatars/659918884844994603/49360667c1046f39e89d5c0b4051cba3.webp?size=64\",\"roleColor\":\"#d4843d\",\"roleIcon\":\"https://cdn.discordapp.com/role-icons/927207621100969985/0bd4ba363baf51ba0164a27447535dcc.webp\",\"roleName\":\"SERVIDOR・CEO\",\"bot\":false,\"verified\":false},\"798657333609103431\":{\"author\":\"V G\",\"avatar\":\"https://cdn.discordapp.com/avatars/798657333609103431/59ad9e4d31b0fd958e6587b6f1519a0e.webp?size=64\",\"bot\":false,\"verified\":false}}}</script><script type=\"module\" src=\"https://cdn.jsdelivr.net/npm/@derockdev/discord-components-core@^3.6.1/dist/derockdev-discord-components-core/derockdev-discord-components-core.esm.js\"></script></head><body style=\"margin:0;min-height:100vh\"><discord-messages style=\"min-height:100vh\"><discord-header guild=\"Refúgio Roleplay 💚\" channel=\"💡┃ticket-8010\" icon=\"https://cdn.discordapp.com/icons/491309213553917952/a_34648f7a1342a2a7343585d52d846f0b.gif?size=128\">This is the start of #💡┃ticket-8010 channel.</discord-header><discord-message id=\"m-1445949506771222568\" timestamp=\"2025-12-04T01:27:06.857Z\" edited=\"false\" highlight=\"false\" profile=\"1003801622247383180\"><discord-mention type=\"user\">Raphael</discord-mention>, <discord-mention type=\"role\" color=\"#c27c0e\">SERVIDOR・EQUIPE</discord-mention><discord-embed embed-title=\"💡 Suporte\" slot=\"embeds\" color=\"#2f3136\" thumbnail=\"https://images-ext-1.discordapp.net/external/CFQUWh3OFbooo6w2umYijPYfljMAVvWUBjNURJZG36s/https/cdn.discordapp.com/avatars/659918884844994603/49360667c1046f39e89d5c0b4051cba3.webp\"><discord-embed-description slot=\"description\">Olá, por favor especifique como podemos te ajudar para um atendimento assertivo.<br/><br/><discord-custom-emoji name=\"⚙️\" url=\"https://cdnjs.cloudflare.com/ajax/libs/twemoji/14.0.2/svg/2699.svg\" embed-emoji=\"true\"></discord-custom-emoji> <discord-underlined><discord-bold>Adicionar ou remover membros:</discord-bold></discord-underlined><br/>Use um dos botões de acordo com a ação que você deseja fazer.</discord-embed-description><discord-embed-footer slot=\"footer\" footer-image=\"https://images-ext-1.discordapp.net/external/yLihPFx_FJKzd-UOjQ2RQepRLMFFzhNqekN8YKwk7N8/https/cdn.discordapp.com/avatars/1003801622247383180/a_24e84ba106cec0b4a5ed5cd3ac391f2c.gif\" timestamp=\"2025-12-04T01:27:06.335000+00:00\">REFÚGIO SC © Todos os direitos reservados.</discord-embed-footer></discord-embed><discord-attachments slot=\"components\"><discord-action-row><discord-button type=\"primary\" emoji=\"https://cdnjs.cloudflare.com/ajax/libs/twemoji/14.0.2/svg/1f464.svg\">Adicionar</discord-button><discord-button type=\"destructive\" emoji=\"https://cdnjs.cloudflare.com/ajax/libs/twemoji/14.0.2/svg/1f6b7.svg\">Remover</discord-button><discord-button type=\"success\" emoji=\"https://cdnjs.cloudflare.com/ajax/libs/twemoji/14.0.2/svg/2705.svg\">Finalizar Ticket</discord-button></discord-action-row><discord-action-row><discord-button type=\"secondary\" emoji=\"https://cdnjs.cloudflare.com/ajax/libs/twemoji/14.0.2/svg/270f.svg\">Trocar nome do Canal</discord-button><discord-button type=\"secondary\" emoji=\"https://cdnjs.cloudflare.com/ajax/libs/twemoji/14.0.2/svg/2699.svg\">Trocar Categoria</discord-button><discord-button type=\"secondary\" emoji=\"https://cdnjs.cloudflare.com/ajax/libs/twemoji/14.0.2/svg/1f514.svg\">POKE</discord-button></discord-action-row></discord-attachments></discord-message><discord-system-message id=\"m-1445949508163993660\" type=\"pin\"><i style=\"color:#ffffff\">Refúgio</i> pinned <i data-goto=\"1445949506771222568\">a message</i> to this channel.</discord-system-message><discord-message id=\"m-1445949517068369981\" timestamp=\"2025-12-04T01:27:09.312Z\" edited=\"true\" highlight=\"false\" profile=\"659918884844994603\">teste</discord-message><discord-message id=\"m-1445949599402688586\" timestamp=\"2025-12-04T01:27:28.942Z\" edited=\"false\" highlight=\"false\" profile=\"798657333609103431\">banido</discord-message><discord-message id=\"m-1445949601080152155\" timestamp=\"2025-12-04T01:27:29.342Z\" edited=\"false\" highlight=\"false\" profile=\"1003801622247383180\"><discord-embed embed-title=\"Ticket assumido\" slot=\"embeds\" color=\"#2f3136\"><discord-embed-description slot=\"description\">O ticket foi assumido pelo staff <discord-mention type=\"user\">V G</discord-mention></discord-embed-description><discord-embed-footer slot=\"footer\" footer-image=\"https://images-ext-1.discordapp.net/external/yLihPFx_FJKzd-UOjQ2RQepRLMFFzhNqekN8YKwk7N8/https/cdn.discordapp.com/avatars/1003801622247383180/a_24e84ba106cec0b4a5ed5cd3ac391f2c.gif\" timestamp=\"2025-12-04T01:27:29.121000+00:00\">REFÚGIO SC © Todos os direitos reservados.</discord-embed-footer></discord-embed></discord-message><discord-message id=\"m-1445949907616665600\" timestamp=\"2025-12-04T01:28:42.426Z\" edited=\"true\" server=\"false\" highlight=\"false\" profile=\"1003801622247383180\"><discord-reply slot=\"reply\">Message could not be loaded.</discord-reply><discord-embed embed-title=\"⚙️ Ticket fechado\" slot=\"embeds\" color=\"#2f3136\"><discord-embed-description slot=\"description\">Ticket fechado em 03/12/2025, 22:28:46 por <discord-mention type=\"user\">Raphael</discord-mention>!<br/>Este canal será deletado em 5 segundos.</discord-embed-description><discord-embed-fields slot=\"fields\"><discord-embed-field field-title=\"📦 **__Motivo do fechamento:__**\" inline=\"false\" inline-index=\"1\"><discord-code-block language=\"\" code=\"t\"></discord-code-block></discord-embed-field></discord-embed-fields><discord-embed-footer slot=\"footer\" footer-image=\"https://images-ext-1.discordapp.net/external/yLihPFx_FJKzd-UOjQ2RQepRLMFFzhNqekN8YKwk7N8/https/cdn.discordapp.com/avatars/1003801622247383180/a_24e84ba106cec0b4a5ed5cd3ac391f2c.gif\" timestamp=\"2025-12-04T01:28:46.415000+00:00\">REFÚGIO SC © Todos os direitos reservados.</discord-embed-footer></discord-embed></discord-message><div style=\"text-align:center;width:100%\">Refúgio SC - Ticket Transcript </div></discord-messages></body></html>'),
(8011,'<html><head><meta charSet=\"utf-8\"/><meta name=\"viewport\" content=\"width=device-width, initial-scale=1\"/><link rel=\"icon\" type=\"image/png\" href=\"https://cdn.discordapp.com/icons/491309213553917952/a_34648f7a1342a2a7343585d52d846f0b.gif?size=16\"/><title>🐛┃ticket-8011</title><script>document.addEventListener(\"click\",t=>{let e=t.target;if(!e)return;let o=e?.getAttribute(\"data-goto\");if(o){let r=document.getElementById(`m-${o}`);r?(r.scrollIntoView({behavior:\"smooth\",block:\"center\"}),r.style.backgroundColor=\"rgba(148, 156, 247, 0.1)\",r.style.transition=\"background-color 0.5s ease\",setTimeout(()=>{r.style.backgroundColor=\"transparent\"},1e3)):console.warn(\"Message ${goto} not found.\")}});</script><script>window.$discordMessage={profiles:{\"1003801622247383180\":{\"author\":\"Refúgio\",\"avatar\":\"https://cdn.discordapp.com/avatars/1003801622247383180/a_24e84ba106cec0b4a5ed5cd3ac391f2c.gif?size=64\",\"roleColor\":\"#ffffff\",\"roleIcon\":\"https://cdn.discordapp.com/role-icons/927207618638925854/d6353d6117aff284e0a3816bc59d2336.webp\",\"roleName\":\"Turixta\",\"bot\":true,\"verified\":false},\"659918884844994603\":{\"author\":\"! [🐴] Raphael\",\"avatar\":\"https://cdn.discordapp.com/avatars/659918884844994603/49360667c1046f39e89d5c0b4051cba3.webp?size=64\",\"roleColor\":\"#d4843d\",\"roleIcon\":\"https://cdn.discordapp.com/role-icons/927207621100969985/0bd4ba363baf51ba0164a27447535dcc.webp\",\"roleName\":\"SERVIDOR・CEO\",\"bot\":false,\"verified\":false},\"400712876056117248\":{\"author\":\"[🦝] Flashh\",\"avatar\":\"https://cdn.discordapp.com/avatars/400712876056117248/3765f35466140a0ca1cceff6e28c338a.webp?size=64\",\"roleColor\":\"#a10b7b\",\"roleIcon\":\"https://cdn.discordapp.com/role-icons/927207621100969985/0bd4ba363baf51ba0164a27447535dcc.webp\",\"roleName\":\"SERVIDOR・CEO\",\"bot\":false,\"verified\":false}}}</script><script type=\"module\" src=\"https://cdn.jsdelivr.net/npm/@derockdev/discord-components-core@^3.6.1/dist/derockdev-discord-components-core/derockdev-discord-components-core.esm.js\"></script></head><body style=\"margin:0;min-height:100vh\"><discord-messages style=\"min-height:100vh\"><discord-header guild=\"Refúgio Roleplay 💚\" channel=\"🐛┃ticket-8011\" icon=\"https://cdn.discordapp.com/icons/491309213553917952/a_34648f7a1342a2a7343585d52d846f0b.gif?size=128\">This is the start of #🐛┃ticket-8011 channel.</discord-header><discord-message id=\"m-1445949989330223205\" timestamp=\"2025-12-04T01:29:01.908Z\" edited=\"false\" highlight=\"false\" profile=\"1003801622247383180\"><discord-mention type=\"user\">Raphael</discord-mention>, <discord-mention type=\"role\" color=\"#c27c0e\">SERVIDOR・EQUIPE</discord-mention><discord-embed embed-title=\"🐛 Bug\" slot=\"embeds\" color=\"#2f3136\" thumbnail=\"https://images-ext-1.discordapp.net/external/CFQUWh3OFbooo6w2umYijPYfljMAVvWUBjNURJZG36s/https/cdn.discordapp.com/avatars/659918884844994603/49360667c1046f39e89d5c0b4051cba3.webp\"><discord-embed-description slot=\"description\">Detalhe o bug/glitch encontrado e o local e/ou momentos em que tal problema ocorre para que possamos analisar e entender com facilidade.<br/><br/><discord-custom-emoji name=\"⚙️\" url=\"https://cdnjs.cloudflare.com/ajax/libs/twemoji/14.0.2/svg/2699.svg\" embed-emoji=\"true\"></discord-custom-emoji> <discord-underlined><discord-bold>Adicionar ou remover membros:</discord-bold></discord-underlined><br/>Use um dos botões de acordo com a ação que você deseja fazer.</discord-embed-description><discord-embed-footer slot=\"footer\" footer-image=\"https://images-ext-1.discordapp.net/external/yLihPFx_FJKzd-UOjQ2RQepRLMFFzhNqekN8YKwk7N8/https/cdn.discordapp.com/avatars/1003801622247383180/a_24e84ba106cec0b4a5ed5cd3ac391f2c.gif\" timestamp=\"2025-12-04T01:29:01.612000+00:00\">REFÚGIO SC © Todos os direitos reservados.</discord-embed-footer></discord-embed><discord-attachments slot=\"components\"><discord-action-row><discord-button type=\"primary\" emoji=\"https://cdnjs.cloudflare.com/ajax/libs/twemoji/14.0.2/svg/1f464.svg\">Adicionar</discord-button><discord-button type=\"destructive\" emoji=\"https://cdnjs.cloudflare.com/ajax/libs/twemoji/14.0.2/svg/1f6b7.svg\">Remover</discord-button><discord-button type=\"success\" emoji=\"https://cdnjs.cloudflare.com/ajax/libs/twemoji/14.0.2/svg/2705.svg\">Finalizar Ticket</discord-button></discord-action-row><discord-action-row><discord-button type=\"secondary\" emoji=\"https://cdnjs.cloudflare.com/ajax/libs/twemoji/14.0.2/svg/270f.svg\">Trocar nome do Canal</discord-button><discord-button type=\"secondary\" emoji=\"https://cdnjs.cloudflare.com/ajax/libs/twemoji/14.0.2/svg/2699.svg\">Trocar Categoria</discord-button><discord-button type=\"secondary\" emoji=\"https://cdnjs.cloudflare.com/ajax/libs/twemoji/14.0.2/svg/1f514.svg\">POKE</discord-button></discord-action-row></discord-attachments></discord-message><discord-system-message id=\"m-1445949990966001664\" type=\"pin\"><i style=\"color:#ffffff\">Refúgio</i> pinned <i data-goto=\"1445949989330223205\">a message</i> to this channel.</discord-system-message><discord-message id=\"m-1445950003754438686\" timestamp=\"2025-12-04T01:29:05.347Z\" edited=\"false\" highlight=\"false\" profile=\"659918884844994603\">oi</discord-message><discord-message id=\"m-1445950009207029923\" timestamp=\"2025-12-04T01:29:06.647Z\" edited=\"false\" highlight=\"false\" profile=\"659918884844994603\">teste</discord-message><discord-message id=\"m-1445950251704782918\" timestamp=\"2025-12-04T01:30:04.463Z\" edited=\"true\" server=\"false\" highlight=\"false\" profile=\"1003801622247383180\"><discord-reply slot=\"reply\">Message could not be loaded.</discord-reply><discord-embed embed-title=\"⚙️ Ticket fechado\" slot=\"embeds\" color=\"#2f3136\"><discord-embed-description slot=\"description\">Ticket fechado em 03/12/2025, 22:30:07 por <discord-mention type=\"user\">Raphael</discord-mention>!<br/>Este canal será deletado em 5 segundos.</discord-embed-description><discord-embed-fields slot=\"fields\"><discord-embed-field field-title=\"📦 **__Motivo do fechamento:__**\" inline=\"false\" inline-index=\"1\"><discord-code-block language=\"\" code=\"t\"></discord-code-block></discord-embed-field></discord-embed-fields><discord-embed-footer slot=\"footer\" footer-image=\"https://images-ext-1.discordapp.net/external/yLihPFx_FJKzd-UOjQ2RQepRLMFFzhNqekN8YKwk7N8/https/cdn.discordapp.com/avatars/1003801622247383180/a_24e84ba106cec0b4a5ed5cd3ac391f2c.gif\" timestamp=\"2025-12-04T01:30:07.493000+00:00\">REFÚGIO SC © Todos os direitos reservados.</discord-embed-footer></discord-embed></discord-message><discord-message id=\"m-1445950256423637104\" timestamp=\"2025-12-04T01:30:05.588Z\" edited=\"false\" highlight=\"false\" profile=\"400712876056117248\">nao</discord-message><discord-message id=\"m-1445950257983655956\" timestamp=\"2025-12-04T01:30:05.960Z\" edited=\"false\" highlight=\"false\" profile=\"1003801622247383180\"><discord-embed embed-title=\"Ticket assumido\" slot=\"embeds\" color=\"#2f3136\"><discord-embed-description slot=\"description\">O ticket foi assumido pelo staff <discord-mention type=\"user\">zsGabriel</discord-mention></discord-embed-description><discord-embed-footer slot=\"footer\" footer-image=\"https://images-ext-1.discordapp.net/external/yLihPFx_FJKzd-UOjQ2RQepRLMFFzhNqekN8YKwk7N8/https/cdn.discordapp.com/avatars/1003801622247383180/a_24e84ba106cec0b4a5ed5cd3ac391f2c.gif\" timestamp=\"2025-12-04T01:30:05.779000+00:00\">REFÚGIO SC © Todos os direitos reservados.</discord-embed-footer></discord-embed></discord-message><div style=\"text-align:center;width:100%\">Refúgio SC - Ticket Transcript </div></discord-messages></body></html>'),
(8013,'<html><head><meta charSet=\"utf-8\"/><meta name=\"viewport\" content=\"width=device-width, initial-scale=1\"/><link rel=\"icon\" type=\"image/png\" href=\"https://cdn.discordapp.com/icons/491309213553917952/a_34648f7a1342a2a7343585d52d846f0b.gif?size=16\"/><title>🪙┃ticket-8013</title><script>document.addEventListener(\"click\",t=>{let e=t.target;if(!e)return;let o=e?.getAttribute(\"data-goto\");if(o){let r=document.getElementById(`m-${o}`);r?(r.scrollIntoView({behavior:\"smooth\",block:\"center\"}),r.style.backgroundColor=\"rgba(148, 156, 247, 0.1)\",r.style.transition=\"background-color 0.5s ease\",setTimeout(()=>{r.style.backgroundColor=\"transparent\"},1e3)):console.warn(\"Message ${goto} not found.\")}});</script><script>window.$discordMessage={profiles:{\"1003801622247383180\":{\"author\":\"Refúgio\",\"avatar\":\"https://cdn.discordapp.com/avatars/1003801622247383180/a_24e84ba106cec0b4a5ed5cd3ac391f2c.gif?size=64\",\"roleColor\":\"#ffffff\",\"roleIcon\":\"https://cdn.discordapp.com/role-icons/927207618638925854/d6353d6117aff284e0a3816bc59d2336.webp\",\"roleName\":\"Turixta\",\"bot\":true,\"verified\":false},\"1372678821324652616\":{\"author\":\"Pedro Dybala\",\"avatar\":\"https://cdn.discordapp.com/avatars/1372678821324652616/4031fba9909cb1f95f137bb50eda6f34.webp?size=64\",\"roleColor\":\"#11806a\",\"roleIcon\":\"https://cdn.discordapp.com/role-icons/927207618638925854/d6353d6117aff284e0a3816bc59d2336.webp\",\"roleName\":\"Turixta\",\"bot\":false,\"verified\":false},\"659918884844994603\":{\"author\":\"! [🐴] Raphael\",\"avatar\":\"https://cdn.discordapp.com/avatars/659918884844994603/49360667c1046f39e89d5c0b4051cba3.webp?size=64\",\"roleColor\":\"#d4843d\",\"roleIcon\":\"https://cdn.discordapp.com/role-icons/927207621100969985/0bd4ba363baf51ba0164a27447535dcc.webp\",\"roleName\":\"SERVIDOR・CEO\",\"bot\":false,\"verified\":false},\"400712876056117248\":{\"author\":\"[🦝] Flashh\",\"avatar\":\"https://cdn.discordapp.com/avatars/400712876056117248/3765f35466140a0ca1cceff6e28c338a.webp?size=64\",\"roleColor\":\"#a10b7b\",\"roleIcon\":\"https://cdn.discordapp.com/role-icons/927207621100969985/0bd4ba363baf51ba0164a27447535dcc.webp\",\"roleName\":\"SERVIDOR・CEO\",\"bot\":false,\"verified\":false}}}</script><script type=\"module\" src=\"https://cdn.jsdelivr.net/npm/@derockdev/discord-components-core@^3.6.1/dist/derockdev-discord-components-core/derockdev-discord-components-core.esm.js\"></script></head><body style=\"margin:0;min-height:100vh\"><discord-messages style=\"min-height:100vh\"><discord-header guild=\"Refúgio Roleplay 💚\" channel=\"🪙┃ticket-8013\" icon=\"https://cdn.discordapp.com/icons/491309213553917952/a_34648f7a1342a2a7343585d52d846f0b.gif?size=128\">This is the start of #🪙┃ticket-8013 channel.</discord-header><discord-message id=\"m-1445950340896784415\" timestamp=\"2025-12-04T01:30:25.728Z\" edited=\"false\" highlight=\"false\" profile=\"1003801622247383180\"><discord-mention type=\"user\">Pedro Dybala</discord-mention>, <discord-mention type=\"role\" color=\"#c27c0e\">SERVIDOR・EQUIPE</discord-mention><discord-embed embed-title=\"🪙 Doação\" slot=\"embeds\" color=\"#2f3136\" thumbnail=\"https://images-ext-1.discordapp.net/external/17xTmt2rTPgBOSZaS5I7e_j8l5WZC0CyKtdUUik_DoI/https/cdn.discordapp.com/avatars/1372678821324652616/4031fba9909cb1f95f137bb50eda6f34.webp\"><discord-embed-description slot=\"description\">Seja bem-vindo ao ticket de doação! Pra agilizar o atendimento por favor, especifique como podemos te ajudar.<br/><br/><discord-custom-emoji name=\"⚙️\" url=\"https://cdnjs.cloudflare.com/ajax/libs/twemoji/14.0.2/svg/2699.svg\" embed-emoji=\"true\"></discord-custom-emoji> <discord-underlined><discord-bold>Adicionar ou remover membros:</discord-bold></discord-underlined><br/>Use um dos botões de acordo com a ação que você deseja fazer.</discord-embed-description><discord-embed-footer slot=\"footer\" footer-image=\"https://images-ext-1.discordapp.net/external/yLihPFx_FJKzd-UOjQ2RQepRLMFFzhNqekN8YKwk7N8/https/cdn.discordapp.com/avatars/1003801622247383180/a_24e84ba106cec0b4a5ed5cd3ac391f2c.gif\" timestamp=\"2025-12-04T01:30:25.461000+00:00\">REFÚGIO SC © Todos os direitos reservados.</discord-embed-footer></discord-embed><discord-attachments slot=\"components\"><discord-action-row><discord-button type=\"primary\" emoji=\"https://cdnjs.cloudflare.com/ajax/libs/twemoji/14.0.2/svg/1f464.svg\">Adicionar</discord-button><discord-button type=\"destructive\" emoji=\"https://cdnjs.cloudflare.com/ajax/libs/twemoji/14.0.2/svg/1f6b7.svg\">Remover</discord-button><discord-button type=\"success\" emoji=\"https://cdnjs.cloudflare.com/ajax/libs/twemoji/14.0.2/svg/2705.svg\">Finalizar Ticket</discord-button></discord-action-row><discord-action-row><discord-button type=\"secondary\" emoji=\"https://cdnjs.cloudflare.com/ajax/libs/twemoji/14.0.2/svg/270f.svg\">Trocar nome do Canal</discord-button><discord-button type=\"secondary\" emoji=\"https://cdnjs.cloudflare.com/ajax/libs/twemoji/14.0.2/svg/2699.svg\">Trocar Categoria</discord-button><discord-button type=\"secondary\" emoji=\"https://cdnjs.cloudflare.com/ajax/libs/twemoji/14.0.2/svg/1f514.svg\">POKE</discord-button></discord-action-row></discord-attachments></discord-message><discord-system-message id=\"m-1445950342125588681\" type=\"pin\"><i style=\"color:#ffffff\">Refúgio</i> pinned <i data-goto=\"1445950340896784415\">a message</i> to this channel.</discord-system-message><discord-message id=\"m-1445950348270502009\" timestamp=\"2025-12-04T01:30:27.486Z\" edited=\"false\" highlight=\"false\" profile=\"1372678821324652616\">teste</discord-message><discord-message id=\"m-1445950385553408040\" timestamp=\"2025-12-04T01:30:36.375Z\" edited=\"false\" highlight=\"false\" profile=\"659918884844994603\">;</discord-message><discord-message id=\"m-1445950387218808963\" timestamp=\"2025-12-04T01:30:36.772Z\" edited=\"false\" highlight=\"false\" profile=\"1003801622247383180\"><discord-embed embed-title=\"Ticket assumido\" slot=\"embeds\" color=\"#2f3136\"><discord-embed-description slot=\"description\">O ticket foi assumido pelo staff <discord-mention type=\"user\">Raphael</discord-mention></discord-embed-description><discord-embed-footer slot=\"footer\" footer-image=\"https://images-ext-1.discordapp.net/external/yLihPFx_FJKzd-UOjQ2RQepRLMFFzhNqekN8YKwk7N8/https/cdn.discordapp.com/avatars/1003801622247383180/a_24e84ba106cec0b4a5ed5cd3ac391f2c.gif\" timestamp=\"2025-12-04T01:30:36.482000+00:00\">REFÚGIO SC © Todos os direitos reservados.</discord-embed-footer></discord-embed></discord-message><discord-message id=\"m-1445950688608911541\" timestamp=\"2025-12-04T01:31:48.629Z\" edited=\"false\" highlight=\"false\" profile=\"400712876056117248\"><discord-custom-emoji name=\"refugiolobo\" url=\"https://cdn.discordapp.com/emojis/1137580385321091082.png\" embed-emoji=\"false\" large-emoji=\"true\"></discord-custom-emoji></discord-message><discord-message id=\"m-1445950866736549938\" timestamp=\"2025-12-04T01:32:31.098Z\" edited=\"true\" server=\"false\" highlight=\"false\" profile=\"1003801622247383180\"><discord-reply slot=\"reply\">Message could not be loaded.</discord-reply><discord-embed embed-title=\"⚙️ Ticket fechado\" slot=\"embeds\" color=\"#2f3136\"><discord-embed-description slot=\"description\">Ticket fechado em 03/12/2025, 22:32:34 por <discord-mention type=\"user\">Raphael</discord-mention>!<br/>Este canal será deletado em 5 segundos.</discord-embed-description><discord-embed-fields slot=\"fields\"><discord-embed-field field-title=\"📦 **__Motivo do fechamento:__**\" inline=\"false\" inline-index=\"1\"><discord-code-block language=\"\" code=\"a\"></discord-code-block></discord-embed-field></discord-embed-fields><discord-embed-footer slot=\"footer\" footer-image=\"https://images-ext-1.discordapp.net/external/yLihPFx_FJKzd-UOjQ2RQepRLMFFzhNqekN8YKwk7N8/https/cdn.discordapp.com/avatars/1003801622247383180/a_24e84ba106cec0b4a5ed5cd3ac391f2c.gif\" timestamp=\"2025-12-04T01:32:34.127000+00:00\">REFÚGIO SC © Todos os direitos reservados.</discord-embed-footer></discord-embed></discord-message><div style=\"text-align:center;width:100%\">Refúgio SC - Ticket Transcript </div></discord-messages></body></html>'),
(8014,'<html><head><meta charSet=\"utf-8\"/><meta name=\"viewport\" content=\"width=device-width, initial-scale=1\"/><link rel=\"icon\" type=\"image/png\" href=\"https://cdn.discordapp.com/icons/491309213553917952/a_34648f7a1342a2a7343585d52d846f0b.gif?size=16\"/><title>💡┃ticket-8014</title><script>document.addEventListener(\"click\",t=>{let e=t.target;if(!e)return;let o=e?.getAttribute(\"data-goto\");if(o){let r=document.getElementById(`m-${o}`);r?(r.scrollIntoView({behavior:\"smooth\",block:\"center\"}),r.style.backgroundColor=\"rgba(148, 156, 247, 0.1)\",r.style.transition=\"background-color 0.5s ease\",setTimeout(()=>{r.style.backgroundColor=\"transparent\"},1e3)):console.warn(\"Message ${goto} not found.\")}});</script><script>window.$discordMessage={profiles:{\"1003801622247383180\":{\"author\":\"Refúgio\",\"avatar\":\"https://cdn.discordapp.com/avatars/1003801622247383180/a_24e84ba106cec0b4a5ed5cd3ac391f2c.gif?size=64\",\"roleColor\":\"#ffffff\",\"roleIcon\":\"https://cdn.discordapp.com/role-icons/927207618638925854/d6353d6117aff284e0a3816bc59d2336.webp\",\"roleName\":\"Turixta\",\"bot\":true,\"verified\":false},\"1372678821324652616\":{\"author\":\"Pedro Dybala\",\"avatar\":\"https://cdn.discordapp.com/avatars/1372678821324652616/4031fba9909cb1f95f137bb50eda6f34.webp?size=64\",\"bot\":false,\"verified\":false},\"659918884844994603\":{\"author\":\"! [🐴] Raphael\",\"avatar\":\"https://cdn.discordapp.com/avatars/659918884844994603/49360667c1046f39e89d5c0b4051cba3.webp?size=64\",\"roleColor\":\"#d4843d\",\"roleIcon\":\"https://cdn.discordapp.com/role-icons/927207621100969985/0bd4ba363baf51ba0164a27447535dcc.webp\",\"roleName\":\"SERVIDOR・CEO\",\"bot\":false,\"verified\":false}}}</script><script type=\"module\" src=\"https://cdn.jsdelivr.net/npm/@derockdev/discord-components-core@^3.6.1/dist/derockdev-discord-components-core/derockdev-discord-components-core.esm.js\"></script></head><body style=\"margin:0;min-height:100vh\"><discord-messages style=\"min-height:100vh\"><discord-header guild=\"Refúgio Roleplay 💚\" channel=\"💡┃ticket-8014\" icon=\"https://cdn.discordapp.com/icons/491309213553917952/a_34648f7a1342a2a7343585d52d846f0b.gif?size=128\">This is the start of #💡┃ticket-8014 channel.</discord-header><discord-message id=\"m-1445952466779766936\" timestamp=\"2025-12-04T01:38:52.578Z\" edited=\"false\" highlight=\"false\" profile=\"1003801622247383180\"><discord-mention type=\"user\">Pedro Dybala</discord-mention>, <discord-mention type=\"role\" color=\"#c27c0e\">SERVIDOR・EQUIPE</discord-mention><discord-embed embed-title=\"💡 Suporte\" slot=\"embeds\" color=\"#2f3136\" thumbnail=\"https://images-ext-1.discordapp.net/external/17xTmt2rTPgBOSZaS5I7e_j8l5WZC0CyKtdUUik_DoI/https/cdn.discordapp.com/avatars/1372678821324652616/4031fba9909cb1f95f137bb50eda6f34.webp\"><discord-embed-description slot=\"description\">Olá, por favor especifique como podemos te ajudar para um atendimento assertivo.<br/><br/><discord-custom-emoji name=\"⚙️\" url=\"https://cdnjs.cloudflare.com/ajax/libs/twemoji/14.0.2/svg/2699.svg\" embed-emoji=\"true\"></discord-custom-emoji> <discord-underlined><discord-bold>Adicionar ou remover membros:</discord-bold></discord-underlined><br/>Use um dos botões de acordo com a ação que você deseja fazer.</discord-embed-description><discord-embed-footer slot=\"footer\" footer-image=\"https://images-ext-1.discordapp.net/external/yLihPFx_FJKzd-UOjQ2RQepRLMFFzhNqekN8YKwk7N8/https/cdn.discordapp.com/avatars/1003801622247383180/a_24e84ba106cec0b4a5ed5cd3ac391f2c.gif\" timestamp=\"2025-12-04T01:38:52.269000+00:00\">REFÚGIO SC © Todos os direitos reservados.</discord-embed-footer></discord-embed><discord-attachments slot=\"components\"><discord-action-row><discord-button type=\"primary\" emoji=\"https://cdnjs.cloudflare.com/ajax/libs/twemoji/14.0.2/svg/1f464.svg\">Adicionar</discord-button><discord-button type=\"destructive\" emoji=\"https://cdnjs.cloudflare.com/ajax/libs/twemoji/14.0.2/svg/1f6b7.svg\">Remover</discord-button><discord-button type=\"success\" emoji=\"https://cdnjs.cloudflare.com/ajax/libs/twemoji/14.0.2/svg/2705.svg\">Finalizar Ticket</discord-button></discord-action-row><discord-action-row><discord-button type=\"secondary\" emoji=\"https://cdnjs.cloudflare.com/ajax/libs/twemoji/14.0.2/svg/270f.svg\">Trocar nome do Canal</discord-button><discord-button type=\"secondary\" emoji=\"https://cdnjs.cloudflare.com/ajax/libs/twemoji/14.0.2/svg/2699.svg\">Trocar Categoria</discord-button><discord-button type=\"secondary\" emoji=\"https://cdnjs.cloudflare.com/ajax/libs/twemoji/14.0.2/svg/1f514.svg\">POKE</discord-button></discord-action-row></discord-attachments></discord-message><discord-system-message id=\"m-1445952468449234944\" type=\"pin\"><i style=\"color:#ffffff\">Refúgio</i> pinned <i data-goto=\"1445952466779766936\">a message</i> to this channel.</discord-system-message><discord-message id=\"m-1445952484320350371\" timestamp=\"2025-12-04T01:38:56.760Z\" edited=\"false\" highlight=\"false\" profile=\"1372678821324652616\">oi</discord-message><discord-message id=\"m-1445952491903778910\" timestamp=\"2025-12-04T01:38:58.568Z\" edited=\"false\" highlight=\"false\" profile=\"1003801622247383180\"><discord-mention type=\"user\">Pedro Dybala</discord-mention>, Desculpe, tive um problema ao gerar a resposta automática agora. A equipe será acionada para te ajudar.</discord-message><discord-message id=\"m-1445953048215031961\" timestamp=\"2025-12-04T01:41:11.203Z\" edited=\"true\" server=\"false\" highlight=\"false\" profile=\"1003801622247383180\"><discord-reply slot=\"reply\">Message could not be loaded.</discord-reply><discord-embed embed-title=\"⚙️ Ticket fechado\" slot=\"embeds\" color=\"#2f3136\"><discord-embed-description slot=\"description\">Ticket fechado em 03/12/2025, 22:41:57 por <discord-mention type=\"user\">Raphael</discord-mention>!<br/>Este canal será deletado em 5 segundos.</discord-embed-description><discord-embed-fields slot=\"fields\"><discord-embed-field field-title=\"📦 **__Motivo do fechamento:__**\" inline=\"false\" inline-index=\"1\"><discord-code-block language=\"\" code=\"a\"></discord-code-block></discord-embed-field></discord-embed-fields><discord-embed-footer slot=\"footer\" footer-image=\"https://images-ext-1.discordapp.net/external/yLihPFx_FJKzd-UOjQ2RQepRLMFFzhNqekN8YKwk7N8/https/cdn.discordapp.com/avatars/1003801622247383180/a_24e84ba106cec0b4a5ed5cd3ac391f2c.gif\" timestamp=\"2025-12-04T01:41:57.966000+00:00\">REFÚGIO SC © Todos os direitos reservados.</discord-embed-footer></discord-embed></discord-message><discord-message id=\"m-1445953053386735646\" timestamp=\"2025-12-04T01:41:12.436Z\" edited=\"false\" highlight=\"false\" profile=\"659918884844994603\">te</discord-message><discord-message id=\"m-1445953054489706497\" timestamp=\"2025-12-04T01:41:12.699Z\" edited=\"false\" highlight=\"false\" profile=\"1003801622247383180\"><discord-embed embed-title=\"Ticket assumido\" slot=\"embeds\" color=\"#2f3136\"><discord-embed-description slot=\"description\">O ticket foi assumido pelo staff <discord-mention type=\"user\">Raphael</discord-mention></discord-embed-description><discord-embed-footer slot=\"footer\" footer-image=\"https://images-ext-1.discordapp.net/external/yLihPFx_FJKzd-UOjQ2RQepRLMFFzhNqekN8YKwk7N8/https/cdn.discordapp.com/avatars/1003801622247383180/a_24e84ba106cec0b4a5ed5cd3ac391f2c.gif\" timestamp=\"2025-12-04T01:41:12.608000+00:00\">REFÚGIO SC © Todos os direitos reservados.</discord-embed-footer></discord-embed></discord-message><discord-message id=\"m-1445953056846905456\" timestamp=\"2025-12-04T01:41:13.261Z\" edited=\"false\" highlight=\"false\" profile=\"1003801622247383180\"><discord-mention type=\"user\">Raphael</discord-mention>, Desculpe, tive um problema ao gerar a resposta automática agora. A equipe será acionada para te ajudar.</discord-message><div style=\"text-align:center;width:100%\">Refúgio SC - Ticket Transcript </div></discord-messages></body></html>'),
(8015,'<html><head><meta charSet=\"utf-8\"/><meta name=\"viewport\" content=\"width=device-width, initial-scale=1\"/><link rel=\"icon\" type=\"image/png\" href=\"https://cdn.discordapp.com/icons/491309213553917952/a_34648f7a1342a2a7343585d52d846f0b.gif?size=16\"/><title>🐛┃ticket-8015</title><script>document.addEventListener(\"click\",t=>{let e=t.target;if(!e)return;let o=e?.getAttribute(\"data-goto\");if(o){let r=document.getElementById(`m-${o}`);r?(r.scrollIntoView({behavior:\"smooth\",block:\"center\"}),r.style.backgroundColor=\"rgba(148, 156, 247, 0.1)\",r.style.transition=\"background-color 0.5s ease\",setTimeout(()=>{r.style.backgroundColor=\"transparent\"},1e3)):console.warn(\"Message ${goto} not found.\")}});</script><script>window.$discordMessage={profiles:{\"1003801622247383180\":{\"author\":\"Refúgio\",\"avatar\":\"https://cdn.discordapp.com/avatars/1003801622247383180/a_24e84ba106cec0b4a5ed5cd3ac391f2c.gif?size=64\",\"roleColor\":\"#ffffff\",\"roleIcon\":\"https://cdn.discordapp.com/role-icons/927207618638925854/d6353d6117aff284e0a3816bc59d2336.webp\",\"roleName\":\"Turixta\",\"bot\":true,\"verified\":false},\"659918884844994603\":{\"author\":\"! [🐴] Raphael\",\"avatar\":\"https://cdn.discordapp.com/avatars/659918884844994603/49360667c1046f39e89d5c0b4051cba3.webp?size=64\",\"roleColor\":\"#d4843d\",\"roleIcon\":\"https://cdn.discordapp.com/role-icons/927207621100969985/0bd4ba363baf51ba0164a27447535dcc.webp\",\"roleName\":\"SERVIDOR・CEO\",\"bot\":false,\"verified\":false},\"400712876056117248\":{\"author\":\"[🦝] Flashh\",\"avatar\":\"https://cdn.discordapp.com/avatars/400712876056117248/3765f35466140a0ca1cceff6e28c338a.webp?size=64\",\"roleColor\":\"#a10b7b\",\"roleIcon\":\"https://cdn.discordapp.com/role-icons/927207621100969985/0bd4ba363baf51ba0164a27447535dcc.webp\",\"roleName\":\"SERVIDOR・CEO\",\"bot\":false,\"verified\":false}}}</script><script type=\"module\" src=\"https://cdn.jsdelivr.net/npm/@derockdev/discord-components-core@^3.6.1/dist/derockdev-discord-components-core/derockdev-discord-components-core.esm.js\"></script></head><body style=\"margin:0;min-height:100vh\"><discord-messages style=\"min-height:100vh\"><discord-header guild=\"Refúgio Roleplay 💚\" channel=\"🐛┃ticket-8015\" icon=\"https://cdn.discordapp.com/icons/491309213553917952/a_34648f7a1342a2a7343585d52d846f0b.gif?size=128\">This is the start of #🐛┃ticket-8015 channel.</discord-header><discord-message id=\"m-1445954266622853221\" timestamp=\"2025-12-04T01:46:01.694Z\" edited=\"false\" highlight=\"false\" profile=\"1003801622247383180\"><discord-mention type=\"user\">Raphael</discord-mention>, <discord-mention type=\"role\" color=\"#c27c0e\">SERVIDOR・EQUIPE</discord-mention><discord-embed embed-title=\"🐛 Bug\" slot=\"embeds\" color=\"#2f3136\" thumbnail=\"https://images-ext-1.discordapp.net/external/CFQUWh3OFbooo6w2umYijPYfljMAVvWUBjNURJZG36s/https/cdn.discordapp.com/avatars/659918884844994603/49360667c1046f39e89d5c0b4051cba3.webp\"><discord-embed-description slot=\"description\">Detalhe o bug/glitch encontrado e o local e/ou momentos em que tal problema ocorre para que possamos analisar e entender com facilidade.<br/><br/><discord-custom-emoji name=\"⚙️\" url=\"https://cdnjs.cloudflare.com/ajax/libs/twemoji/14.0.2/svg/2699.svg\" embed-emoji=\"true\"></discord-custom-emoji> <discord-underlined><discord-bold>Adicionar ou remover membros:</discord-bold></discord-underlined><br/>Use um dos botões de acordo com a ação que você deseja fazer.</discord-embed-description><discord-embed-footer slot=\"footer\" footer-image=\"https://images-ext-1.discordapp.net/external/yLihPFx_FJKzd-UOjQ2RQepRLMFFzhNqekN8YKwk7N8/https/cdn.discordapp.com/avatars/1003801622247383180/a_24e84ba106cec0b4a5ed5cd3ac391f2c.gif\" timestamp=\"2025-12-04T01:46:01.256000+00:00\">REFÚGIO SC © Todos os direitos reservados.</discord-embed-footer></discord-embed><discord-attachments slot=\"components\"><discord-action-row><discord-button type=\"primary\" emoji=\"https://cdnjs.cloudflare.com/ajax/libs/twemoji/14.0.2/svg/1f464.svg\">Adicionar</discord-button><discord-button type=\"destructive\" emoji=\"https://cdnjs.cloudflare.com/ajax/libs/twemoji/14.0.2/svg/1f6b7.svg\">Remover</discord-button><discord-button type=\"success\" emoji=\"https://cdnjs.cloudflare.com/ajax/libs/twemoji/14.0.2/svg/2705.svg\">Finalizar Ticket</discord-button></discord-action-row><discord-action-row><discord-button type=\"secondary\" emoji=\"https://cdnjs.cloudflare.com/ajax/libs/twemoji/14.0.2/svg/270f.svg\">Trocar nome do Canal</discord-button><discord-button type=\"secondary\" emoji=\"https://cdnjs.cloudflare.com/ajax/libs/twemoji/14.0.2/svg/2699.svg\">Trocar Categoria</discord-button><discord-button type=\"secondary\" emoji=\"https://cdnjs.cloudflare.com/ajax/libs/twemoji/14.0.2/svg/1f514.svg\">POKE</discord-button></discord-action-row></discord-attachments></discord-message><discord-system-message id=\"m-1445954268292059146\" type=\"pin\"><i style=\"color:#ffffff\">Refúgio</i> pinned <i data-goto=\"1445954266622853221\">a message</i> to this channel.</discord-system-message><discord-message id=\"m-1445954274017280001\" timestamp=\"2025-12-04T01:46:03.457Z\" edited=\"false\" highlight=\"false\" profile=\"659918884844994603\">teste</discord-message><discord-message id=\"m-1445954276957487168\" timestamp=\"2025-12-04T01:46:04.158Z\" edited=\"false\" highlight=\"false\" profile=\"1003801622247383180\"><discord-mention type=\"user\">Raphael</discord-mention>, Desculpe, tive um problema ao falar com a IA agora. A equipe será acionada para te ajudar.</discord-message><discord-message id=\"m-1445954945173164174\" timestamp=\"2025-12-04T01:48:43.473Z\" edited=\"false\" highlight=\"false\" profile=\"659918884844994603\">teste</discord-message><discord-message id=\"m-1445955381682634796\" timestamp=\"2025-12-04T01:50:27.545Z\" edited=\"false\" highlight=\"false\" profile=\"659918884844994603\">a</discord-message><discord-message id=\"m-1445956378140082226\" timestamp=\"2025-12-04T01:54:25.119Z\" edited=\"false\" highlight=\"false\" profile=\"659918884844994603\">teste</discord-message><discord-message id=\"m-1445956491613044878\" timestamp=\"2025-12-04T01:54:52.173Z\" edited=\"false\" highlight=\"false\" profile=\"1003801622247383180\"><discord-mention type=\"user\">Raphael</discord-mention>, Olá! Eu sou a Jeniffer, sua atendente virtual aqui do Refúgio • Santa Catarina.<br/><br/>Vi sua mensagem e estou aqui para ajudar. Poderia me dizer qual é a sua dúvida ou no que você precisa de ajuda? Fique à vontade para explicar para que eu possa te auxiliar da melhor forma possível!</discord-message><discord-message id=\"m-1445956769783480505\" timestamp=\"2025-12-04T01:55:58.494Z\" edited=\"false\" highlight=\"false\" profile=\"659918884844994603\">eita</discord-message><discord-message id=\"m-1445956890268930200\" timestamp=\"2025-12-04T01:56:27.220Z\" edited=\"false\" server=\"false\" highlight=\"false\" profile=\"400712876056117248\"><discord-reply slot=\"reply\" edited=\"false\" attachment=\"false\" author=\"Refúgio\" avatar=\"https://cdn.discordapp.com/avatars/1003801622247383180/a_24e84ba106cec0b4a5ed5cd3ac391f2c.gif?size=32\" role-color=\"#ffffff\" bot=\"true\" verified=\"false\" op=\"false\" command=\"false\"><span data-goto=\"1445956491613044878\"><discord-mention type=\"user\">Raphael</discord-mention>, Olá! Eu sou a Jeniffer, sua atendente virtual aqui do Refúgio • Santa Catarina.  Vi sua mensagem e estou aqui para ajudar. Poderia me dizer qual é a sua dúvi...</span></discord-reply>quem é jenifer? <discord-mention type=\"user\">akami</discord-mention></discord-message><discord-message id=\"m-1445956893083308133\" timestamp=\"2025-12-04T01:56:27.891Z\" edited=\"false\" highlight=\"false\" profile=\"1003801622247383180\"><discord-embed embed-title=\"Ticket assumido\" slot=\"embeds\" color=\"#2f3136\"><discord-embed-description slot=\"description\">O ticket foi assumido pelo staff <discord-mention type=\"user\">zsGabriel</discord-mention></discord-embed-description><discord-embed-footer slot=\"footer\" footer-image=\"https://images-ext-1.discordapp.net/external/yLihPFx_FJKzd-UOjQ2RQepRLMFFzhNqekN8YKwk7N8/https/cdn.discordapp.com/avatars/1003801622247383180/a_24e84ba106cec0b4a5ed5cd3ac391f2c.gif\" timestamp=\"2025-12-04T01:56:27.322000+00:00\">REFÚGIO SC © Todos os direitos reservados.</discord-embed-footer></discord-embed></discord-message><discord-message id=\"m-1445962688776769637\" timestamp=\"2025-12-04T02:19:29.692Z\" edited=\"true\" server=\"false\" highlight=\"false\" profile=\"1003801622247383180\"><discord-reply slot=\"reply\">Message could not be loaded.</discord-reply><discord-embed embed-title=\"⚙️ Ticket fechado\" slot=\"embeds\" color=\"#2f3136\"><discord-embed-description slot=\"description\">Ticket fechado em 03/12/2025, 23:19:32 por <discord-mention type=\"user\">Raphael</discord-mention>!<br/>Este canal será deletado em 5 segundos.</discord-embed-description><discord-embed-fields slot=\"fields\"><discord-embed-field field-title=\"📦 **__Motivo do fechamento:__**\" inline=\"false\" inline-index=\"1\"><discord-code-block language=\"\" code=\"t\"></discord-code-block></discord-embed-field></discord-embed-fields><discord-embed-footer slot=\"footer\" footer-image=\"https://images-ext-1.discordapp.net/external/yLihPFx_FJKzd-UOjQ2RQepRLMFFzhNqekN8YKwk7N8/https/cdn.discordapp.com/avatars/1003801622247383180/a_24e84ba106cec0b4a5ed5cd3ac391f2c.gif\" timestamp=\"2025-12-04T02:19:32.209000+00:00\">REFÚGIO SC © Todos os direitos reservados.</discord-embed-footer></discord-embed></discord-message><discord-message id=\"m-1445962698918596618\" timestamp=\"2025-12-04T02:19:32.110Z\" edited=\"false\" highlight=\"false\" profile=\"1003801622247383180\">Vejo que nosso staffer <discord-mention type=\"user\">Raphael</discord-mention> veio te ajudar agora. Vou deixar vocês à vontade, e desejo um ótimo atendimento! <discord-custom-emoji name=\"😊\" url=\"https://cdnjs.cloudflare.com/ajax/libs/twemoji/14.0.2/svg/1f60a.svg\" embed-emoji=\"false\"></discord-custom-emoji></discord-message><div style=\"text-align:center;width:100%\">Refúgio SC - Ticket Transcript </div></discord-messages></body></html>'),
(8016,'<html><head><meta charSet=\"utf-8\"/><meta name=\"viewport\" content=\"width=device-width, initial-scale=1\"/><link rel=\"icon\" type=\"image/png\" href=\"https://cdn.discordapp.com/icons/491309213553917952/a_34648f7a1342a2a7343585d52d846f0b.gif?size=16\"/><title>🐛┃ticket-8016</title><script>document.addEventListener(\"click\",t=>{let e=t.target;if(!e)return;let o=e?.getAttribute(\"data-goto\");if(o){let r=document.getElementById(`m-${o}`);r?(r.scrollIntoView({behavior:\"smooth\",block:\"center\"}),r.style.backgroundColor=\"rgba(148, 156, 247, 0.1)\",r.style.transition=\"background-color 0.5s ease\",setTimeout(()=>{r.style.backgroundColor=\"transparent\"},1e3)):console.warn(\"Message ${goto} not found.\")}});</script><script>window.$discordMessage={profiles:{\"1003801622247383180\":{\"author\":\"Refúgio\",\"avatar\":\"https://cdn.discordapp.com/avatars/1003801622247383180/a_24e84ba106cec0b4a5ed5cd3ac391f2c.gif?size=64\",\"roleColor\":\"#ffffff\",\"roleIcon\":\"https://cdn.discordapp.com/role-icons/927207618638925854/d6353d6117aff284e0a3816bc59d2336.webp\",\"roleName\":\"Turixta\",\"bot\":true,\"verified\":false},\"1372678821324652616\":{\"author\":\"Pedro Dybala\",\"avatar\":\"https://cdn.discordapp.com/avatars/1372678821324652616/4031fba9909cb1f95f137bb50eda6f34.webp?size=64\",\"bot\":false,\"verified\":false}}}</script><script type=\"module\" src=\"https://cdn.jsdelivr.net/npm/@derockdev/discord-components-core@^3.6.1/dist/derockdev-discord-components-core/derockdev-discord-components-core.esm.js\"></script></head><body style=\"margin:0;min-height:100vh\"><discord-messages style=\"min-height:100vh\"><discord-header guild=\"Refúgio Roleplay 💚\" channel=\"🐛┃ticket-8016\" icon=\"https://cdn.discordapp.com/icons/491309213553917952/a_34648f7a1342a2a7343585d52d846f0b.gif?size=128\">This is the start of #🐛┃ticket-8016 channel.</discord-header><discord-message id=\"m-1445957074394677353\" timestamp=\"2025-12-04T01:57:11.119Z\" edited=\"false\" highlight=\"false\" profile=\"1003801622247383180\"><discord-mention type=\"user\">Pedro Dybala</discord-mention>, <discord-mention type=\"role\" color=\"#c27c0e\">SERVIDOR・EQUIPE</discord-mention><discord-embed embed-title=\"🐛 Bug\" slot=\"embeds\" color=\"#2f3136\" thumbnail=\"https://images-ext-1.discordapp.net/external/17xTmt2rTPgBOSZaS5I7e_j8l5WZC0CyKtdUUik_DoI/https/cdn.discordapp.com/avatars/1372678821324652616/4031fba9909cb1f95f137bb50eda6f34.webp\"><discord-embed-description slot=\"description\">Detalhe o bug/glitch encontrado e o local e/ou momentos em que tal problema ocorre para que possamos analisar e entender com facilidade.<br/><br/><discord-custom-emoji name=\"⚙️\" url=\"https://cdnjs.cloudflare.com/ajax/libs/twemoji/14.0.2/svg/2699.svg\" embed-emoji=\"true\"></discord-custom-emoji> <discord-underlined><discord-bold>Adicionar ou remover membros:</discord-bold></discord-underlined><br/>Use um dos botões de acordo com a ação que você deseja fazer.</discord-embed-description><discord-embed-footer slot=\"footer\" footer-image=\"https://images-ext-1.discordapp.net/external/yLihPFx_FJKzd-UOjQ2RQepRLMFFzhNqekN8YKwk7N8/https/cdn.discordapp.com/avatars/1003801622247383180/a_24e84ba106cec0b4a5ed5cd3ac391f2c.gif\" timestamp=\"2025-12-04T01:57:10.843000+00:00\">REFÚGIO SC © Todos os direitos reservados.</discord-embed-footer></discord-embed><discord-attachments slot=\"components\"><discord-action-row><discord-button type=\"primary\" emoji=\"https://cdnjs.cloudflare.com/ajax/libs/twemoji/14.0.2/svg/1f464.svg\">Adicionar</discord-button><discord-button type=\"destructive\" emoji=\"https://cdnjs.cloudflare.com/ajax/libs/twemoji/14.0.2/svg/1f6b7.svg\">Remover</discord-button><discord-button type=\"success\" emoji=\"https://cdnjs.cloudflare.com/ajax/libs/twemoji/14.0.2/svg/2705.svg\">Finalizar Ticket</discord-button></discord-action-row><discord-action-row><discord-button type=\"secondary\" emoji=\"https://cdnjs.cloudflare.com/ajax/libs/twemoji/14.0.2/svg/270f.svg\">Trocar nome do Canal</discord-button><discord-button type=\"secondary\" emoji=\"https://cdnjs.cloudflare.com/ajax/libs/twemoji/14.0.2/svg/2699.svg\">Trocar Categoria</discord-button><discord-button type=\"secondary\" emoji=\"https://cdnjs.cloudflare.com/ajax/libs/twemoji/14.0.2/svg/1f514.svg\">POKE</discord-button></discord-action-row></discord-attachments></discord-message><discord-system-message id=\"m-1445957075757957214\" type=\"pin\"><i style=\"color:#ffffff\">Refúgio</i> pinned <i data-goto=\"1445957074394677353\">a message</i> to this channel.</discord-system-message><discord-message id=\"m-1445957090828091512\" timestamp=\"2025-12-04T01:57:15.037Z\" edited=\"false\" highlight=\"false\" profile=\"1372678821324652616\">teste</discord-message><discord-message id=\"m-1445957097387851867\" timestamp=\"2025-12-04T01:57:16.601Z\" edited=\"false\" highlight=\"false\" profile=\"1003801622247383180\"><discord-mention type=\"user\">Pedro Dybala</discord-mention>, Olá! Bem-vindo(a) ao Refúgio SC. Sou a Jeniffer, sua atendente virtual.<br/><br/>Entendi que você enviou um ticket com o conteúdo &quot;teste&quot;. Poderia me informar qual a sua dúvida ou problema para que eu possa te ajudar da melhor forma?<br/><br/>Se for algo específico sobre o servidor ou que precise de intervenção da equipe, terei prazer em encaminhar sua solicitação.<br/><br/>Aguardo sua resposta!</discord-message><discord-message id=\"m-1445958605277888602\" timestamp=\"2025-12-04T02:03:16.110Z\" edited=\"true\" server=\"false\" highlight=\"false\" profile=\"1003801622247383180\"><discord-reply slot=\"reply\">Message could not be loaded.</discord-reply><discord-embed embed-title=\"⚙️ Ticket fechado\" slot=\"embeds\" color=\"#2f3136\"><discord-embed-description slot=\"description\">Ticket fechado em 03/12/2025, 23:03:18 por <discord-mention type=\"user\">Raphael</discord-mention>!<br/>Este canal será deletado em 5 segundos.</discord-embed-description><discord-embed-fields slot=\"fields\"><discord-embed-field field-title=\"📦 **__Motivo do fechamento:__**\" inline=\"false\" inline-index=\"1\"><discord-code-block language=\"\" code=\"fechado\"></discord-code-block></discord-embed-field></discord-embed-fields><discord-embed-footer slot=\"footer\" footer-image=\"https://images-ext-1.discordapp.net/external/yLihPFx_FJKzd-UOjQ2RQepRLMFFzhNqekN8YKwk7N8/https/cdn.discordapp.com/avatars/1003801622247383180/a_24e84ba106cec0b4a5ed5cd3ac391f2c.gif\" timestamp=\"2025-12-04T02:03:18.887000+00:00\">REFÚGIO SC © Todos os direitos reservados.</discord-embed-footer></discord-embed></discord-message><discord-message id=\"m-1445958617273598014\" timestamp=\"2025-12-04T02:03:18.970Z\" edited=\"false\" highlight=\"false\" profile=\"1003801622247383180\">Vejo que nosso staffer <discord-mention type=\"user\">Raphael</discord-mention> veio te ajudar agora. Vou deixar vocês à vontade, e desejo um ótimo atendimento! <discord-custom-emoji name=\"😊\" url=\"https://cdnjs.cloudflare.com/ajax/libs/twemoji/14.0.2/svg/1f60a.svg\" embed-emoji=\"false\"></discord-custom-emoji></discord-message><discord-message id=\"m-1445958619068760145\" timestamp=\"2025-12-04T02:03:19.398Z\" edited=\"false\" highlight=\"false\" profile=\"1003801622247383180\"><discord-embed embed-title=\"Ticket assumido\" slot=\"embeds\" color=\"#2f3136\"><discord-embed-description slot=\"description\">O ticket foi assumido pelo staff <discord-mention type=\"user\">Raphael</discord-mention></discord-embed-description><discord-embed-footer slot=\"footer\" footer-image=\"https://images-ext-1.discordapp.net/external/yLihPFx_FJKzd-UOjQ2RQepRLMFFzhNqekN8YKwk7N8/https/cdn.discordapp.com/avatars/1003801622247383180/a_24e84ba106cec0b4a5ed5cd3ac391f2c.gif\" timestamp=\"2025-12-04T02:03:18.621000+00:00\">REFÚGIO SC © Todos os direitos reservados.</discord-embed-footer></discord-embed></discord-message><div style=\"text-align:center;width:100%\">Refúgio SC - Ticket Transcript </div></discord-messages></body></html>'),
(8018,'<html><head><meta charSet=\"utf-8\"/><meta name=\"viewport\" content=\"width=device-width, initial-scale=1\"/><link rel=\"icon\" type=\"image/png\" href=\"https://cdn.discordapp.com/icons/491309213553917952/a_34648f7a1342a2a7343585d52d846f0b.gif?size=16\"/><title>⚡┃ticket-8018</title><script>document.addEventListener(\"click\",t=>{let e=t.target;if(!e)return;let o=e?.getAttribute(\"data-goto\");if(o){let r=document.getElementById(`m-${o}`);r?(r.scrollIntoView({behavior:\"smooth\",block:\"center\"}),r.style.backgroundColor=\"rgba(148, 156, 247, 0.1)\",r.style.transition=\"background-color 0.5s ease\",setTimeout(()=>{r.style.backgroundColor=\"transparent\"},1e3)):console.warn(\"Message ${goto} not found.\")}});</script><script>window.$discordMessage={profiles:{\"1003801622247383180\":{\"author\":\"Refúgio\",\"avatar\":\"https://cdn.discordapp.com/avatars/1003801622247383180/a_24e84ba106cec0b4a5ed5cd3ac391f2c.gif?size=64\",\"roleColor\":\"#ffffff\",\"roleIcon\":\"https://cdn.discordapp.com/role-icons/927207618638925854/d6353d6117aff284e0a3816bc59d2336.webp\",\"roleName\":\"Turixta\",\"bot\":true,\"verified\":false},\"735724009056108566\":{\"author\":\"[🐻] Ezaki\",\"avatar\":\"https://cdn.discordapp.com/guilds/491309213553917952/users/735724009056108566/avatars/3ae6a952ee87fc3d91d36af9d2460d26.webp?size=64\",\"roleColor\":\"#1f8b4c\",\"roleIcon\":\"https://cdn.discordapp.com/role-icons/927207587248758784/5963ab2d95704b8360e984fcced59083.webp\",\"roleName\":\"SERVIDOR・MODERADOR\",\"bot\":false,\"verified\":false}}}</script><script type=\"module\" src=\"https://cdn.jsdelivr.net/npm/@derockdev/discord-components-core@^3.6.1/dist/derockdev-discord-components-core/derockdev-discord-components-core.esm.js\"></script></head><body style=\"margin:0;min-height:100vh\"><discord-messages style=\"min-height:100vh\"><discord-header guild=\"Refúgio Roleplay 💚\" channel=\"⚡┃ticket-8018\" icon=\"https://cdn.discordapp.com/icons/491309213553917952/a_34648f7a1342a2a7343585d52d846f0b.gif?size=128\">This is the start of #⚡┃ticket-8018 channel.</discord-header><discord-message id=\"m-1445963391691784353\" timestamp=\"2025-12-04T02:22:17.280Z\" edited=\"false\" highlight=\"false\" profile=\"1003801622247383180\"><discord-mention type=\"user\">Anderson Prime</discord-mention>, <discord-mention type=\"role\" color=\"#c27c0e\">SERVIDOR・EQUIPE</discord-mention>, <discord-mention type=\"role\" color=\"#83c5fa\">SERVIDOR・RESP.  POLICIAS</discord-mention>, <discord-mention type=\"role\" color=\"#e74c3c\">SERVIDOR・RESP.  ILEGAL</discord-mention><discord-embed embed-title=\"⚡ Assumir fac/org/corp\" slot=\"embeds\" color=\"#2f3136\" thumbnail=\"https://images-ext-1.discordapp.net/external/3H5rKCHteFge-mqC5WipKk1ip1FeCLmh6sEIF4hIt10/https/cdn.discordapp.com/avatars/353601996646776832/fe5ce24f0a44200b37a07e9106473f3c.webp\"><discord-embed-description slot=\"description\">Olá, por favor nos informe qual a facção, organização ou corporação que deseja assumir.<br/>Mas primeiro, leia as regras para poder assumir e verifique se a sua escolhe está livre. Você pode verificar em <discord-mention type=\"channel\">📂・para-assumir</discord-mention>.<br/><br/><discord-custom-emoji name=\"⚙️\" url=\"https://cdnjs.cloudflare.com/ajax/libs/twemoji/14.0.2/svg/2699.svg\" embed-emoji=\"true\"></discord-custom-emoji> <discord-underlined><discord-bold>Adicionar ou remover membros:</discord-bold></discord-underlined><br/>Use um dos botões de acordo com a ação que você deseja fazer.</discord-embed-description><discord-embed-footer slot=\"footer\" footer-image=\"https://images-ext-1.discordapp.net/external/yLihPFx_FJKzd-UOjQ2RQepRLMFFzhNqekN8YKwk7N8/https/cdn.discordapp.com/avatars/1003801622247383180/a_24e84ba106cec0b4a5ed5cd3ac391f2c.gif\" timestamp=\"2025-12-04T02:22:16.924000+00:00\">REFÚGIO SC © Todos os direitos reservados.</discord-embed-footer></discord-embed><discord-attachments slot=\"components\"><discord-action-row><discord-button type=\"primary\" emoji=\"https://cdnjs.cloudflare.com/ajax/libs/twemoji/14.0.2/svg/1f464.svg\">Adicionar</discord-button><discord-button type=\"destructive\" emoji=\"https://cdnjs.cloudflare.com/ajax/libs/twemoji/14.0.2/svg/1f6b7.svg\">Remover</discord-button><discord-button type=\"success\" emoji=\"https://cdnjs.cloudflare.com/ajax/libs/twemoji/14.0.2/svg/2705.svg\">Finalizar Ticket</discord-button></discord-action-row><discord-action-row><discord-button type=\"secondary\" emoji=\"https://cdnjs.cloudflare.com/ajax/libs/twemoji/14.0.2/svg/270f.svg\">Trocar nome do Canal</discord-button><discord-button type=\"secondary\" emoji=\"https://cdnjs.cloudflare.com/ajax/libs/twemoji/14.0.2/svg/2699.svg\">Trocar Categoria</discord-button><discord-button type=\"secondary\" emoji=\"https://cdnjs.cloudflare.com/ajax/libs/twemoji/14.0.2/svg/1f514.svg\">POKE</discord-button></discord-action-row></discord-attachments></discord-message><discord-system-message id=\"m-1445963392903807149\" type=\"pin\"><i style=\"color:#ffffff\">Refúgio</i> pinned <i data-goto=\"1445963391691784353\">a message</i> to this channel.</discord-system-message><discord-message id=\"m-1445963444145619117\" timestamp=\"2025-12-04T02:22:29.786Z\" edited=\"false\" highlight=\"false\" profile=\"1003801622247383180\"><discord-mention type=\"user\">Anderson Prime</discord-mention>, Olá! Eu sou a Jeniffer, sua atendente virtual do Refúgio • Santa Catarina. <discord-custom-emoji name=\"😊\" url=\"https://cdnjs.cloudflare.com/ajax/libs/twemoji/14.0.2/svg/1f60a.svg\" embed-emoji=\"false\"></discord-custom-emoji><br/><br/>Olá! Que bom que você está interessado em contribuir para o Refúgio • Santa Catarina! <discord-custom-emoji name=\"😄\" url=\"https://cdnjs.cloudflare.com/ajax/libs/twemoji/14.0.2/svg/1f604.svg\" embed-emoji=\"false\"></discord-custom-emoji><br/><br/>Para que eu possa te ajudar melhor, por favor, me diga: <discord-bold>quantas pessoas você tem no seu grupo?</discord-bold><br/><br/>Dependendo da quantidade de membros, posso te informar sobre as oportunidades disponíveis para assumir facções ou órgãos. Fico no aguardo! <discord-custom-emoji name=\"😉\" url=\"https://cdnjs.cloudflare.com/ajax/libs/twemoji/14.0.2/svg/1f609.svg\" embed-emoji=\"false\"></discord-custom-emoji></discord-message><discord-message id=\"m-1445963490811711639\" timestamp=\"2025-12-04T02:22:40.912Z\" edited=\"false\" highlight=\"false\" profile=\"1003801622247383180\"><discord-mention type=\"user\">Anderson Prime</discord-mention>, Olá! Que bom que você e seu grupo já estão prontos para entrar na ação! <discord-custom-emoji name=\"😊\" url=\"https://cdnjs.cloudflare.com/ajax/libs/twemoji/14.0.2/svg/1f60a.svg\" embed-emoji=\"false\"></discord-custom-emoji><br/><br/>Para eu te ajudar melhor, você poderia me dizer para qual <discord-bold>facção</discord-bold> ou <discord-bold>organização</discord-bold> vocês gostariam de assumir? Assim, posso verificar as vagas e os requisitos para vocês.<br/><br/>No momento, a whitelist ainda não está liberada, pois o servidor ainda não foi inaugurado. Fique de olho no nosso Instagram <discord-bold>@refugioscrp</discord-bold> para não perder a data oficial! <discord-custom-emoji name=\"😉\" url=\"https://cdnjs.cloudflare.com/ajax/libs/twemoji/14.0.2/svg/1f609.svg\" embed-emoji=\"false\"></discord-custom-emoji></discord-message><discord-message id=\"m-1445963551838568479\" timestamp=\"2025-12-04T02:22:55.462Z\" edited=\"false\" highlight=\"false\" profile=\"1003801622247383180\"><discord-mention type=\"user\">Anderson Prime</discord-mention>, Olá! Tudo bem? Eu sou a Jeniffer, sua atendente virtual aqui no Refúgio • Santa Catarina. <discord-custom-emoji name=\"😊\" url=\"https://cdnjs.cloudflare.com/ajax/libs/twemoji/14.0.2/svg/1f60a.svg\" embed-emoji=\"false\"></discord-custom-emoji><br/><br/>Entendo seu interesse em assumir a Cosa Nostra! No momento, as facções estão passando por um processo de organização e avaliação. Para te ajudar a entender melhor, você poderia me dizer com quantas pessoas você pretende entrar na facção?<br/><br/>Assim que tivermos essa informação, podemos avaliar a possibilidade. A equipe estará analisando todos os pedidos com carinho!<br/><br/>Ah, e se tiver mais alguma dúvida ou quiser acompanhar as novidades sobre a inauguração e outros assuntos, fique de olho no nosso Instagram oficial: @refugioscrp. Lá teremos todas as informações sobre as datas e o que mais estiver rolando! <discord-custom-emoji name=\"😉\" url=\"https://cdnjs.cloudflare.com/ajax/libs/twemoji/14.0.2/svg/1f609.svg\" embed-emoji=\"false\"></discord-custom-emoji></discord-message><discord-message id=\"m-1445963650929004627\" timestamp=\"2025-12-04T02:23:19.087Z\" edited=\"false\" highlight=\"false\" profile=\"1003801622247383180\"><discord-mention type=\"user\">Anderson Prime</discord-mention>, Olá! Tudo bem com você?<br/><br/>Eu sou a Jeniffer, sua atendente virtual aqui do Refúgio • Santa Catarina. Entendi que você gostaria de falar com um de nossos atendentes.<br/><br/>Pode deixar comigo! Vou chamar a equipe para te atender assim que possível. Por favor, aguarde um momento.<br/><br/>Se precisar de mais alguma coisa enquanto espera, pode me perguntar!</discord-message><discord-message id=\"m-1445963720562839552\" timestamp=\"2025-12-04T02:23:35.689Z\" edited=\"false\" highlight=\"false\" profile=\"1003801622247383180\"><discord-mention type=\"user\">Anderson Prime</discord-mention>, Olá! Sinto muito que você esteja frustrado. Se eu puder ajudar com alguma dúvida sobre o servidor Refúgio • Santa Catarina, por favor, me diga. Estou aqui para te auxiliar da melhor forma possível! <discord-custom-emoji name=\"😊\" url=\"https://cdnjs.cloudflare.com/ajax/libs/twemoji/14.0.2/svg/1f60a.svg\" embed-emoji=\"false\"></discord-custom-emoji></discord-message><discord-message id=\"m-1445963743413407874\" timestamp=\"2025-12-04T02:23:41.137Z\" edited=\"false\" highlight=\"false\" profile=\"1003801622247383180\"><discord-mention type=\"user\">Anderson Prime</discord-mention>, já te ajudei com algumas informações. Vou acionar nossa equipe para continuar o atendimento, beleza? <discord-custom-emoji name=\"👨‍💻\" url=\"https://cdnjs.cloudflare.com/ajax/libs/twemoji/14.0.2/svg/1f468-200d-1f4bb.svg\" embed-emoji=\"false\"></discord-custom-emoji><discord-custom-emoji name=\"👩‍💻\" url=\"https://cdnjs.cloudflare.com/ajax/libs/twemoji/14.0.2/svg/1f469-200d-1f4bb.svg\" embed-emoji=\"false\"></discord-custom-emoji></discord-message><discord-message id=\"m-1445963800799870987\" timestamp=\"2025-12-04T02:23:54.819Z\" edited=\"false\" highlight=\"false\" profile=\"735724009056108566\">Boa noite</discord-message><discord-message id=\"m-1445963802293174435\" timestamp=\"2025-12-04T02:23:55.175Z\" edited=\"false\" highlight=\"false\" profile=\"1003801622247383180\"><discord-embed embed-title=\"Ticket assumido\" slot=\"embeds\" color=\"#2f3136\"><discord-embed-description slot=\"description\">O ticket foi assumido pelo staff <discord-mention type=\"user\">Ez</discord-mention></discord-embed-description><discord-embed-footer slot=\"footer\" footer-image=\"https://images-ext-1.discordapp.net/external/yLihPFx_FJKzd-UOjQ2RQepRLMFFzhNqekN8YKwk7N8/https/cdn.discordapp.com/avatars/1003801622247383180/a_24e84ba106cec0b4a5ed5cd3ac391f2c.gif\" timestamp=\"2025-12-04T02:23:54.927000+00:00\">REFÚGIO SC © Todos os direitos reservados.</discord-embed-footer></discord-embed></discord-message><discord-message id=\"m-1445963872031871076\" timestamp=\"2025-12-04T02:24:11.802Z\" edited=\"false\" highlight=\"false\" profile=\"735724009056108566\">O Cosa nostra já está assumido</discord-message><discord-message id=\"m-1445964004450373874\" timestamp=\"2025-12-04T02:24:43.373Z\" edited=\"false\" highlight=\"false\" profile=\"735724009056108566\">Certo tenha um bom ban</discord-message><discord-message id=\"m-1445964019167920213\" timestamp=\"2025-12-04T02:24:46.882Z\" edited=\"false\" highlight=\"false\" profile=\"735724009056108566\">até mais</discord-message><discord-message id=\"m-1445966415348895869\" timestamp=\"2025-12-04T02:34:18.176Z\" edited=\"true\" server=\"false\" highlight=\"false\" profile=\"1003801622247383180\"><discord-reply slot=\"reply\">Message could not be loaded.</discord-reply><discord-embed embed-title=\"⚙️ Ticket fechado\" slot=\"embeds\" color=\"#2f3136\"><discord-embed-description slot=\"description\">Ticket fechado em 03/12/2025, 23:34:30 por <discord-mention type=\"user\">V G</discord-mention>!<br/>Este canal será deletado em 5 segundos.</discord-embed-description><discord-embed-fields slot=\"fields\"><discord-embed-field field-title=\"📦 **__Motivo do fechamento:__**\" inline=\"false\" inline-index=\"1\"><discord-code-block language=\"\" code=\"resolvido\"></discord-code-block></discord-embed-field></discord-embed-fields><discord-embed-footer slot=\"footer\" footer-image=\"https://images-ext-1.discordapp.net/external/yLihPFx_FJKzd-UOjQ2RQepRLMFFzhNqekN8YKwk7N8/https/cdn.discordapp.com/avatars/1003801622247383180/a_24e84ba106cec0b4a5ed5cd3ac391f2c.gif\" timestamp=\"2025-12-04T02:34:30.574000+00:00\">REFÚGIO SC © Todos os direitos reservados.</discord-embed-footer></discord-embed></discord-message><div style=\"text-align:center;width:100%\">Refúgio SC - Ticket Transcript </div></discord-messages></body></html>'),
(8019,'<html><head><meta charSet=\"utf-8\"/><meta name=\"viewport\" content=\"width=device-width, initial-scale=1\"/><link rel=\"icon\" type=\"image/png\" href=\"https://cdn.discordapp.com/icons/491309213553917952/a_34648f7a1342a2a7343585d52d846f0b.gif?size=16\"/><title>💡┃ticket-8019</title><script>document.addEventListener(\"click\",t=>{let e=t.target;if(!e)return;let o=e?.getAttribute(\"data-goto\");if(o){let r=document.getElementById(`m-${o}`);r?(r.scrollIntoView({behavior:\"smooth\",block:\"center\"}),r.style.backgroundColor=\"rgba(148, 156, 247, 0.1)\",r.style.transition=\"background-color 0.5s ease\",setTimeout(()=>{r.style.backgroundColor=\"transparent\"},1e3)):console.warn(\"Message ${goto} not found.\")}});</script><script>window.$discordMessage={profiles:{\"1003801622247383180\":{\"author\":\"Refúgio\",\"avatar\":\"https://cdn.discordapp.com/avatars/1003801622247383180/a_24e84ba106cec0b4a5ed5cd3ac391f2c.gif?size=64\",\"roleColor\":\"#ffffff\",\"roleIcon\":\"https://cdn.discordapp.com/role-icons/927207618638925854/d6353d6117aff284e0a3816bc59d2336.webp\",\"roleName\":\"Turixta\",\"bot\":true,\"verified\":false},\"497842919835697162\":{\"author\":\"! ⌊🦄⌉ 𝓒𝓪𝓶𝓲𝓱\",\"avatar\":\"https://cdn.discordapp.com/guilds/491309213553917952/users/497842919835697162/avatars/1e782b51f7af9b9176f2af91a2552d5b.webp?size=64\",\"roleColor\":\"#a10b7b\",\"roleIcon\":\"https://cdn.discordapp.com/role-icons/927290367391440987/ecbf2e4ace6a2c155403eb391ac6b64c.webp\",\"roleName\":\"SERVIDOR・CFO\",\"bot\":false,\"verified\":false}}}</script><script type=\"module\" src=\"https://cdn.jsdelivr.net/npm/@derockdev/discord-components-core@^3.6.1/dist/derockdev-discord-components-core/derockdev-discord-components-core.esm.js\"></script></head><body style=\"margin:0;min-height:100vh\"><discord-messages style=\"min-height:100vh\"><discord-header guild=\"Refúgio Roleplay 💚\" channel=\"💡┃ticket-8019\" icon=\"https://cdn.discordapp.com/icons/491309213553917952/a_34648f7a1342a2a7343585d52d846f0b.gif?size=128\">This is the start of #💡┃ticket-8019 channel.</discord-header><discord-message id=\"m-1445964197543280752\" timestamp=\"2025-12-04T02:25:29.410Z\" edited=\"false\" highlight=\"false\" profile=\"1003801622247383180\"><discord-mention type=\"user\">akami</discord-mention>, <discord-mention type=\"role\" color=\"#c27c0e\">SERVIDOR・EQUIPE</discord-mention><discord-embed embed-title=\"💡 Suporte\" slot=\"embeds\" color=\"#2f3136\" thumbnail=\"https://images-ext-1.discordapp.net/external/H85O42gSAhEyCYfMB6zc-mIN8OprFg9H2N77M31VuZI/https/cdn.discordapp.com/avatars/497842919835697162/aa9a8ab92e3129d5da8de4c761f3ccc1.webp\"><discord-embed-description slot=\"description\">Olá, por favor especifique como podemos te ajudar para um atendimento assertivo.<br/><br/><discord-custom-emoji name=\"⚙️\" url=\"https://cdnjs.cloudflare.com/ajax/libs/twemoji/14.0.2/svg/2699.svg\" embed-emoji=\"true\"></discord-custom-emoji> <discord-underlined><discord-bold>Adicionar ou remover membros:</discord-bold></discord-underlined><br/>Use um dos botões de acordo com a ação que você deseja fazer.</discord-embed-description><discord-embed-footer slot=\"footer\" footer-image=\"https://images-ext-1.discordapp.net/external/yLihPFx_FJKzd-UOjQ2RQepRLMFFzhNqekN8YKwk7N8/https/cdn.discordapp.com/avatars/1003801622247383180/a_24e84ba106cec0b4a5ed5cd3ac391f2c.gif\" timestamp=\"2025-12-04T02:25:29.074000+00:00\">REFÚGIO SC © Todos os direitos reservados.</discord-embed-footer></discord-embed><discord-attachments slot=\"components\"><discord-action-row><discord-button type=\"primary\" emoji=\"https://cdnjs.cloudflare.com/ajax/libs/twemoji/14.0.2/svg/1f464.svg\">Adicionar</discord-button><discord-button type=\"destructive\" emoji=\"https://cdnjs.cloudflare.com/ajax/libs/twemoji/14.0.2/svg/1f6b7.svg\">Remover</discord-button><discord-button type=\"success\" emoji=\"https://cdnjs.cloudflare.com/ajax/libs/twemoji/14.0.2/svg/2705.svg\">Finalizar Ticket</discord-button></discord-action-row><discord-action-row><discord-button type=\"secondary\" emoji=\"https://cdnjs.cloudflare.com/ajax/libs/twemoji/14.0.2/svg/270f.svg\">Trocar nome do Canal</discord-button><discord-button type=\"secondary\" emoji=\"https://cdnjs.cloudflare.com/ajax/libs/twemoji/14.0.2/svg/2699.svg\">Trocar Categoria</discord-button><discord-button type=\"secondary\" emoji=\"https://cdnjs.cloudflare.com/ajax/libs/twemoji/14.0.2/svg/1f514.svg\">POKE</discord-button></discord-action-row></discord-attachments></discord-message><discord-system-message id=\"m-1445964198726074549\" type=\"pin\"><i style=\"color:#ffffff\">Refúgio</i> pinned <i data-goto=\"1445964197543280752\">a message</i> to this channel.</discord-system-message><discord-message id=\"m-1445964238702252162\" timestamp=\"2025-12-04T02:25:39.223Z\" edited=\"false\" highlight=\"false\" profile=\"497842919835697162\">Boa noite</discord-message><discord-message id=\"m-1445964240262529038\" timestamp=\"2025-12-04T02:25:39.595Z\" edited=\"false\" highlight=\"false\" profile=\"1003801622247383180\">Vejo que nosso staffer <discord-mention type=\"user\">akami</discord-mention> veio te ajudar agora. Vou deixar vocês à vontade, e desejo um ótimo atendimento! <discord-custom-emoji name=\"😊\" url=\"https://cdnjs.cloudflare.com/ajax/libs/twemoji/14.0.2/svg/1f60a.svg\" embed-emoji=\"false\"></discord-custom-emoji></discord-message><discord-message id=\"m-1445964463902691452\" timestamp=\"2025-12-04T02:26:32.915Z\" edited=\"true\" server=\"false\" highlight=\"false\" profile=\"1003801622247383180\"><discord-reply slot=\"reply\">Message could not be loaded.</discord-reply><discord-embed embed-title=\"⚙️ Ticket fechado\" slot=\"embeds\" color=\"#2f3136\"><discord-embed-description slot=\"description\">Ticket fechado em 03/12/2025, 23:26:35 por <discord-mention type=\"user\">akami</discord-mention>!<br/>Este canal será deletado em 5 segundos.</discord-embed-description><discord-embed-fields slot=\"fields\"><discord-embed-field field-title=\"📦 **__Motivo do fechamento:__**\" inline=\"false\" inline-index=\"1\"><discord-code-block language=\"\" code=\"3\"></discord-code-block></discord-embed-field></discord-embed-fields><discord-embed-footer slot=\"footer\" footer-image=\"https://images-ext-1.discordapp.net/external/yLihPFx_FJKzd-UOjQ2RQepRLMFFzhNqekN8YKwk7N8/https/cdn.discordapp.com/avatars/1003801622247383180/a_24e84ba106cec0b4a5ed5cd3ac391f2c.gif\" timestamp=\"2025-12-04T02:26:35.574000+00:00\">REFÚGIO SC © Todos os direitos reservados.</discord-embed-footer></discord-embed></discord-message><div style=\"text-align:center;width:100%\">Refúgio SC - Ticket Transcript </div></discord-messages></body></html>'),
(8020,'<html><head><meta charSet=\"utf-8\"/><meta name=\"viewport\" content=\"width=device-width, initial-scale=1\"/><link rel=\"icon\" type=\"image/png\" href=\"https://cdn.discordapp.com/icons/491309213553917952/a_34648f7a1342a2a7343585d52d846f0b.gif?size=16\"/><title>🐛┃ticket-8020</title><script>document.addEventListener(\"click\",t=>{let e=t.target;if(!e)return;let o=e?.getAttribute(\"data-goto\");if(o){let r=document.getElementById(`m-${o}`);r?(r.scrollIntoView({behavior:\"smooth\",block:\"center\"}),r.style.backgroundColor=\"rgba(148, 156, 247, 0.1)\",r.style.transition=\"background-color 0.5s ease\",setTimeout(()=>{r.style.backgroundColor=\"transparent\"},1e3)):console.warn(\"Message ${goto} not found.\")}});</script><script>window.$discordMessage={profiles:{\"1003801622247383180\":{\"author\":\"Refúgio\",\"avatar\":\"https://cdn.discordapp.com/avatars/1003801622247383180/a_24e84ba106cec0b4a5ed5cd3ac391f2c.gif?size=64\",\"roleColor\":\"#ffffff\",\"roleIcon\":\"https://cdn.discordapp.com/role-icons/927207618638925854/d6353d6117aff284e0a3816bc59d2336.webp\",\"roleName\":\"Turixta\",\"bot\":true,\"verified\":false},\"497842919835697162\":{\"author\":\"! ⌊🦄⌉ 𝓒𝓪𝓶𝓲𝓱\",\"avatar\":\"https://cdn.discordapp.com/guilds/491309213553917952/users/497842919835697162/avatars/1e782b51f7af9b9176f2af91a2552d5b.webp?size=64\",\"roleColor\":\"#a10b7b\",\"roleIcon\":\"https://cdn.discordapp.com/role-icons/927290367391440987/ecbf2e4ace6a2c155403eb391ac6b64c.webp\",\"roleName\":\"SERVIDOR・CFO\",\"bot\":false,\"verified\":false},\"659918884844994603\":{\"author\":\"! [🐴] Raphael\",\"avatar\":\"https://cdn.discordapp.com/avatars/659918884844994603/49360667c1046f39e89d5c0b4051cba3.webp?size=64\",\"roleColor\":\"#d4843d\",\"roleIcon\":\"https://cdn.discordapp.com/role-icons/927207621100969985/0bd4ba363baf51ba0164a27447535dcc.webp\",\"roleName\":\"SERVIDOR・CEO\",\"bot\":false,\"verified\":false}}}</script><script type=\"module\" src=\"https://cdn.jsdelivr.net/npm/@derockdev/discord-components-core@^3.6.1/dist/derockdev-discord-components-core/derockdev-discord-components-core.esm.js\"></script></head><body style=\"margin:0;min-height:100vh\"><discord-messages style=\"min-height:100vh\"><discord-header guild=\"Refúgio Roleplay 💚\" channel=\"🐛┃ticket-8020\" icon=\"https://cdn.discordapp.com/icons/491309213553917952/a_34648f7a1342a2a7343585d52d846f0b.gif?size=128\">This is the start of #🐛┃ticket-8020 channel.</discord-header><discord-message id=\"m-1445965017982963874\" timestamp=\"2025-12-04T02:28:45.018Z\" edited=\"false\" highlight=\"false\" profile=\"1003801622247383180\"><discord-mention type=\"user\">akami</discord-mention>, <discord-mention type=\"role\" color=\"#c27c0e\">SERVIDOR・EQUIPE</discord-mention><discord-embed embed-title=\"🐛 Bug\" slot=\"embeds\" color=\"#2f3136\" thumbnail=\"https://images-ext-1.discordapp.net/external/H85O42gSAhEyCYfMB6zc-mIN8OprFg9H2N77M31VuZI/https/cdn.discordapp.com/avatars/497842919835697162/aa9a8ab92e3129d5da8de4c761f3ccc1.webp\"><discord-embed-description slot=\"description\">Detalhe o bug/glitch encontrado e o local e/ou momentos em que tal problema ocorre para que possamos analisar e entender com facilidade.<br/><br/><discord-custom-emoji name=\"⚙️\" url=\"https://cdnjs.cloudflare.com/ajax/libs/twemoji/14.0.2/svg/2699.svg\" embed-emoji=\"true\"></discord-custom-emoji> <discord-underlined><discord-bold>Adicionar ou remover membros:</discord-bold></discord-underlined><br/>Use um dos botões de acordo com a ação que você deseja fazer.</discord-embed-description><discord-embed-footer slot=\"footer\" footer-image=\"https://images-ext-1.discordapp.net/external/yLihPFx_FJKzd-UOjQ2RQepRLMFFzhNqekN8YKwk7N8/https/cdn.discordapp.com/avatars/1003801622247383180/a_24e84ba106cec0b4a5ed5cd3ac391f2c.gif\" timestamp=\"2025-12-04T02:28:44.698000+00:00\">REFÚGIO SC © Todos os direitos reservados.</discord-embed-footer></discord-embed><discord-attachments slot=\"components\"><discord-action-row><discord-button type=\"primary\" emoji=\"https://cdnjs.cloudflare.com/ajax/libs/twemoji/14.0.2/svg/1f464.svg\">Adicionar</discord-button><discord-button type=\"destructive\" emoji=\"https://cdnjs.cloudflare.com/ajax/libs/twemoji/14.0.2/svg/1f6b7.svg\">Remover</discord-button><discord-button type=\"success\" emoji=\"https://cdnjs.cloudflare.com/ajax/libs/twemoji/14.0.2/svg/2705.svg\">Finalizar Ticket</discord-button></discord-action-row><discord-action-row><discord-button type=\"secondary\" emoji=\"https://cdnjs.cloudflare.com/ajax/libs/twemoji/14.0.2/svg/270f.svg\">Trocar nome do Canal</discord-button><discord-button type=\"secondary\" emoji=\"https://cdnjs.cloudflare.com/ajax/libs/twemoji/14.0.2/svg/2699.svg\">Trocar Categoria</discord-button><discord-button type=\"secondary\" emoji=\"https://cdnjs.cloudflare.com/ajax/libs/twemoji/14.0.2/svg/1f514.svg\">POKE</discord-button></discord-action-row></discord-attachments></discord-message><discord-system-message id=\"m-1445965019266285731\" type=\"pin\"><i style=\"color:#ffffff\">Refúgio</i> pinned <i data-goto=\"1445965017982963874\">a message</i> to this channel.</discord-system-message><discord-message id=\"m-1445965036349685770\" timestamp=\"2025-12-04T02:28:49.397Z\" edited=\"false\" highlight=\"false\" profile=\"497842919835697162\">Boa noite</discord-message><discord-message id=\"m-1445965042104406168\" timestamp=\"2025-12-04T02:28:50.769Z\" edited=\"false\" highlight=\"false\" profile=\"1003801622247383180\"><discord-mention type=\"user\">akami</discord-mention>, Olá! Eu sou a Jeniffer, sua atendente virtual do Refúgio • Santa Catarina. <discord-custom-emoji name=\"😊\" url=\"https://cdnjs.cloudflare.com/ajax/libs/twemoji/14.0.2/svg/1f60a.svg\" embed-emoji=\"false\"></discord-custom-emoji><br/><br/>Boa noite! Bem-vindo(a) ao Refúgio • Santa Catarina!<br/><br/>Como posso te ajudar hoje? <discord-custom-emoji name=\"😊\" url=\"https://cdnjs.cloudflare.com/ajax/libs/twemoji/14.0.2/svg/1f60a.svg\" embed-emoji=\"false\"></discord-custom-emoji></discord-message><discord-message id=\"m-1445965080448729179\" timestamp=\"2025-12-04T02:28:59.911Z\" edited=\"false\" highlight=\"false\" profile=\"497842919835697162\">Queria fechar parceria com a cidade</discord-message><discord-message id=\"m-1445965093484363927\" timestamp=\"2025-12-04T02:29:03.019Z\" edited=\"false\" highlight=\"false\" profile=\"1003801622247383180\"><discord-mention type=\"user\">akami</discord-mention>, Olá! Que bom que você se interessou em fazer parceria com a nossa cidade no Refúgio • Santa Catarina! <discord-custom-emoji name=\"😊\" url=\"https://cdnjs.cloudflare.com/ajax/libs/twemoji/14.0.2/svg/1f60a.svg\" embed-emoji=\"false\"></discord-custom-emoji><br/><br/>No momento, nosso servidor ainda não foi inaugurado, por isso a whitelist não está liberada. Assim que tivermos a data oficial de inauguração, anunciaremos em nosso Instagram: @refugioscrp.<br/><br/>Sobre o seu interesse em &quot;fechar parceria com a cidade&quot;, você poderia me explicar um pouco melhor o que você tem em mente? Você está falando sobre assumir alguma facção, organização, ou algo diferente?<br/><br/>Se for sobre assumir alguma organização, por favor, me diga quantas pessoas você tem no seu grupo. Assim, posso verificar as opções disponíveis e te explicar os requisitos.<br/><br/>Fico no aguardo! <discord-custom-emoji name=\"😉\" url=\"https://cdnjs.cloudflare.com/ajax/libs/twemoji/14.0.2/svg/1f609.svg\" embed-emoji=\"false\"></discord-custom-emoji></discord-message><discord-message id=\"m-1445965174170452000\" timestamp=\"2025-12-04T02:29:22.256Z\" edited=\"false\" highlight=\"false\" profile=\"497842919835697162\">Pode ser, tenho 4 pessoas</discord-message><discord-message id=\"m-1445965183175364660\" timestamp=\"2025-12-04T02:29:24.403Z\" edited=\"false\" highlight=\"false\" profile=\"1003801622247383180\"><discord-mention type=\"user\">akami</discord-mention>, Olá! Que bom que você e seu grupo estão interessados em fazer parte do Refúgio • Santa Catarina! <discord-custom-emoji name=\"😊\" url=\"https://cdnjs.cloudflare.com/ajax/libs/twemoji/14.0.2/svg/1f60a.svg\" embed-emoji=\"false\"></discord-custom-emoji><br/><br/>Para assumir uma facção ou organização, o primeiro passo é me dizer quantas pessoas compõem o seu grupo. Você mencionou que são 4 pessoas, certo?<br/><br/>Dependendo do tipo de facção que vocês têm em mente, os requisitos de quantidade de membros podem variar. Por exemplo, as organizações policiais legais como a Polícia Militar, CHOQUE, TÁTICO e Polícia Civil exigem um número maior de integrantes. Já os Bombeiros Militar podem ser assumidos com qualquer quantidade inicial.<br/><br/>Para as organizações ilegais, os requisitos também variam. Temos facções de armas, munição, lavagem/itens ilícitos, drogas e contrabando que precisam de um certo número de pessoas para serem administradas.<br/><br/>Por favor, me diga qual tipo de facção ou organização vocês gostariam de assumir, e eu poderei te informar os requisitos específicos e como funciona o processo. Lembre-se que a equipe sempre irá avaliar as candidaturas, e a vaga não é garantida de imediato.<br/><br/>Estou aqui para ajudar a esclarecer tudo para vocês!</discord-message><discord-message id=\"m-1445965291178954762\" timestamp=\"2025-12-04T02:29:50.153Z\" edited=\"false\" highlight=\"false\" profile=\"497842919835697162\">Bombeiros é qualquer quantidade é?</discord-message><discord-message id=\"m-1445965299928137748\" timestamp=\"2025-12-04T02:29:52.239Z\" edited=\"false\" highlight=\"false\" profile=\"1003801622247383180\"><discord-mention type=\"user\">akami</discord-mention>, Olá! Sou a Jeniffer, atendente virtual do Refúgio • Santa Catarina. <discord-custom-emoji name=\"😊\" url=\"https://cdnjs.cloudflare.com/ajax/libs/twemoji/14.0.2/svg/1f60a.svg\" embed-emoji=\"false\"></discord-custom-emoji><br/><br/>Respondendo à sua pergunta sobre os Bombeiros Militar [CBMSC]: Sim, você está correto! O Corpo de Bombeiros Militar está sem liderança no momento e pode ser assumido com qualquer quantidade inicial de membros (a partir de 0+).<br/><br/>Se você e seu grupo tiverem interesse em assumir essa organização, me diga! Precisarei saber quantas pessoas vocês têm para formar o grupo.<br/><br/>Se tiver mais alguma dúvida, é só perguntar! <discord-custom-emoji name=\"😉\" url=\"https://cdnjs.cloudflare.com/ajax/libs/twemoji/14.0.2/svg/1f609.svg\" embed-emoji=\"false\"></discord-custom-emoji></discord-message><discord-message id=\"m-1445965443444641901\" timestamp=\"2025-12-04T02:30:26.456Z\" edited=\"false\" highlight=\"false\" profile=\"497842919835697162\">entendi</discord-message><discord-message id=\"m-1445965450348593374\" timestamp=\"2025-12-04T02:30:28.102Z\" edited=\"false\" highlight=\"false\" profile=\"1003801622247383180\"><discord-mention type=\"user\">akami</discord-mention>, Olá! Que bom que você entendeu! <discord-custom-emoji name=\"😄\" url=\"https://cdnjs.cloudflare.com/ajax/libs/twemoji/14.0.2/svg/1f604.svg\" embed-emoji=\"false\"></discord-custom-emoji><br/><br/>Se tiver mais alguma dúvida ou precisar de ajuda com algo, é só me dizer! Estou aqui para ajudar.<br/><br/>Ah, e lembre-se:<br/>*   O servidor ainda <discord-bold>não foi inaugurado</discord-bold>. A data oficial será anunciada no nosso Instagram: <discord-bold>@refugioscrp</discord-bold>. Fique de olho por lá!<br/>*   A whitelist <discord-bold>não está liberada</discord-bold> no momento.<br/><br/>Qualquer coisa, é só chamar! <discord-custom-emoji name=\"😊\" url=\"https://cdnjs.cloudflare.com/ajax/libs/twemoji/14.0.2/svg/1f60a.svg\" embed-emoji=\"false\"></discord-custom-emoji></discord-message><discord-message id=\"m-1445965462486777927\" timestamp=\"2025-12-04T02:30:30.996Z\" edited=\"false\" highlight=\"false\" profile=\"497842919835697162\">quero assumir uma fac</discord-message><discord-message id=\"m-1445965464076550324\" timestamp=\"2025-12-04T02:30:31.375Z\" edited=\"false\" highlight=\"false\" profile=\"1003801622247383180\"><discord-mention type=\"user\">akami</discord-mention>, já te ajudei com algumas informações. Vou acionar nossa equipe para continuar o atendimento, beleza? <discord-custom-emoji name=\"👨‍💻\" url=\"https://cdnjs.cloudflare.com/ajax/libs/twemoji/14.0.2/svg/1f468-200d-1f4bb.svg\" embed-emoji=\"false\"></discord-custom-emoji><discord-custom-emoji name=\"👩‍💻\" url=\"https://cdnjs.cloudflare.com/ajax/libs/twemoji/14.0.2/svg/1f469-200d-1f4bb.svg\" embed-emoji=\"false\"></discord-custom-emoji></discord-message><discord-message id=\"m-1445965507776745703\" timestamp=\"2025-12-04T02:30:41.794Z\" edited=\"false\" highlight=\"false\" profile=\"497842919835697162\">não, quero falar com vc</discord-message><discord-message id=\"m-1445965544573501532\" timestamp=\"2025-12-04T02:30:50.567Z\" edited=\"false\" highlight=\"false\" profile=\"659918884844994603\">non vai</discord-message><discord-message id=\"m-1445965545877930165\" timestamp=\"2025-12-04T02:30:50.878Z\" edited=\"false\" highlight=\"false\" profile=\"1003801622247383180\"><discord-embed embed-title=\"Ticket assumido\" slot=\"embeds\" color=\"#2f3136\"><discord-embed-description slot=\"description\">O ticket foi assumido pelo staff <discord-mention type=\"user\">Raphael</discord-mention></discord-embed-description><discord-embed-footer slot=\"footer\" footer-image=\"https://images-ext-1.discordapp.net/external/yLihPFx_FJKzd-UOjQ2RQepRLMFFzhNqekN8YKwk7N8/https/cdn.discordapp.com/avatars/1003801622247383180/a_24e84ba106cec0b4a5ed5cd3ac391f2c.gif\" timestamp=\"2025-12-04T02:30:50.651000+00:00\">REFÚGIO SC © Todos os direitos reservados.</discord-embed-footer></discord-embed></discord-message><discord-message id=\"m-1445965549849935974\" timestamp=\"2025-12-04T02:30:51.825Z\" edited=\"false\" highlight=\"false\" profile=\"659918884844994603\">kkkkkkkkkkkkkk</discord-message><discord-message id=\"m-1445965557714124953\" timestamp=\"2025-12-04T02:30:53.700Z\" edited=\"false\" highlight=\"false\" profile=\"497842919835697162\">KKKKKKKKKKKKKKK</discord-message><discord-message id=\"m-1445965570997489675\" timestamp=\"2025-12-04T02:30:56.867Z\" edited=\"false\" highlight=\"false\" profile=\"659918884844994603\">só 5 msg</discord-message><discord-message id=\"m-1445965578333589544\" timestamp=\"2025-12-04T02:30:58.616Z\" edited=\"false\" highlight=\"false\" profile=\"497842919835697162\">besta</discord-message><discord-message id=\"m-1445965583794307083\" timestamp=\"2025-12-04T02:30:59.918Z\" edited=\"false\" highlight=\"false\" profile=\"497842919835697162\">kkkkkkkkkkkk</discord-message><discord-message id=\"m-1445965616799416553\" timestamp=\"2025-12-04T02:31:07.787Z\" edited=\"false\" highlight=\"false\" profile=\"497842919835697162\">afe</discord-message><discord-message id=\"m-1445965656075010078\" timestamp=\"2025-12-04T02:31:17.151Z\" edited=\"false\" highlight=\"false\" profile=\"497842919835697162\"><discord-custom-emoji name=\"cj\" url=\"https://cdn.discordapp.com/emojis/1137391907153121280.png\" embed-emoji=\"false\" large-emoji=\"true\"></discord-custom-emoji></discord-message><discord-message id=\"m-1445965714312794173\" timestamp=\"2025-12-04T02:31:31.036Z\" edited=\"false\" highlight=\"false\" profile=\"659918884844994603\"><a href=\"https://tenor.com/view/little-girl-cute-oh-my-god-too-much-stress-oh-gosh-gif-17610373\" target=\"_blank\" rel=\"noreferrer\">https://tenor.com/view/little-girl-cute-oh-my-god-too-much-stress-oh-gosh-gif-17610373</a><discord-embed slot=\"embeds\" thumbnail=\"https://images-ext-1.discordapp.net/external/KbK0inkklSzlZhbXTO6LX5894ykidtJw8ZZF0LdSlXg/https/media.tenor.com/LC2Jp87SCwQAAAAe/little-girl-cute.png\" url=\"https://tenor.com/view/little-girl-cute-oh-my-god-too-much-stress-oh-gosh-gif-17610373\"></discord-embed></discord-message><discord-message id=\"m-1446086581466300426\" timestamp=\"2025-12-04T10:31:48.011Z\" edited=\"false\" server=\"false\" highlight=\"false\" profile=\"1003801622247383180\"><discord-reply slot=\"reply\">Message could not be loaded.</discord-reply><discord-embed embed-title=\"🎫 Fechando ticket...\" slot=\"embeds\" color=\"#2f3136\"><discord-embed-description slot=\"description\">Aguarde um momento enquanto fechamos o ticket.</discord-embed-description><discord-embed-footer slot=\"footer\" footer-image=\"https://images-ext-1.discordapp.net/external/yLihPFx_FJKzd-UOjQ2RQepRLMFFzhNqekN8YKwk7N8/https/cdn.discordapp.com/avatars/1003801622247383180/a_24e84ba106cec0b4a5ed5cd3ac391f2c.gif\" timestamp=\"2025-12-04T10:31:47.823000+00:00\">REFÚGIO SC © Todos os direitos reservados.</discord-embed-footer></discord-embed></discord-message><discord-message id=\"m-1446129459643158598\" timestamp=\"2025-12-04T13:22:10.965Z\" edited=\"true\" server=\"false\" highlight=\"false\" profile=\"1003801622247383180\"><discord-reply slot=\"reply\">Message could not be loaded.</discord-reply><discord-embed embed-title=\"⚙️ Ticket fechado\" slot=\"embeds\" color=\"#2f3136\"><discord-embed-description slot=\"description\">Ticket fechado em 04/12/2025, 10:22:15 por <discord-mention type=\"user\">zsGabriel</discord-mention>!<br/>Este canal será deletado em 5 segundos.</discord-embed-description><discord-embed-fields slot=\"fields\"><discord-embed-field field-title=\"📦 **__Motivo do fechamento:__**\" inline=\"false\" inline-index=\"1\"><discord-code-block language=\"\" code=\"encerado\"></discord-code-block></discord-embed-field></discord-embed-fields><discord-embed-footer slot=\"footer\" footer-image=\"https://images-ext-1.discordapp.net/external/yLihPFx_FJKzd-UOjQ2RQepRLMFFzhNqekN8YKwk7N8/https/cdn.discordapp.com/avatars/1003801622247383180/a_24e84ba106cec0b4a5ed5cd3ac391f2c.gif\" timestamp=\"2025-12-04T13:22:15.289000+00:00\">REFÚGIO SC © Todos os direitos reservados.</discord-embed-footer></discord-embed></discord-message><div style=\"text-align:center;width:100%\">Refúgio SC - Ticket Transcript </div></discord-messages></body></html>'),
(8023,'<html><head><meta charSet=\"utf-8\"/><meta name=\"viewport\" content=\"width=device-width, initial-scale=1\"/><link rel=\"icon\" type=\"image/png\" href=\"https://cdn.discordapp.com/icons/491309213553917952/a_34648f7a1342a2a7343585d52d846f0b.gif?size=16\"/><title>⚡┃ticket-8023</title><script>document.addEventListener(\"click\",t=>{let e=t.target;if(!e)return;let o=e?.getAttribute(\"data-goto\");if(o){let r=document.getElementById(`m-${o}`);r?(r.scrollIntoView({behavior:\"smooth\",block:\"center\"}),r.style.backgroundColor=\"rgba(148, 156, 247, 0.1)\",r.style.transition=\"background-color 0.5s ease\",setTimeout(()=>{r.style.backgroundColor=\"transparent\"},1e3)):console.warn(\"Message ${goto} not found.\")}});</script><script>window.$discordMessage={profiles:{\"1003801622247383180\":{\"author\":\"Refúgio\",\"avatar\":\"https://cdn.discordapp.com/avatars/1003801622247383180/a_24e84ba106cec0b4a5ed5cd3ac391f2c.gif?size=64\",\"roleColor\":\"#ffffff\",\"roleIcon\":\"https://cdn.discordapp.com/role-icons/927207618638925854/d6353d6117aff284e0a3816bc59d2336.webp\",\"roleName\":\"Turixta\",\"bot\":true,\"verified\":false},\"353601996646776832\":{\"author\":\"Anderson Prime\",\"avatar\":\"https://cdn.discordapp.com/avatars/353601996646776832/fe5ce24f0a44200b37a07e9106473f3c.webp?size=64\",\"roleColor\":\"#11806a\",\"roleIcon\":\"https://cdn.discordapp.com/role-icons/927207618638925854/d6353d6117aff284e0a3816bc59d2336.webp\",\"roleName\":\"Turixta\",\"bot\":false,\"verified\":false}}}</script><script type=\"module\" src=\"https://cdn.jsdelivr.net/npm/@derockdev/discord-components-core@^3.6.1/dist/derockdev-discord-components-core/derockdev-discord-components-core.esm.js\"></script></head><body style=\"margin:0;min-height:100vh\"><discord-messages style=\"min-height:100vh\"><discord-header guild=\"Refúgio Roleplay 💚\" channel=\"⚡┃ticket-8023\" icon=\"https://cdn.discordapp.com/icons/491309213553917952/a_34648f7a1342a2a7343585d52d846f0b.gif?size=128\">This is the start of #⚡┃ticket-8023 channel.</discord-header><discord-message id=\"m-1446214419825692755\" timestamp=\"2025-12-04T18:59:47.051Z\" edited=\"false\" highlight=\"false\" profile=\"1003801622247383180\"><discord-mention type=\"user\">Anderson Prime</discord-mention>, <discord-mention type=\"role\" color=\"#c27c0e\">SERVIDOR・EQUIPE</discord-mention>, <discord-mention type=\"role\" color=\"#83c5fa\">SERVIDOR・RESP.  POLICIAS</discord-mention>, <discord-mention type=\"role\" color=\"#e74c3c\">SERVIDOR・RESP.  ILEGAL</discord-mention><discord-embed embed-title=\"⚡ Assumir fac/org/corp\" slot=\"embeds\" color=\"#2f3136\" thumbnail=\"https://images-ext-1.discordapp.net/external/3H5rKCHteFge-mqC5WipKk1ip1FeCLmh6sEIF4hIt10/https/cdn.discordapp.com/avatars/353601996646776832/fe5ce24f0a44200b37a07e9106473f3c.webp\"><discord-embed-description slot=\"description\">Olá, por favor nos informe qual a facção, organização ou corporação que deseja assumir.<br/>Mas primeiro, leia as regras para poder assumir e verifique se a sua escolhe está livre. Você pode verificar em <discord-mention type=\"channel\">📂・para-assumir</discord-mention>.<br/><br/><discord-custom-emoji name=\"⚙️\" url=\"https://cdnjs.cloudflare.com/ajax/libs/twemoji/14.0.2/svg/2699.svg\" embed-emoji=\"true\"></discord-custom-emoji> <discord-underlined><discord-bold>Adicionar ou remover membros:</discord-bold></discord-underlined><br/>Use um dos botões de acordo com a ação que você deseja fazer.</discord-embed-description><discord-embed-footer slot=\"footer\" footer-image=\"https://images-ext-1.discordapp.net/external/yLihPFx_FJKzd-UOjQ2RQepRLMFFzhNqekN8YKwk7N8/https/cdn.discordapp.com/avatars/1003801622247383180/a_24e84ba106cec0b4a5ed5cd3ac391f2c.gif\" timestamp=\"2025-12-04T18:59:46.819000+00:00\">REFÚGIO SC © Todos os direitos reservados.</discord-embed-footer></discord-embed><discord-attachments slot=\"components\"><discord-action-row><discord-button type=\"primary\" emoji=\"https://cdnjs.cloudflare.com/ajax/libs/twemoji/14.0.2/svg/1f464.svg\">Adicionar</discord-button><discord-button type=\"destructive\" emoji=\"https://cdnjs.cloudflare.com/ajax/libs/twemoji/14.0.2/svg/1f6b7.svg\">Remover</discord-button><discord-button type=\"success\" emoji=\"https://cdnjs.cloudflare.com/ajax/libs/twemoji/14.0.2/svg/2705.svg\">Finalizar Ticket</discord-button></discord-action-row><discord-action-row><discord-button type=\"secondary\" emoji=\"https://cdnjs.cloudflare.com/ajax/libs/twemoji/14.0.2/svg/270f.svg\">Trocar nome do Canal</discord-button><discord-button type=\"secondary\" emoji=\"https://cdnjs.cloudflare.com/ajax/libs/twemoji/14.0.2/svg/2699.svg\">Trocar Categoria</discord-button><discord-button type=\"secondary\" emoji=\"https://cdnjs.cloudflare.com/ajax/libs/twemoji/14.0.2/svg/1f514.svg\">POKE</discord-button></discord-action-row></discord-attachments></discord-message><discord-system-message id=\"m-1446214421549551748\" type=\"pin\"><i style=\"color:#ffffff\">Refúgio</i> pinned <i data-goto=\"1446214419825692755\">a message</i> to this channel.</discord-system-message><discord-message id=\"m-1446214498548453528\" timestamp=\"2025-12-04T19:00:05.820Z\" edited=\"false\" highlight=\"false\" profile=\"353601996646776832\">cade boca aberta os cara me matou aqui tava loco ja querendo mete bala tlg e foda em</discord-message><discord-message id=\"m-1446214507193045188\" timestamp=\"2025-12-04T19:00:07.881Z\" edited=\"false\" highlight=\"false\" profile=\"1003801622247383180\"><discord-mention type=\"user\">Anderson Prime</discord-mention>, Olá! Eu sou a Jeniffer, sua atendente virtual do Refúgio • Santa Catarina. <discord-custom-emoji name=\"😊\" url=\"https://cdnjs.cloudflare.com/ajax/libs/twemoji/14.0.2/svg/1f60a.svg\" embed-emoji=\"false\"></discord-custom-emoji><br/><br/>Olá! Eu sou a Jeniffer, atendente virtual do Refúgio • Santa Catarina. Entendi que você teve uma situação chata no jogo.<br/><br/>Lamento muito pelo que aconteceu! No momento, <discord-bold>nossa whitelist ainda não está liberada</discord-bold>, pois o servidor ainda não foi inaugurado.<br/><br/>Para ficar por dentro de todas as novidades e da data oficial de inauguração, por favor, acompanhe nosso Instagram: <discord-bold>@refugioscrp</discord-bold>.<br/><br/>Se precisar de ajuda com outras questões ou tiver mais dúvidas sobre o servidor, é só me perguntar! <discord-custom-emoji name=\"😊\" url=\"https://cdnjs.cloudflare.com/ajax/libs/twemoji/14.0.2/svg/1f60a.svg\" embed-emoji=\"false\"></discord-custom-emoji></discord-message><discord-message id=\"m-1446215177497481297\" timestamp=\"2025-12-04T19:02:47.694Z\" edited=\"false\" highlight=\"false\" profile=\"353601996646776832\">belezaentao fechaisso blz nois tmj</discord-message><discord-message id=\"m-1446215183721693235\" timestamp=\"2025-12-04T19:02:49.178Z\" edited=\"false\" highlight=\"false\" profile=\"1003801622247383180\"><discord-mention type=\"user\">Anderson Prime</discord-mention>, Olá! Que bom ter você por aqui no Refúgio • Santa Catarina! Fico feliz que tenha gostado das informações. <discord-custom-emoji name=\"😊\" url=\"https://cdnjs.cloudflare.com/ajax/libs/twemoji/14.0.2/svg/1f60a.svg\" embed-emoji=\"false\"></discord-custom-emoji><br/><br/>Se tiver mais alguma dúvida ou precisar de algo, é só me chamar! Estou à disposição para ajudar. <discord-custom-emoji name=\"💙\" url=\"https://cdnjs.cloudflare.com/ajax/libs/twemoji/14.0.2/svg/1f499.svg\" embed-emoji=\"false\"></discord-custom-emoji></discord-message><discord-message id=\"m-1446215211785916498\" timestamp=\"2025-12-04T19:02:55.869Z\" edited=\"false\" highlight=\"false\" profile=\"353601996646776832\">raphael é um pau no cu ne</discord-message><discord-message id=\"m-1446215217842491464\" timestamp=\"2025-12-04T19:02:57.313Z\" edited=\"false\" highlight=\"false\" profile=\"1003801622247383180\"><discord-mention type=\"user\">Anderson Prime</discord-mention>, Olá! Sou a Jeniffer, sua atendente virtual aqui no Refúgio • Santa Catarina.<br/><br/>Sinto muito que você esteja tendo uma experiência negativa. Para que eu possa te ajudar da melhor forma possível, você poderia me explicar qual foi o problema ou situação que te levou a essa frustração? Assim, posso direcionar sua questão para a equipe responsável.</discord-message><discord-message id=\"m-1446215271294435359\" timestamp=\"2025-12-04T19:03:10.057Z\" edited=\"false\" highlight=\"false\" profile=\"353601996646776832\">e os humano</discord-message><discord-message id=\"m-1446215277720109066\" timestamp=\"2025-12-04T19:03:11.589Z\" edited=\"false\" highlight=\"false\" profile=\"1003801622247383180\"><discord-mention type=\"user\">Anderson Prime</discord-mention>, Olá! Entendo que você gostaria de falar com um membro da equipe.<br/><br/>Vou encaminhar sua solicitação para que um staff possa te atender em breve. Por favor, aguarde no ticket que eles entrarão em contato! <discord-custom-emoji name=\"😊\" url=\"https://cdnjs.cloudflare.com/ajax/libs/twemoji/14.0.2/svg/1f60a.svg\" embed-emoji=\"false\"></discord-custom-emoji></discord-message><discord-message id=\"m-1446215311941435586\" timestamp=\"2025-12-04T19:03:19.748Z\" edited=\"false\" highlight=\"false\" profile=\"353601996646776832\">joia</discord-message><discord-message id=\"m-1446215316568018975\" timestamp=\"2025-12-04T19:03:20.851Z\" edited=\"false\" highlight=\"false\" profile=\"1003801622247383180\"><discord-mention type=\"user\">Anderson Prime</discord-mention>, Olá! Bem-vindo(a) ao Refúgio • Santa Catarina! <discord-custom-emoji name=\"✨\" url=\"https://cdnjs.cloudflare.com/ajax/libs/twemoji/14.0.2/svg/2728.svg\" embed-emoji=\"false\"></discord-custom-emoji><br/><br/>Que bom te ver por aqui! Como posso te ajudar hoje? <discord-custom-emoji name=\"😊\" url=\"https://cdnjs.cloudflare.com/ajax/libs/twemoji/14.0.2/svg/1f60a.svg\" embed-emoji=\"false\"></discord-custom-emoji></discord-message><discord-message id=\"m-1446215341599621161\" timestamp=\"2025-12-04T19:03:26.819Z\" edited=\"true\" server=\"false\" highlight=\"false\" profile=\"1003801622247383180\"><discord-reply slot=\"reply\">Message could not be loaded.</discord-reply><discord-embed embed-title=\"⚙️ Ticket fechado\" slot=\"embeds\" color=\"#2f3136\"><discord-embed-description slot=\"description\">Ticket fechado em 04/12/2025, 16:03:36 por <discord-mention type=\"user\">zsGabriel</discord-mention>!<br/>Este canal será deletado em 5 segundos.</discord-embed-description><discord-embed-fields slot=\"fields\"><discord-embed-field field-title=\"📦 **__Motivo do fechamento:__**\" inline=\"false\" inline-index=\"1\"><discord-code-block language=\"\" code=\"aeae\"></discord-code-block></discord-embed-field></discord-embed-fields><discord-embed-footer slot=\"footer\" footer-image=\"https://images-ext-1.discordapp.net/external/yLihPFx_FJKzd-UOjQ2RQepRLMFFzhNqekN8YKwk7N8/https/cdn.discordapp.com/avatars/1003801622247383180/a_24e84ba106cec0b4a5ed5cd3ac391f2c.gif\" timestamp=\"2025-12-04T19:03:36.432000+00:00\">REFÚGIO SC © Todos os direitos reservados.</discord-embed-footer></discord-embed></discord-message><discord-message id=\"m-1446215382913384653\" timestamp=\"2025-12-04T19:03:36.669Z\" edited=\"false\" highlight=\"false\" profile=\"1003801622247383180\">Vejo que nosso staffer <discord-mention type=\"user\">zsGabriel</discord-mention> veio te ajudar agora. Vou deixar vocês à vontade, e desejo um ótimo atendimento! <discord-custom-emoji name=\"😊\" url=\"https://cdnjs.cloudflare.com/ajax/libs/twemoji/14.0.2/svg/1f60a.svg\" embed-emoji=\"false\"></discord-custom-emoji></discord-message><discord-message id=\"m-1446215384180199660\" timestamp=\"2025-12-04T19:03:36.971Z\" edited=\"false\" highlight=\"false\" profile=\"1003801622247383180\"><discord-embed embed-title=\"Ticket assumido\" slot=\"embeds\" color=\"#2f3136\"><discord-embed-description slot=\"description\">O ticket foi assumido pelo staff <discord-mention type=\"user\">zsGabriel</discord-mention></discord-embed-description><discord-embed-footer slot=\"footer\" footer-image=\"https://images-ext-1.discordapp.net/external/yLihPFx_FJKzd-UOjQ2RQepRLMFFzhNqekN8YKwk7N8/https/cdn.discordapp.com/avatars/1003801622247383180/a_24e84ba106cec0b4a5ed5cd3ac391f2c.gif\" timestamp=\"2025-12-04T19:03:35.964000+00:00\">REFÚGIO SC © Todos os direitos reservados.</discord-embed-footer></discord-embed></discord-message><div style=\"text-align:center;width:100%\">Refúgio SC - Ticket Transcript </div></discord-messages></body></html>');
/*!40000 ALTER TABLE `refugio_tickets_history` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Table structure for table `refugio_user`
--

DROP TABLE IF EXISTS `refugio_user`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `refugio_user` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `discord` varchar(24) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  UNIQUE KEY `discord` (`discord`)
) ENGINE=InnoDB AUTO_INCREMENT=13118 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `refugio_user`
--

LOCK TABLES `refugio_user` WRITE;
/*!40000 ALTER TABLE `refugio_user` DISABLE KEYS */;
set autocommit=0;
INSERT INTO `refugio_user` VALUES
(13072,'1423479811145465877','2025-11-30 02:12:01','2025-11-30 02:12:01'),
(13073,'899365686323867688','2025-11-30 03:51:29','2025-11-30 03:51:29'),
(13074,'610681582671495189','2025-11-30 07:53:03','2025-11-30 07:53:03'),
(13075,'849514385638817813','2025-11-30 11:59:37','2025-11-30 11:59:37'),
(13076,'1370605830348734466','2025-11-30 17:06:27','2025-11-30 17:06:27'),
(13077,'811987630593146900','2025-11-30 17:23:55','2025-11-30 17:23:55'),
(13078,'400712876056117248','2025-12-01 11:59:39','2025-12-01 11:59:39'),
(13079,'1441215962924847214','2025-12-01 12:11:42','2025-12-01 12:11:42'),
(13080,'763107520565870643','2025-12-01 12:12:36','2025-12-01 12:12:36'),
(13081,'487617392516530178','2025-12-01 12:24:18','2025-12-01 12:24:18'),
(13082,'508804164827217921','2025-12-01 12:39:24','2025-12-01 12:39:24'),
(13083,'964947028520079402','2025-12-01 13:05:41','2025-12-01 13:05:41'),
(13084,'731568615207206924','2025-12-01 13:08:34','2025-12-01 13:08:34'),
(13085,'1037262819277672448','2025-12-01 14:46:18','2025-12-01 14:46:18'),
(13086,'879488525777637417','2025-12-01 14:59:39','2025-12-01 14:59:39'),
(13087,'1030593984793415831','2025-12-01 15:00:28','2025-12-01 15:00:28'),
(13088,'945538381591494697','2025-12-01 15:29:47','2025-12-01 15:29:47'),
(13089,'311181372557361162','2025-12-01 15:37:35','2025-12-01 15:37:35'),
(13090,'717168703514607669','2025-12-01 17:34:21','2025-12-01 17:34:21'),
(13091,'1029522293149421599','2025-12-01 21:54:06','2025-12-01 21:54:06'),
(13092,'1129474865582325820','2025-12-01 22:19:52','2025-12-01 22:19:52'),
(13093,'1420826068083937391','2025-12-02 01:27:59','2025-12-02 01:27:59'),
(13094,'934235845219745842','2025-12-02 02:10:30','2025-12-02 02:10:30'),
(13095,'770342774825287700','2025-12-02 02:31:08','2025-12-02 02:31:08'),
(13096,'840750850535981066','2025-12-02 05:28:02','2025-12-02 05:28:02'),
(13097,'1373729451367727325','2025-12-02 05:40:27','2025-12-02 05:40:27'),
(13098,'1166726532937560107','2025-12-02 06:23:32','2025-12-02 06:23:32'),
(13099,'1078422886446022859','2025-12-02 10:15:39','2025-12-02 10:15:39'),
(13100,'611975873830060046','2025-12-02 13:24:52','2025-12-02 13:24:52'),
(13101,'1409823748936437760','2025-12-02 20:38:41','2025-12-02 20:38:41'),
(13102,'835939869221584958','2025-12-02 20:42:41','2025-12-02 20:42:41'),
(13103,'1332332262024417291','2025-12-03 00:04:28','2025-12-03 00:04:28'),
(13104,'732234275235168406','2025-12-03 00:07:12','2025-12-03 00:07:12'),
(13105,'386914135486758912','2025-12-03 05:17:40','2025-12-03 05:17:40'),
(13106,'901294558736969740','2025-12-03 22:41:32','2025-12-03 22:41:32'),
(13107,'474721956789223427','2025-12-03 23:48:30','2025-12-03 23:48:30'),
(13108,'770036474724745266','2025-12-04 00:40:53','2025-12-04 00:40:53'),
(13109,'1442213571416293406','2025-12-04 00:58:18','2025-12-04 00:58:18'),
(13110,'659918884844994603','2025-12-04 01:27:05','2025-12-04 01:27:05'),
(13112,'1372678821324652616','2025-12-04 01:30:24','2025-12-04 01:30:24'),
(13113,'353601996646776832','2025-12-04 02:22:15','2025-12-04 02:22:15'),
(13114,'497842919835697162','2025-12-04 02:25:27','2025-12-04 02:25:27'),
(13115,'732343637672984648','2025-12-04 13:17:10','2025-12-04 13:17:10'),
(13116,'1050878089426645013','2025-12-04 13:23:16','2025-12-04 13:23:16'),
(13117,'1212213536848351236','2025-12-04 13:25:57','2025-12-04 13:25:57');
/*!40000 ALTER TABLE `refugio_user` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Table structure for table `refugio_username_pattern_advertence`
--

DROP TABLE IF EXISTS `refugio_username_pattern_advertence`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `refugio_username_pattern_advertence` (
  `discord_id` varchar(22) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `refugio_username_pattern_advertence`
--

LOCK TABLES `refugio_username_pattern_advertence` WRITE;
/*!40000 ALTER TABLE `refugio_username_pattern_advertence` DISABLE KEYS */;
set autocommit=0;
/*!40000 ALTER TABLE `refugio_username_pattern_advertence` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Table structure for table `sales`
--

DROP TABLE IF EXISTS `sales`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `sales` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `code` varchar(24) NOT NULL,
  `customer_id` bigint(20) unsigned NOT NULL,
  `product_name` varchar(128) NOT NULL,
  `description` varchar(512) DEFAULT NULL,
  `total_amount_cents` int(10) unsigned NOT NULL,
  `sale_type` enum('AVISTA','PARCELADO') NOT NULL,
  `installments_qtd` smallint(5) unsigned DEFAULT NULL,
  `installment_days` smallint(5) unsigned DEFAULT NULL,
  `status` enum('PENDING_PAYMENT','AWAITING_APPROVAL','ACTIVE','CANCELED','COMPLETED','OVERDUE') NOT NULL DEFAULT 'PENDING_PAYMENT',
  `selected_wallet_id` smallint(5) unsigned NOT NULL,
  `created_by_staff` varchar(32) DEFAULT NULL,
  `created_at` datetime NOT NULL DEFAULT current_timestamp(),
  `updated_at` datetime NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  UNIQUE KEY `code` (`code`),
  KEY `fk_sales_wallet` (`selected_wallet_id`),
  KEY `idx_sales_customer` (`customer_id`),
  KEY `idx_sales_status` (`status`),
  KEY `idx_sales_code` (`code`),
  CONSTRAINT `fk_sales_customer` FOREIGN KEY (`customer_id`) REFERENCES `customers` (`id`),
  CONSTRAINT `fk_sales_wallet` FOREIGN KEY (`selected_wallet_id`) REFERENCES `pix_wallets` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=44 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_uca1400_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sales`
--

LOCK TABLES `sales` WRITE;
/*!40000 ALTER TABLE `sales` DISABLE KEYS */;
set autocommit=0;
INSERT INTO `sales` VALUES
(3,'RS-MFLJGPJX4J8',2,'Nissan R35 Diamonds',NULL,35000,'PARCELADO',2,30,'CANCELED',1,'400712876056117248','2025-09-15 16:50:27','2025-10-17 19:53:41'),
(4,'RS-MFLUGLUGZE0',3,'peptos_h2',NULL,12000,'AVISTA',NULL,NULL,'PENDING_PAYMENT',1,'735724009056108566','2025-09-15 21:58:18','2025-09-15 21:58:18'),
(5,'RS-MFLULOEQUF4',4,'Supra Diamonds Limitado',NULL,24000,'AVISTA',NULL,NULL,'COMPLETED',1,'400712876056117248','2025-09-15 22:02:14','2025-09-15 22:26:28'),
(6,'RS-MFLUTTP355H',5,'bmwxm',NULL,28000,'AVISTA',NULL,NULL,'PENDING_PAYMENT',2,'798657333609103431','2025-09-15 22:08:34','2025-09-15 22:08:34'),
(7,'RS-MFLVJRMPUMA',6,'saveiro g7 som',NULL,10500,'PARCELADO',3,30,'CANCELED',2,'400712876056117248','2025-09-15 22:28:45','2025-10-17 19:53:28'),
(8,'RS-MFLZDHWNJSJ',7,'BMWXM',NULL,27000,'PARCELADO',5,30,'OVERDUE',2,'735724009056108566','2025-09-16 00:15:51','2025-10-16 04:00:00'),
(9,'RS-MFNGVYEK9PP',8,'Silvia 16 tiros','VG',28000,'PARCELADO',3,30,'OVERDUE',2,'798657333609103431','2025-09-17 01:13:51','2025-10-17 05:00:00'),
(10,'RS-MFUDCVNCUGD',9,'blindado 32 tiros','133,00 por semana',40000,'PARCELADO',3,7,'OVERDUE',2,'798657333609103431','2025-09-21 21:09:26','2025-09-22 01:00:00'),
(11,'RS-MFVU7Q640AB',3,'Amarok com SOM',NULL,15000,'PARCELADO',3,15,'OVERDUE',2,'400712876056117248','2025-09-22 21:49:05','2025-10-23 01:00:00'),
(12,'RS-MFVVSX8NEDR',10,'G65 32 tiros',NULL,80000,'PARCELADO',4,30,'OVERDUE',2,'735724009056108566','2025-09-22 22:33:34','2025-10-23 02:00:00'),
(13,'RS-MFYOXM5C3HT',11,'R34 mini dragon exclusivo',NULL,30000,'AVISTA',NULL,NULL,'COMPLETED',2,'400712876056117248','2025-09-24 21:44:34','2025-09-24 21:46:26'),
(14,'RS-MFYOYYF3L7Q',12,'amarock com som',NULL,16000,'AVISTA',NULL,NULL,'AWAITING_APPROVAL',2,'735724009056108566','2025-09-24 21:45:36','2025-09-24 21:48:29'),
(15,'RS-MFYPDCX3HJW',12,'tearing2',NULL,9000,'AVISTA',NULL,NULL,'COMPLETED',2,'735724009056108566','2025-09-24 21:56:48','2025-09-24 22:11:21'),
(16,'RS-MFZZCJALIA9',13,'Silvia s15 purple',NULL,30000,'PARCELADO',3,11,'CANCELED',2,'400712876056117248','2025-09-25 19:23:52','2025-09-29 21:26:50'),
(18,'RS-MG1V99LJ93H',14,'LuxuryG652','sera pago em 1 parcela a vista',40000,'PARCELADO',2,13,'CANCELED',2,'798657333609103431','2025-09-27 03:04:54','2025-10-09 16:38:01'),
(19,'RS-MG2VUKRL9N4',3,'Mansão Vinewood',NULL,50000,'PARCELADO',4,15,'OVERDUE',2,'400712876056117248','2025-09-27 20:09:14','2025-10-28 00:00:00'),
(20,'RS-MG4E36YAPM4',15,'Cullinan 32t',NULL,33000,'PARCELADO',3,5,'CANCELED',2,'400712876056117248','2025-09-28 21:27:35','2025-10-09 16:34:45'),
(21,'RS-MG5P6PPGEZM',16,'Casa Exclusiva PlinPlin',NULL,65000,'PARCELADO',2,30,'OVERDUE',2,'400712876056117248','2025-09-29 19:26:02','2025-10-29 23:00:00'),
(22,'RS-MG5TKFPXM71',13,'Supra mod',NULL,50000,'PARCELADO',2,6,'OVERDUE',2,'400712876056117248','2025-09-29 21:28:40','2025-09-30 01:00:00'),
(23,'RS-MG5TSL5HKJA',17,'Segurar AMAROK',NULL,2000,'AVISTA',NULL,NULL,'COMPLETED',2,'400712876056117248','2025-09-29 21:35:01','2025-09-29 21:36:21'),
(24,'RS-MG5XV3FIRP5',18,'Jarl',NULL,3850,'AVISTA',NULL,NULL,'COMPLETED',2,'400712876056117248','2025-09-29 23:28:56','2025-09-29 23:35:22'),
(25,'RS-MG8PI12OZA9',19,'Opala SS Diamonds',NULL,9000,'AVISTA',NULL,NULL,'PENDING_PAYMENT',2,'400712876056117248','2025-10-01 21:58:08','2025-10-01 21:58:08'),
(34,'RS-MGBTXF897G2',21,'X6 16 tiros + remap',NULL,30000,'AVISTA',NULL,NULL,'COMPLETED',2,'735724009056108566','2025-10-04 02:25:23','2025-10-06 01:10:09'),
(35,'RS-MGD4ZD6CRB5',9,'silvia 16 tiros + remap',NULL,30000,'PARCELADO',3,30,'ACTIVE',2,'798657333609103431','2025-10-05 00:22:36','2025-11-03 21:24:53'),
(36,'RS-MGELLQTTOU5',22,'Mansao Exclusiva Teixeira',NULL,74000,'PARCELADO',4,30,'OVERDUE',2,'400712876056117248','2025-10-06 00:55:40','2025-11-05 04:00:00'),
(37,'RS-MGFU4EHC5D3',23,'r35 fucki',NULL,18000,'PARCELADO',2,30,'OVERDUE',2,'400712876056117248','2025-10-06 21:41:54','2025-11-06 01:00:00'),
(38,'RS-MGFUNVFH86H',17,'Hilux',NULL,13000,'AVISTA',NULL,NULL,'AWAITING_APPROVAL',2,'400712876056117248','2025-10-06 21:57:02','2025-10-06 21:57:46'),
(39,'RS-MGFUPDCFIW9',19,'r34 candylove',NULL,18000,'PARCELADO',2,30,'OVERDUE',2,'400712876056117248','2025-10-06 21:58:12','2025-11-06 01:00:00'),
(40,'RS-MGFVIZV7PYG',17,'audi a3 teto',NULL,7500,'AVISTA',NULL,NULL,'COMPLETED',2,'400712876056117248','2025-10-06 22:21:14','2025-10-06 22:22:24'),
(41,'RS-MGINYYQWDFB',24,'Opala',NULL,11000,'PARCELADO',2,30,'COMPLETED',2,'400712876056117248','2025-10-08 21:13:01','2025-11-01 20:25:01'),
(42,'RS-MGIOGF0WZE2',13,'Hilux',NULL,15000,'PARCELADO',2,30,'OVERDUE',2,'400712876056117248','2025-10-08 21:26:35','2025-11-08 01:00:00'),
(43,'RS-MGJZQKNCVRY',17,'Guacamole',NULL,46000,'PARCELADO',2,30,'OVERDUE',2,'400712876056117248','2025-10-09 19:30:11','2025-10-09 23:00:00');
/*!40000 ALTER TABLE `sales` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Table structure for table `suggestions`
--

DROP TABLE IF EXISTS `suggestions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `suggestions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `message_id` varchar(255) NOT NULL,
  `suggestion_text` text NOT NULL,
  `user_id` varchar(255) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=495 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `suggestions`
--

LOCK TABLES `suggestions` WRITE;
/*!40000 ALTER TABLE `suggestions` DISABLE KEYS */;
set autocommit=0;
/*!40000 ALTER TABLE `suggestions` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Table structure for table `votes`
--

DROP TABLE IF EXISTS `votes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `votes` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `suggestion_id` int(11) NOT NULL,
  `user_id` varchar(255) NOT NULL,
  `vote_type` enum('accept','deny') NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `suggestion_id` (`suggestion_id`),
  CONSTRAINT `votes_ibfk_1` FOREIGN KEY (`suggestion_id`) REFERENCES `suggestions` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=11883 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `votes`
--

LOCK TABLES `votes` WRITE;
/*!40000 ALTER TABLE `votes` DISABLE KEYS */;
set autocommit=0;
/*!40000 ALTER TABLE `votes` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Temporary table structure for view `vw_parcelas_status`
--

DROP TABLE IF EXISTS `vw_parcelas_status`;
/*!50001 DROP VIEW IF EXISTS `vw_parcelas_status`*/;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8mb4;
/*!50001 CREATE VIEW `vw_parcelas_status` AS SELECT
 1 AS `sale_id`,
  1 AS `total_parcelas`,
  1 AS `parcelas_pagas`,
  1 AS `parcelas_pendentes`,
  1 AS `parcelas_atrasadas`,
  1 AS `valor_total_parcelas`,
  1 AS `valor_pago`,
  1 AS `saldo_pendente` */;
SET character_set_client = @saved_cs_client;

--
-- Temporary table structure for view `vw_pending_approvals`
--

DROP TABLE IF EXISTS `vw_pending_approvals`;
/*!50001 DROP VIEW IF EXISTS `vw_pending_approvals`*/;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8mb4;
/*!50001 CREATE VIEW `vw_pending_approvals` AS SELECT
 1 AS `payment_id`,
  1 AS `sale_code`,
  1 AS `product_name`,
  1 AS `installment_index`,
  1 AS `amount_cents`,
  1 AS `created_by`,
  1 AS `created_at`,
  1 AS `customer_username`,
  1 AS `days_waiting` */;
SET character_set_client = @saved_cs_client;

--
-- Temporary table structure for view `vw_sales_overview`
--

DROP TABLE IF EXISTS `vw_sales_overview`;
/*!50001 DROP VIEW IF EXISTS `vw_sales_overview`*/;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8mb4;
/*!50001 CREATE VIEW `vw_sales_overview` AS SELECT
 1 AS `id`,
  1 AS `code`,
  1 AS `sale_type`,
  1 AS `status`,
  1 AS `total_amount_cents`,
  1 AS `installments_qtd`,
  1 AS `created_at`,
  1 AS `updated_at`,
  1 AS `customer_discord_id`,
  1 AS `customer_username`,
  1 AS `wallet_label` */;
SET character_set_client = @saved_cs_client;

--
-- Temporary table structure for view `vw_scheduled_reminders`
--

DROP TABLE IF EXISTS `vw_scheduled_reminders`;
/*!50001 DROP VIEW IF EXISTS `vw_scheduled_reminders`*/;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8mb4;
/*!50001 CREATE VIEW `vw_scheduled_reminders` AS SELECT
 1 AS `id`,
  1 AS `sale_id`,
  1 AS `sale_code`,
  1 AS `installment_index`,
  1 AS `schedule_type`,
  1 AS `run_at`,
  1 AS `executed_at`,
  1 AS `canceled_at`,
  1 AS `customer_discord_id`,
  1 AS `reminder_status` */;
SET character_set_client = @saved_cs_client;

--
-- Final view structure for view `vw_parcelas_status`
--

/*!50001 DROP VIEW IF EXISTS `vw_parcelas_status`*/;
/*!50001 SET @saved_cs_client          = @@character_set_client */;
/*!50001 SET @saved_cs_results         = @@character_set_results */;
/*!50001 SET @saved_col_connection     = @@collation_connection */;
/*!50001 SET character_set_client      = utf8mb4 */;
/*!50001 SET character_set_results     = utf8mb4 */;
/*!50001 SET collation_connection      = utf8mb4_uca1400_ai_ci */;
/*!50001 CREATE ALGORITHM=UNDEFINED */
/*!50013 DEFINER=`root`@`localhost` SQL SECURITY DEFINER */
/*!50001 VIEW `vw_parcelas_status` AS select `i`.`sale_id` AS `sale_id`,count(0) AS `total_parcelas`,sum(`i`.`status` = 'PAID') AS `parcelas_pagas`,sum(`i`.`status` = 'PENDING') AS `parcelas_pendentes`,sum(`i`.`status` = 'OVERDUE') AS `parcelas_atrasadas`,sum(`i`.`amount_cents`) AS `valor_total_parcelas`,sum(case when `i`.`status` = 'PAID' then `i`.`amount_cents` else 0 end) AS `valor_pago`,sum(`i`.`amount_cents`) - sum(case when `i`.`status` = 'PAID' then `i`.`amount_cents` else 0 end) AS `saldo_pendente` from `installments` `i` group by `i`.`sale_id` */;
/*!50001 SET character_set_client      = @saved_cs_client */;
/*!50001 SET character_set_results     = @saved_cs_results */;
/*!50001 SET collation_connection      = @saved_col_connection */;

--
-- Final view structure for view `vw_pending_approvals`
--

/*!50001 DROP VIEW IF EXISTS `vw_pending_approvals`*/;
/*!50001 SET @saved_cs_client          = @@character_set_client */;
/*!50001 SET @saved_cs_results         = @@character_set_results */;
/*!50001 SET @saved_col_connection     = @@collation_connection */;
/*!50001 SET character_set_client      = utf8mb4 */;
/*!50001 SET character_set_results     = utf8mb4 */;
/*!50001 SET collation_connection      = utf8mb4_uca1400_ai_ci */;
/*!50001 CREATE ALGORITHM=UNDEFINED */
/*!50013 DEFINER=`root`@`localhost` SQL SECURITY DEFINER */
/*!50001 VIEW `vw_pending_approvals` AS select `p`.`id` AS `payment_id`,`s`.`code` AS `sale_code`,`s`.`product_name` AS `product_name`,`p`.`installment_index` AS `installment_index`,`p`.`amount_cents` AS `amount_cents`,`p`.`created_by` AS `created_by`,`p`.`created_at` AS `created_at`,`c`.`username` AS `customer_username`,to_days(current_timestamp()) - to_days(`p`.`created_at`) AS `days_waiting` from ((`payments` `p` join `sales` `s` on(`s`.`id` = `p`.`sale_id`)) join `customers` `c` on(`c`.`id` = `s`.`customer_id`)) where `p`.`status` = 'PENDING' order by `p`.`created_at` */;
/*!50001 SET character_set_client      = @saved_cs_client */;
/*!50001 SET character_set_results     = @saved_cs_results */;
/*!50001 SET collation_connection      = @saved_col_connection */;

--
-- Final view structure for view `vw_sales_overview`
--

/*!50001 DROP VIEW IF EXISTS `vw_sales_overview`*/;
/*!50001 SET @saved_cs_client          = @@character_set_client */;
/*!50001 SET @saved_cs_results         = @@character_set_results */;
/*!50001 SET @saved_col_connection     = @@collation_connection */;
/*!50001 SET character_set_client      = utf8mb4 */;
/*!50001 SET character_set_results     = utf8mb4 */;
/*!50001 SET collation_connection      = utf8mb4_uca1400_ai_ci */;
/*!50001 CREATE ALGORITHM=UNDEFINED */
/*!50013 DEFINER=`root`@`localhost` SQL SECURITY DEFINER */
/*!50001 VIEW `vw_sales_overview` AS select `s`.`id` AS `id`,`s`.`code` AS `code`,`s`.`sale_type` AS `sale_type`,`s`.`status` AS `status`,`s`.`total_amount_cents` AS `total_amount_cents`,`s`.`installments_qtd` AS `installments_qtd`,`s`.`created_at` AS `created_at`,`s`.`updated_at` AS `updated_at`,`c`.`discord_id` AS `customer_discord_id`,`c`.`username` AS `customer_username`,`pw`.`label` AS `wallet_label` from ((`sales` `s` join `customers` `c` on(`c`.`id` = `s`.`customer_id`)) join `pix_wallets` `pw` on(`pw`.`id` = `s`.`selected_wallet_id`)) */;
/*!50001 SET character_set_client      = @saved_cs_client */;
/*!50001 SET character_set_results     = @saved_cs_results */;
/*!50001 SET collation_connection      = @saved_col_connection */;

--
-- Final view structure for view `vw_scheduled_reminders`
--

/*!50001 DROP VIEW IF EXISTS `vw_scheduled_reminders`*/;
/*!50001 SET @saved_cs_client          = @@character_set_client */;
/*!50001 SET @saved_cs_results         = @@character_set_results */;
/*!50001 SET @saved_col_connection     = @@collation_connection */;
/*!50001 SET character_set_client      = utf8mb4 */;
/*!50001 SET character_set_results     = utf8mb4 */;
/*!50001 SET collation_connection      = utf8mb4_uca1400_ai_ci */;
/*!50001 CREATE ALGORITHM=UNDEFINED */
/*!50013 DEFINER=`root`@`localhost` SQL SECURITY DEFINER */
/*!50001 VIEW `vw_scheduled_reminders` AS select `dm`.`id` AS `id`,`dm`.`sale_id` AS `sale_id`,`s`.`code` AS `sale_code`,`dm`.`installment_index` AS `installment_index`,`dm`.`schedule_type` AS `schedule_type`,`dm`.`run_at` AS `run_at`,`dm`.`executed_at` AS `executed_at`,`dm`.`canceled_at` AS `canceled_at`,`c`.`discord_id` AS `customer_discord_id`,case when `dm`.`executed_at` is not null then 'EXECUTED' when `dm`.`canceled_at` is not null then 'CANCELED' when `dm`.`run_at` <= current_timestamp() then 'OVERDUE' else 'PENDING' end AS `reminder_status` from ((`dm_schedules` `dm` join `sales` `s` on(`s`.`id` = `dm`.`sale_id`)) join `customers` `c` on(`c`.`id` = `s`.`customer_id`)) order by `dm`.`run_at` */;
/*!50001 SET character_set_client      = @saved_cs_client */;
/*!50001 SET character_set_results     = @saved_cs_results */;
/*!50001 SET collation_connection      = @saved_col_connection */;
/*!40103 SET TIME_ZONE=@OLD_TIME_ZONE */;

/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40014 SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
/*M!100616 SET NOTE_VERBOSITY=@OLD_NOTE_VERBOSITY */;

-- Dump completed on 2025-12-04 22:49:08
